/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.opponentinfo;

import com.google.inject.Provides;
import java.time.Duration;
import java.time.Instant;
import java.util.EnumSet;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.WorldType;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.InteractingChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.opponentinfo.OpponentInfoConfig;
import net.runelite.client.plugins.opponentinfo.OpponentInfoOverlay;
import net.runelite.client.plugins.opponentinfo.PlayerComparisonOverlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.http.api.hiscore.HiscoreEndpoint;

@PluginDescriptor(name="Opponent Information", description="Show name and hitpoints information about the NPC you are fighting", tags={"combat", "health", "hitpoints", "npcs", "overlay"})
public class OpponentInfoPlugin
extends Plugin {
    private static final Duration WAIT = Duration.ofSeconds(5L);
    @Inject
    private Client client;
    @Inject
    private OpponentInfoConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private OpponentInfoOverlay opponentInfoOverlay;
    @Inject
    private PlayerComparisonOverlay playerComparisonOverlay;
    private HiscoreEndpoint hiscoreEndpoint = HiscoreEndpoint.NORMAL;
    private Actor lastOpponent;
    private Instant lastTime;

    @Provides
    OpponentInfoConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(OpponentInfoConfig.class);
    }

    @Override
    protected void startUp() throws Exception {
        this.overlayManager.add(this.opponentInfoOverlay);
        this.overlayManager.add(this.playerComparisonOverlay);
    }

    @Override
    protected void shutDown() throws Exception {
        this.lastOpponent = null;
        this.lastTime = null;
        this.overlayManager.remove(this.opponentInfoOverlay);
        this.overlayManager.remove(this.playerComparisonOverlay);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        EnumSet<WorldType> worldType = this.client.getWorldType();
        this.hiscoreEndpoint = worldType.contains((Object)WorldType.DEADMAN_TOURNAMENT) ? HiscoreEndpoint.DEADMAN_TOURNAMENT : (worldType.contains((Object)WorldType.SEASONAL_DEADMAN) ? HiscoreEndpoint.SEASONAL_DEADMAN : (worldType.contains((Object)WorldType.DEADMAN) ? HiscoreEndpoint.DEADMAN : HiscoreEndpoint.NORMAL));
    }

    @Subscribe
    public void onInteractingChanged(InteractingChanged event) {
        if (event.getSource() != this.client.getLocalPlayer()) {
            return;
        }
        Actor opponent = event.getTarget();
        if (opponent == null) {
            this.lastTime = Instant.now();
            return;
        }
        this.lastOpponent = opponent;
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        if (this.lastOpponent != null && this.lastTime != null && this.client.getLocalPlayer().getInteracting() == null && Duration.between(this.lastTime, Instant.now()).compareTo(WAIT) > 0) {
            this.lastOpponent = null;
        }
    }

    HiscoreEndpoint getHiscoreEndpoint() {
        return this.hiscoreEndpoint;
    }

    Actor getLastOpponent() {
        return this.lastOpponent;
    }
}

