/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.opponentinfo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.Varbits;
import net.runelite.client.game.HiscoreManager;
import net.runelite.client.game.NPCManager;
import net.runelite.client.plugins.opponentinfo.OpponentInfoConfig;
import net.runelite.client.plugins.opponentinfo.OpponentInfoPlugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.components.ProgressBarComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;
import net.runelite.client.util.Text;
import net.runelite.http.api.hiscore.HiscoreResult;

class OpponentInfoOverlay
extends Overlay {
    private static final Color HP_GREEN = new Color(0, 146, 54, 230);
    private static final Color HP_RED = new Color(102, 15, 16, 230);
    private final Client client;
    private final OpponentInfoPlugin opponentInfoPlugin;
    private final OpponentInfoConfig opponentInfoConfig;
    private final HiscoreManager hiscoreManager;
    private final NPCManager npcManager;
    private final PanelComponent panelComponent = new PanelComponent();
    private Integer lastMaxHealth;
    private int lastRatio = 0;
    private int lastHealthScale = 0;
    private String opponentName;
    private String opponentsOpponentName;

    @Inject
    private OpponentInfoOverlay(Client client2, OpponentInfoPlugin opponentInfoPlugin, OpponentInfoConfig opponentInfoConfig, HiscoreManager hiscoreManager, NPCManager npcManager) {
        super(opponentInfoPlugin);
        this.client = client2;
        this.opponentInfoPlugin = opponentInfoPlugin;
        this.opponentInfoConfig = opponentInfoConfig;
        this.hiscoreManager = hiscoreManager;
        this.npcManager = npcManager;
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.setPriority(OverlayPriority.HIGH);
        this.panelComponent.setBorder(new Rectangle(2, 2, 2, 2));
        this.panelComponent.setGap(new Point(0, 2));
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Opponent info overlay"));
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        Actor opponent = this.opponentInfoPlugin.getLastOpponent();
        if (opponent == null) {
            this.opponentName = null;
            return null;
        }
        if (opponent.getName() != null && opponent.getHealth() > 0) {
            int hp;
            HiscoreResult hiscoreResult;
            this.lastRatio = opponent.getHealthRatio();
            this.lastHealthScale = opponent.getHealth();
            this.opponentName = Text.removeTags(opponent.getName());
            this.lastMaxHealth = null;
            if (opponent instanceof NPC) {
                this.lastMaxHealth = this.npcManager.getHealth(this.opponentName, opponent.getCombatLevel());
            } else if (opponent instanceof Player && (hiscoreResult = this.hiscoreManager.lookupAsync(this.opponentName, this.opponentInfoPlugin.getHiscoreEndpoint())) != null && (hp = hiscoreResult.getHitpoints().getLevel()) > 0) {
                this.lastMaxHealth = hp;
            }
            Actor opponentsOpponent = opponent.getInteracting();
            this.opponentsOpponentName = opponentsOpponent != null && (opponentsOpponent != this.client.getLocalPlayer() || this.client.getVar(Varbits.MULTICOMBAT_AREA) == 1) ? Text.removeTags(opponentsOpponent.getName()) : null;
        }
        if (this.opponentName == null) {
            return null;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        this.panelComponent.getChildren().clear();
        int textWidth = Math.max(129, fontMetrics.stringWidth(this.opponentName));
        this.panelComponent.setPreferredSize(new Dimension(textWidth, 0));
        this.panelComponent.getChildren().add(TitleComponent.builder().text(this.opponentName).build());
        if (this.lastRatio >= 0 && this.lastHealthScale > 0) {
            ProgressBarComponent progressBarComponent = new ProgressBarComponent();
            progressBarComponent.setBackgroundColor(HP_RED);
            progressBarComponent.setForegroundColor(HP_GREEN);
            if (this.lastMaxHealth != null && !this.opponentInfoConfig.showPercent()) {
                int health = 0;
                if (this.lastRatio > 0) {
                    int maxHealth;
                    int minHealth = 1;
                    if (this.lastHealthScale > 1) {
                        if (this.lastRatio > 1) {
                            minHealth = (this.lastMaxHealth * (this.lastRatio - 1) + this.lastHealthScale - 2) / (this.lastHealthScale - 1);
                        }
                        if ((maxHealth = (this.lastMaxHealth * this.lastRatio - 1) / (this.lastHealthScale - 1)) > this.lastMaxHealth) {
                            maxHealth = this.lastMaxHealth;
                        }
                    } else {
                        maxHealth = this.lastMaxHealth;
                    }
                    health = (minHealth + maxHealth + 1) / 2;
                }
                progressBarComponent.setLabelDisplayMode(ProgressBarComponent.LabelDisplayMode.FULL);
                progressBarComponent.setMaximum(this.lastMaxHealth.intValue());
                progressBarComponent.setValue(health);
            } else {
                float floatRatio = (float)this.lastRatio / (float)this.lastHealthScale;
                progressBarComponent.setValue((double)floatRatio * 100.0);
            }
            this.panelComponent.getChildren().add(progressBarComponent);
        }
        if (this.opponentsOpponentName != null && this.opponentInfoConfig.showOpponentsOpponent()) {
            textWidth = Math.max(textWidth, fontMetrics.stringWidth(this.opponentsOpponentName));
            this.panelComponent.setPreferredSize(new Dimension(textWidth, 0));
            this.panelComponent.getChildren().add(TitleComponent.builder().text(this.opponentsOpponentName).build());
        }
        return this.panelComponent.render(graphics);
    }
}

