/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.objectindicators;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Provides;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.DecorativeObject;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.ObjectComposition;
import net.runelite.api.Scene;
import net.runelite.api.Tile;
import net.runelite.api.TileObject;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.DecorativeObjectDespawned;
import net.runelite.api.events.DecorativeObjectSpawned;
import net.runelite.api.events.FocusChanged;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.objectindicators.ObjectIndicatorsConfig;
import net.runelite.client.plugins.objectindicators.ObjectIndicatorsOverlay;
import net.runelite.client.plugins.objectindicators.ObjectPoint;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Object Markers", description="Enable marking of objects using the Shift key", tags={"overlay", "objects", "mark", "marker"}, enabledByDefault=false)
public class ObjectIndicatorsPlugin
extends Plugin
implements KeyListener {
    private static final Logger log = LoggerFactory.getLogger(ObjectIndicatorsPlugin.class);
    private static final String CONFIG_GROUP = "objectindicators";
    private static final String MARK = "Mark object";
    private final Gson GSON = new Gson();
    private final List<TileObject> objects = new ArrayList<TileObject>();
    private final Map<Integer, Set<ObjectPoint>> points = new HashMap<Integer, Set<ObjectPoint>>();
    private boolean hotKeyPressed;
    @Inject
    private Client client;
    @Inject
    private ConfigManager configManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ObjectIndicatorsOverlay overlay;
    @Inject
    private KeyManager keyManager;

    @Provides
    ObjectIndicatorsConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(ObjectIndicatorsConfig.class);
    }

    @Override
    protected void startUp() {
        this.overlayManager.add(this.overlay);
        this.keyManager.registerKeyListener(this);
    }

    @Override
    protected void shutDown() {
        this.overlayManager.remove(this.overlay);
        this.keyManager.unregisterKeyListener(this);
        this.points.clear();
        this.objects.clear();
        this.hotKeyPressed = false;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 16) {
            this.hotKeyPressed = true;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 16) {
            this.hotKeyPressed = false;
        }
    }

    @Subscribe
    public void onFocusChanged(FocusChanged event) {
        if (!event.isFocused()) {
            this.hotKeyPressed = false;
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        GameObject eventObject = event.getGameObject();
        this.checkObjectPoints(eventObject);
    }

    @Subscribe
    public void onDecorativeObjectSpawned(DecorativeObjectSpawned event) {
        DecorativeObject eventObject = event.getDecorativeObject();
        this.checkObjectPoints(eventObject);
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned event) {
        this.objects.remove(event.getGameObject());
    }

    @Subscribe
    public void onDecorativeObjectDespawned(DecorativeObjectDespawned event) {
        this.objects.remove(event.getDecorativeObject());
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        GameState gameState = gameStateChanged.getGameState();
        if (gameState == GameState.LOADING) {
            this.points.clear();
            for (int regionId : this.client.getMapRegions()) {
                Set<ObjectPoint> regionPoints = this.loadPoints(regionId);
                if (regionPoints == null) continue;
                this.points.put(regionId, regionPoints);
            }
        }
        if (gameStateChanged.getGameState() != GameState.LOGGED_IN) {
            this.objects.clear();
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        if (!this.hotKeyPressed || event.getType() != MenuAction.EXAMINE_OBJECT.getId()) {
            return;
        }
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        menuEntries = Arrays.copyOf(menuEntries, menuEntries.length + 1);
        MenuEntry menuEntry = new MenuEntry();
        menuEntries[menuEntries.length - 1] = menuEntry;
        MenuEntry menuEntry2 = menuEntry;
        menuEntry2.setOption(MARK);
        menuEntry2.setTarget(event.getTarget());
        menuEntry2.setParam0(event.getActionParam0());
        menuEntry2.setParam1(event.getActionParam1());
        menuEntry2.setIdentifier(event.getIdentifier());
        menuEntry2.setType(MenuAction.RUNELITE.getId());
        this.client.setMenuEntries(menuEntries);
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (event.getMenuAction() != MenuAction.RUNELITE || !event.getMenuOption().equals(MARK)) {
            return;
        }
        Scene scene = this.client.getScene();
        Tile[][][] tiles = scene.getTiles();
        int x = event.getActionParam();
        int y = event.getWidgetId();
        int z = this.client.getPlane();
        Tile tile = tiles[z][x][y];
        TileObject object = this.findTileObject(tile, event.getId());
        if (object == null) {
            return;
        }
        ObjectComposition objectDefinition = this.client.getObjectDefinition(object.getId());
        String name = objectDefinition.getName();
        if (Strings.isNullOrEmpty(name)) {
            return;
        }
        this.markObject(name, object);
    }

    private void checkObjectPoints(TileObject object) {
        WorldPoint worldPoint = WorldPoint.fromLocalInstance(this.client, object.getLocalLocation());
        Set<ObjectPoint> objectPoints = this.points.get(worldPoint.getRegionID());
        if (objectPoints == null) {
            return;
        }
        for (ObjectPoint objectPoint : objectPoints) {
            if ((worldPoint.getX() & 0x3F) != objectPoint.getRegionX() || (worldPoint.getY() & 0x3F) != objectPoint.getRegionY() || !objectPoint.getName().equals(this.client.getObjectDefinition(object.getId()).getName())) continue;
            this.objects.add(object);
            break;
        }
    }

    private TileObject findTileObject(Tile tile, int id) {
        if (tile == null) {
            return null;
        }
        GameObject[] tileGameObjects = tile.getGameObjects();
        DecorativeObject tileDecorativeObject = tile.getDecorativeObject();
        if (tileDecorativeObject != null && tileDecorativeObject.getId() == id) {
            return tileDecorativeObject;
        }
        for (GameObject object : tileGameObjects) {
            if (object == null) continue;
            if (object.getId() == id) {
                return object;
            }
            ObjectComposition comp = this.client.getObjectDefinition(object.getId());
            if (comp.getImpostorIds() == null) continue;
            for (int impostorId : comp.getImpostorIds()) {
                if (impostorId != id) continue;
                return object;
            }
        }
        return null;
    }

    private void markObject(String name, TileObject object) {
        if (object == null) {
            return;
        }
        WorldPoint worldPoint = WorldPoint.fromLocalInstance(this.client, object.getLocalLocation());
        int regionId = worldPoint.getRegionID();
        ObjectPoint point = new ObjectPoint(name, regionId, worldPoint.getX() & 0x3F, worldPoint.getY() & 0x3F, this.client.getPlane());
        Set objectPoints = this.points.computeIfAbsent(regionId, k -> new HashSet());
        if (objectPoints.contains(point)) {
            objectPoints.remove(point);
            this.objects.remove(object);
        } else {
            objectPoints.add(point);
            this.objects.add(object);
        }
        this.savePoints(regionId, objectPoints);
    }

    private void savePoints(int id, Set<ObjectPoint> points) {
        if (points.isEmpty()) {
            this.configManager.unsetConfiguration(CONFIG_GROUP, "region_" + id);
        } else {
            String json = this.GSON.toJson(points);
            this.configManager.setConfiguration(CONFIG_GROUP, "region_" + id, json);
        }
    }

    private Set<ObjectPoint> loadPoints(int id) {
        String json = this.configManager.getConfiguration(CONFIG_GROUP, "region_" + id);
        if (Strings.isNullOrEmpty(json)) {
            return null;
        }
        return (Set)this.GSON.fromJson(json, new TypeToken<Set<ObjectPoint>>(){}.getType());
    }

    List<TileObject> getObjects() {
        return this.objects;
    }
}

