/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.objectindicators;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.DecorativeObject;
import net.runelite.api.GameObject;
import net.runelite.api.TileObject;
import net.runelite.client.plugins.objectindicators.ObjectIndicatorsConfig;
import net.runelite.client.plugins.objectindicators.ObjectIndicatorsPlugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;

class ObjectIndicatorsOverlay
extends Overlay {
    private final Client client;
    private final ObjectIndicatorsConfig config;
    private final ObjectIndicatorsPlugin plugin;

    @Inject
    private ObjectIndicatorsOverlay(Client client2, ObjectIndicatorsConfig config, ObjectIndicatorsPlugin plugin) {
        this.client = client2;
        this.config = config;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        for (TileObject object : this.plugin.getObjects()) {
            Polygon polygon;
            if (object.getPlane() != this.client.getPlane()) continue;
            Polygon polygon2 = null;
            if (object instanceof GameObject) {
                polygon = ((GameObject)object).getConvexHull();
            } else if (object instanceof DecorativeObject) {
                polygon = ((DecorativeObject)object).getConvexHull();
                polygon2 = ((DecorativeObject)object).getConvexHull2();
            } else {
                polygon = object.getCanvasTilePoly();
            }
            if (polygon != null) {
                OverlayUtil.renderPolygon(graphics, polygon, this.config.markerColor());
            }
            if (polygon2 == null) continue;
            OverlayUtil.renderPolygon(graphics, polygon2, this.config.markerColor());
        }
        return null;
    }
}

