/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.npcunaggroarea;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.inject.Provides;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.NPCComposition;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldArea;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ConfigChanged;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.geometry.Geometry;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.AsyncBufferedImage;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.npcunaggroarea.AggressionTimer;
import net.runelite.client.plugins.npcunaggroarea.NpcAggroAreaConfig;
import net.runelite.client.plugins.npcunaggroarea.NpcAggroAreaNotWorkingOverlay;
import net.runelite.client.plugins.npcunaggroarea.NpcAggroAreaOverlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.WildcardMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="NPC Aggression Timer", description="Highlights the unaggressive area of NPCs nearby and timer until it becomes active", tags={"highlight", "lines", "unaggro", "aggro", "aggressive", "npcs", "area", "slayer"}, enabledByDefault=false)
public class NpcAggroAreaPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(NpcAggroAreaPlugin.class);
    private static final int SAFE_AREA_RADIUS = 10;
    private static final int UNKNOWN_AREA_RADIUS = 20;
    private static final int AGGRESSIVE_TIME_SECONDS = 600;
    private static final Splitter NAME_SPLITTER = Splitter.on(',').omitEmptyStrings().trimResults();
    private static final WorldArea WILDERNESS_ABOVE_GROUND = new WorldArea(2944, 3523, 448, 448, 0);
    private static final WorldArea WILDERNESS_UNDERGROUND = new WorldArea(2944, 9918, 320, 442, 0);
    @Inject
    private Client client;
    @Inject
    private NpcAggroAreaConfig config;
    @Inject
    private NpcAggroAreaOverlay overlay;
    @Inject
    private NpcAggroAreaNotWorkingOverlay notWorkingOverlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private ConfigManager configManager;
    private final WorldPoint[] safeCenters = new WorldPoint[2];
    private final GeneralPath[] linesToDisplay = new GeneralPath[4];
    private boolean active;
    private AggressionTimer currentTimer;
    private WorldPoint lastPlayerLocation;
    private WorldPoint previousUnknownCenter;
    private boolean loggingIn;
    private List<String> npcNamePatterns;

    @Provides
    NpcAggroAreaConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(NpcAggroAreaConfig.class);
    }

    @Override
    protected void startUp() throws Exception {
        this.overlayManager.add(this.overlay);
        this.overlayManager.add(this.notWorkingOverlay);
        this.npcNamePatterns = NAME_SPLITTER.splitToList(this.config.npcNamePatterns());
        this.recheckActive();
    }

    @Override
    protected void shutDown() throws Exception {
        this.removeTimer();
        this.overlayManager.remove(this.overlay);
        this.overlayManager.remove(this.notWorkingOverlay);
        Arrays.fill(this.safeCenters, null);
        this.lastPlayerLocation = null;
        this.currentTimer = null;
        this.loggingIn = false;
        this.npcNamePatterns = null;
        this.active = false;
        Arrays.fill(this.linesToDisplay, null);
    }

    private Area generateSafeArea() {
        Area area = new Area();
        for (WorldPoint wp : this.safeCenters) {
            if (wp == null) continue;
            Polygon poly = new Polygon();
            poly.addPoint(wp.getX() - 10, wp.getY() - 10);
            poly.addPoint(wp.getX() - 10, wp.getY() + 10 + 1);
            poly.addPoint(wp.getX() + 10 + 1, wp.getY() + 10 + 1);
            poly.addPoint(wp.getX() + 10 + 1, wp.getY() - 10);
            area.add(new Area(poly));
        }
        return area;
    }

    private void transformWorldToLocal(float[] coords) {
        LocalPoint lp = LocalPoint.fromWorld(this.client, (int)coords[0], (int)coords[1]);
        coords[0] = (float)lp.getX() - 64.0f;
        coords[1] = (float)lp.getY() - 64.0f;
    }

    private void reevaluateActive() {
        if (this.currentTimer != null) {
            this.currentTimer.setVisible(this.active && this.config.showTimer());
        }
        this.calculateLinesToDisplay();
    }

    private void calculateLinesToDisplay() {
        if (!this.active || !this.config.showAreaLines()) {
            Arrays.fill(this.linesToDisplay, null);
            return;
        }
        Rectangle sceneRect = new Rectangle(this.client.getBaseX() + 1, this.client.getBaseY() + 1, 102, 102);
        for (int i = 0; i < this.linesToDisplay.length; ++i) {
            GeneralPath lines = new GeneralPath(this.generateSafeArea());
            lines = Geometry.clipPath(lines, (Shape)sceneRect);
            lines = Geometry.splitIntoSegments(lines, 1.0f);
            this.linesToDisplay[i] = lines = Geometry.transformPath(lines, this::transformWorldToLocal);
        }
    }

    private void removeTimer() {
        this.infoBoxManager.removeInfoBox(this.currentTimer);
        this.currentTimer = null;
    }

    private void createTimer(Duration duration) {
        this.removeTimer();
        AsyncBufferedImage image = this.itemManager.getImage(13501);
        this.currentTimer = new AggressionTimer(duration, image, this, this.active && this.config.showTimer());
        this.infoBoxManager.addInfoBox(this.currentTimer);
    }

    private void resetTimer() {
        this.createTimer(Duration.ofSeconds(600L));
    }

    private static boolean isInWilderness(WorldPoint location) {
        return WILDERNESS_ABOVE_GROUND.distanceTo2D(location) == 0 || WILDERNESS_UNDERGROUND.distanceTo2D(location) == 0;
    }

    private boolean isNpcMatch(NPC npc) {
        NPCComposition composition = npc.getTransformedComposition();
        if (composition == null) {
            return false;
        }
        if (Strings.isNullOrEmpty(composition.getName())) {
            return false;
        }
        int playerLvl = this.client.getLocalPlayer().getCombatLevel();
        int npcLvl = composition.getCombatLevel();
        String npcName = composition.getName().toLowerCase();
        if (npcLvl > 0 && playerLvl > npcLvl * 2 && !NpcAggroAreaPlugin.isInWilderness(npc.getWorldLocation())) {
            return false;
        }
        for (String pattern : this.npcNamePatterns) {
            if (!WildcardMatcher.matches(pattern, npcName)) continue;
            return true;
        }
        return false;
    }

    private void checkAreaNpcs(NPC ... npcs) {
        for (NPC npc : npcs) {
            if (npc == null || !this.isNpcMatch(npc)) continue;
            this.active = true;
            break;
        }
        this.reevaluateActive();
    }

    private void recheckActive() {
        this.active = this.config.alwaysActive();
        this.checkAreaNpcs(this.client.getCachedNPCs());
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned event) {
        if (this.config.alwaysActive()) {
            return;
        }
        this.checkAreaNpcs(event.getNpc());
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        WorldPoint newLocation = this.client.getLocalPlayer().getWorldLocation();
        if (this.lastPlayerLocation != null && this.safeCenters[1] == null && newLocation.distanceTo2D(this.lastPlayerLocation) > 40) {
            this.safeCenters[0] = null;
            this.safeCenters[1] = newLocation;
            this.resetTimer();
            this.calculateLinesToDisplay();
            this.previousUnknownCenter = this.lastPlayerLocation;
        }
        if (this.safeCenters[0] == null && this.previousUnknownCenter != null && this.previousUnknownCenter.distanceTo2D(newLocation) <= 20) {
            this.safeCenters[1] = null;
            this.removeTimer();
            this.calculateLinesToDisplay();
        }
        if (this.safeCenters[1] != null && Arrays.stream(this.safeCenters).noneMatch(x -> x != null && x.distanceTo2D(newLocation) <= 10)) {
            this.safeCenters[0] = this.safeCenters[1];
            this.safeCenters[1] = newLocation;
            this.resetTimer();
            this.calculateLinesToDisplay();
            this.previousUnknownCenter = null;
        }
        this.lastPlayerLocation = newLocation;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        String key;
        switch (key = event.getKey()) {
            case "npcUnaggroAlwaysActive": {
                this.recheckActive();
                break;
            }
            case "npcUnaggroShowTimer": {
                if (this.currentTimer == null) break;
                this.currentTimer.setVisible(this.active && this.config.showTimer());
                break;
            }
            case "npcUnaggroCollisionDetection": 
            case "npcUnaggroShowAreaLines": {
                this.calculateLinesToDisplay();
                break;
            }
            case "npcUnaggroNames": {
                this.npcNamePatterns = NAME_SPLITTER.splitToList(this.config.npcNamePatterns());
                this.recheckActive();
            }
        }
    }

    private void loadConfig() {
        this.safeCenters[0] = this.configManager.getConfiguration("npcUnaggroArea", "center1", WorldPoint.class);
        this.safeCenters[1] = this.configManager.getConfiguration("npcUnaggroArea", "center2", WorldPoint.class);
        this.lastPlayerLocation = this.configManager.getConfiguration("npcUnaggroArea", "location", WorldPoint.class);
        Duration timeLeft = this.configManager.getConfiguration("npcUnaggroArea", "duration", Duration.class);
        if (timeLeft != null) {
            this.createTimer(timeLeft);
        }
    }

    private void resetConfig() {
        this.configManager.unsetConfiguration("npcUnaggroArea", "center1");
        this.configManager.unsetConfiguration("npcUnaggroArea", "center2");
        this.configManager.unsetConfiguration("npcUnaggroArea", "location");
        this.configManager.unsetConfiguration("npcUnaggroArea", "duration");
    }

    private void saveConfig() {
        if (this.safeCenters[0] == null || this.safeCenters[1] == null || this.lastPlayerLocation == null || this.currentTimer == null) {
            this.resetConfig();
        } else {
            this.configManager.setConfiguration("npcUnaggroArea", "center1", this.safeCenters[0]);
            this.configManager.setConfiguration("npcUnaggroArea", "center2", this.safeCenters[1]);
            this.configManager.setConfiguration("npcUnaggroArea", "location", this.lastPlayerLocation);
            this.configManager.setConfiguration("npcUnaggroArea", "duration", Duration.between(Instant.now(), this.currentTimer.getEndTime()));
        }
    }

    private void onLogin() {
        this.loadConfig();
        this.resetConfig();
        WorldPoint newLocation = this.client.getLocalPlayer().getWorldLocation();
        assert (newLocation != null);
        if (this.lastPlayerLocation == null || newLocation.distanceTo(this.lastPlayerLocation) != 0) {
            this.safeCenters[0] = null;
            this.safeCenters[1] = null;
            this.lastPlayerLocation = newLocation;
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        switch (event.getGameState()) {
            case LOGGED_IN: {
                if (this.loggingIn) {
                    this.loggingIn = false;
                    this.onLogin();
                }
                this.recheckActive();
                break;
            }
            case LOGGING_IN: {
                this.loggingIn = true;
                break;
            }
            case LOGIN_SCREEN: {
                if (this.lastPlayerLocation != null) {
                    this.saveConfig();
                }
                this.safeCenters[0] = null;
                this.safeCenters[1] = null;
                this.lastPlayerLocation = null;
            }
        }
    }

    public WorldPoint[] getSafeCenters() {
        return this.safeCenters;
    }

    public GeneralPath[] getLinesToDisplay() {
        return this.linesToDisplay;
    }

    public boolean isActive() {
        return this.active;
    }

    public AggressionTimer getCurrentTimer() {
        return this.currentTimer;
    }
}

