/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.npchighlight;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.Instant;
import java.util.Locale;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.NPCComposition;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.plugins.npchighlight.MemorizedNpc;
import net.runelite.client.plugins.npchighlight.NpcIndicatorsConfig;
import net.runelite.client.plugins.npchighlight.NpcIndicatorsPlugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.util.Text;

public class NpcSceneOverlay
extends Overlay {
    private static final Color TEXT_COLOR = Color.WHITE;
    private static final double ESTIMATED_TICK_LENGTH = 0.6;
    private static final NumberFormat TIME_LEFT_FORMATTER = DecimalFormat.getInstance(Locale.US);
    private final Client client;
    private final NpcIndicatorsConfig config;
    private final NpcIndicatorsPlugin plugin;

    @Inject
    NpcSceneOverlay(Client client2, NpcIndicatorsConfig config, NpcIndicatorsPlugin plugin) {
        this.client = client2;
        this.config = config;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        if (this.config.showRespawnTimer()) {
            this.plugin.getDeadNpcsToDisplay().forEach((id, npc) -> this.renderNpcRespawn((MemorizedNpc)npc, graphics));
        }
        for (NPC npc2 : this.plugin.getHighlightedNpcs()) {
            this.renderNpcOverlay(graphics, npc2, this.config.getHighlightColor());
        }
        return null;
    }

    private void renderNpcRespawn(MemorizedNpc npc, Graphics2D graphics) {
        if (npc.getPossibleRespawnLocations().isEmpty()) {
            return;
        }
        WorldPoint respawnLocation = npc.getPossibleRespawnLocations().get(0);
        LocalPoint lp = LocalPoint.fromWorld(this.client, respawnLocation.getX(), respawnLocation.getY());
        if (lp == null) {
            return;
        }
        Color color = this.config.getHighlightColor();
        LocalPoint centerLp = new LocalPoint(lp.getX() + 128 * (npc.getNpcSize() - 1) / 2, lp.getY() + 128 * (npc.getNpcSize() - 1) / 2);
        Polygon poly = Perspective.getCanvasTileAreaPoly(this.client, centerLp, npc.getNpcSize());
        if (poly != null) {
            OverlayUtil.renderPolygon(graphics, poly, color);
        }
        Instant now = Instant.now();
        double baseTick = (double)(npc.getDiedOnTick() + npc.getRespawnTime() - this.client.getTickCount()) * 0.6;
        double sinceLast = (double)(now.toEpochMilli() - this.plugin.getLastTickUpdate().toEpochMilli()) / 1000.0;
        double timeLeft = Math.max(0.0, baseTick - sinceLast);
        String timeLeftStr = TIME_LEFT_FORMATTER.format(timeLeft);
        int textWidth = graphics.getFontMetrics().stringWidth(timeLeftStr);
        int textHeight = graphics.getFontMetrics().getAscent();
        Point canvasPoint = Perspective.localToCanvas(this.client, centerLp, respawnLocation.getPlane());
        if (canvasPoint != null) {
            Point canvasCenterPoint = new Point(canvasPoint.getX() - textWidth / 2, canvasPoint.getY() + textHeight / 2);
            OverlayUtil.renderTextLocation(graphics, canvasCenterPoint, timeLeftStr, TEXT_COLOR);
        }
    }

    private void renderNpcOverlay(Graphics2D graphics, NPC actor, Color color) {
        String npcName;
        Point textLocation;
        switch (this.config.renderStyle()) {
            case SOUTH_WEST_TILE: {
                LocalPoint lp1 = LocalPoint.fromWorld(this.client, actor.getWorldLocation());
                Polygon tilePoly1 = Perspective.getCanvasTilePoly(this.client, lp1);
                this.renderPoly(graphics, color, tilePoly1);
                break;
            }
            case TILE: {
                int size = 1;
                NPCComposition composition = actor.getTransformedComposition();
                if (composition != null) {
                    size = composition.getSize();
                }
                LocalPoint lp = actor.getLocalLocation();
                Polygon tilePoly = Perspective.getCanvasTileAreaPoly(this.client, lp, size);
                this.renderPoly(graphics, color, tilePoly);
                break;
            }
            case HULL: {
                Polygon objectClickbox = actor.getConvexHull();
                this.renderPoly(graphics, color, objectClickbox);
            }
        }
        if (this.config.drawNames() && (textLocation = actor.getCanvasTextLocation(graphics, npcName = Text.removeTags(actor.getName()), actor.getLogicalHeight() + 40)) != null) {
            OverlayUtil.renderTextLocation(graphics, textLocation, npcName, color);
        }
    }

    private void renderPoly(Graphics2D graphics, Color color, Polygon polygon) {
        if (polygon != null) {
            graphics.setColor(color);
            graphics.setStroke(new BasicStroke(2.0f));
            graphics.draw(polygon);
            graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 20));
            graphics.fill(polygon);
        }
    }

    static {
        ((DecimalFormat)TIME_LEFT_FORMATTER).applyPattern("#0.0");
    }
}

