/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.npchighlight;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.Point;
import net.runelite.client.plugins.npchighlight.NpcIndicatorsConfig;
import net.runelite.client.plugins.npchighlight.NpcIndicatorsPlugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;

public class NpcMinimapOverlay
extends Overlay {
    private final Client client;
    private final NpcIndicatorsConfig config;
    private final NpcIndicatorsPlugin plugin;

    @Inject
    NpcMinimapOverlay(Client client2, NpcIndicatorsConfig config, NpcIndicatorsPlugin plugin) {
        this.client = client2;
        this.config = config;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        for (NPC npc : this.plugin.getHighlightedNpcs()) {
            this.renderNpcOverlay(graphics, npc, npc.getName(), this.config.getHighlightColor());
        }
        return null;
    }

    private void renderNpcOverlay(Graphics2D graphics, NPC actor, String name, Color color) {
        Point minimapLocation = actor.getMinimapLocation();
        if (minimapLocation != null) {
            OverlayUtil.renderMinimapLocation(graphics, minimapLocation, color.darker());
            if (this.config.drawMinimapNames()) {
                OverlayUtil.renderTextLocation(graphics, minimapLocation, name, color);
            }
        }
    }
}

