/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.npchighlight;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.inject.Provides;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.GraphicsObject;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.NPC;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ConfigChanged;
import net.runelite.api.events.FocusChanged;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.GraphicsObjectCreated;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.npchighlight.MemorizedNpc;
import net.runelite.client.plugins.npchighlight.NpcIndicatorsConfig;
import net.runelite.client.plugins.npchighlight.NpcIndicatorsInput;
import net.runelite.client.plugins.npchighlight.NpcMinimapOverlay;
import net.runelite.client.plugins.npchighlight.NpcSceneOverlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.Text;
import net.runelite.client.util.WildcardMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="NPC Indicators", description="Highlight NPCs on-screen and/or on the minimap", tags={"highlight", "minimap", "npcs", "overlay", "respawn", "tags"})
public class NpcIndicatorsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(NpcIndicatorsPlugin.class);
    private static final int MAX_ACTOR_VIEW_RANGE = 15;
    private static final String TAG = "Tag";
    private static final List<MenuAction> NPC_MENU_ACTIONS = ImmutableList.of(MenuAction.NPC_FIRST_OPTION, MenuAction.NPC_SECOND_OPTION, MenuAction.NPC_THIRD_OPTION, MenuAction.NPC_FOURTH_OPTION, MenuAction.NPC_FIFTH_OPTION);
    @Inject
    private Client client;
    @Inject
    private NpcIndicatorsConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private NpcSceneOverlay npcSceneOverlay;
    @Inject
    private NpcMinimapOverlay npcMinimapOverlay;
    @Inject
    private NpcIndicatorsInput inputListener;
    @Inject
    private KeyManager keyManager;
    @Inject
    private ClientThread clientThread;
    private boolean hotKeyPressed = false;
    private final Set<NPC> highlightedNpcs = new HashSet<NPC>();
    private final Map<Integer, MemorizedNpc> deadNpcsToDisplay = new HashMap<Integer, MemorizedNpc>();
    private Instant lastTickUpdate;
    private final Map<Integer, MemorizedNpc> memorizedNpcs = new HashMap<Integer, MemorizedNpc>();
    private List<String> highlights = new ArrayList<String>();
    private final Set<Integer> npcTags = new HashSet<Integer>();
    private final List<NPC> spawnedNpcsThisTick = new ArrayList<NPC>();
    private final List<NPC> despawnedNpcsThisTick = new ArrayList<NPC>();
    private final Set<WorldPoint> teleportGraphicsObjectSpawnedThisTick = new HashSet<WorldPoint>();
    private WorldPoint lastPlayerLocation;
    private boolean skipNextSpawnCheck = false;

    @Provides
    NpcIndicatorsConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(NpcIndicatorsConfig.class);
    }

    @Override
    protected void startUp() throws Exception {
        this.overlayManager.add(this.npcSceneOverlay);
        this.overlayManager.add(this.npcMinimapOverlay);
        this.keyManager.registerKeyListener(this.inputListener);
        this.highlights = this.getHighlights();
        this.clientThread.invoke(() -> {
            this.skipNextSpawnCheck = true;
            this.rebuildAllNpcs();
        });
    }

    @Override
    protected void shutDown() throws Exception {
        this.overlayManager.remove(this.npcSceneOverlay);
        this.overlayManager.remove(this.npcMinimapOverlay);
        this.deadNpcsToDisplay.clear();
        this.memorizedNpcs.clear();
        this.spawnedNpcsThisTick.clear();
        this.despawnedNpcsThisTick.clear();
        this.teleportGraphicsObjectSpawnedThisTick.clear();
        this.npcTags.clear();
        this.highlightedNpcs.clear();
        this.keyManager.unregisterKeyListener(this.inputListener);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGIN_SCREEN || event.getGameState() == GameState.HOPPING) {
            this.highlightedNpcs.clear();
            this.deadNpcsToDisplay.clear();
            this.memorizedNpcs.forEach((id, npc) -> npc.setDiedOnTick(-1));
            this.lastPlayerLocation = null;
            this.skipNextSpawnCheck = true;
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (!configChanged.getGroup().equals("npcindicators")) {
            return;
        }
        this.highlights = this.getHighlights();
        this.rebuildAllNpcs();
    }

    @Subscribe
    public void onFocusChanged(FocusChanged focusChanged) {
        if (!focusChanged.isFocused()) {
            this.hotKeyPressed = false;
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        if (!this.hotKeyPressed || event.getType() != MenuAction.EXAMINE_NPC.getId()) {
            return;
        }
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        menuEntries = Arrays.copyOf(menuEntries, menuEntries.length + 1);
        MenuEntry menuEntry = new MenuEntry();
        menuEntries[menuEntries.length - 1] = menuEntry;
        MenuEntry menuEntry2 = menuEntry;
        menuEntry2.setOption(TAG);
        menuEntry2.setTarget(event.getTarget());
        menuEntry2.setParam0(event.getActionParam0());
        menuEntry2.setParam1(event.getActionParam1());
        menuEntry2.setIdentifier(event.getIdentifier());
        menuEntry2.setType(MenuAction.RUNELITE.getId());
        this.client.setMenuEntries(menuEntries);
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked click) {
        if (click.getMenuAction() != MenuAction.RUNELITE || !click.getMenuOption().equals(TAG)) {
            return;
        }
        int id = click.getId();
        boolean removed = this.npcTags.remove(id);
        NPC[] cachedNPCs = this.client.getCachedNPCs();
        NPC npc = cachedNPCs[id];
        if (npc == null || npc.getName() == null) {
            return;
        }
        if (removed) {
            this.highlightedNpcs.remove(npc);
            this.memorizedNpcs.remove(npc.getIndex());
        } else {
            this.memorizeNpc(npc);
            this.npcTags.add(id);
            this.highlightedNpcs.add(npc);
        }
        click.consume();
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned npcSpawned) {
        NPC npc = npcSpawned.getNpc();
        String npcName = npc.getName();
        if (npcName == null) {
            return;
        }
        if (this.npcTags.contains(npc.getIndex())) {
            this.memorizeNpc(npc);
            this.highlightedNpcs.add(npc);
            this.spawnedNpcsThisTick.add(npc);
            return;
        }
        for (String highlight : this.highlights) {
            if (!WildcardMatcher.matches(highlight, npcName)) continue;
            this.memorizeNpc(npc);
            this.highlightedNpcs.add(npc);
            this.spawnedNpcsThisTick.add(npc);
            break;
        }
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned npcDespawned) {
        NPC npc = npcDespawned.getNpc();
        if (this.memorizedNpcs.containsKey(npc.getIndex())) {
            this.despawnedNpcsThisTick.add(npc);
        }
        this.highlightedNpcs.remove(npc);
    }

    @Subscribe
    public void onGraphicsObjectCreated(GraphicsObjectCreated event) {
        GraphicsObject go = event.getGraphicsObject();
        if (go.getId() == 86) {
            this.teleportGraphicsObjectSpawnedThisTick.add(WorldPoint.fromLocal(this.client, go.getLocation()));
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.removeOldHighlightedRespawns();
        this.validateSpawnedNpcs();
        this.lastTickUpdate = Instant.now();
        this.lastPlayerLocation = this.client.getLocalPlayer().getWorldLocation();
    }

    private static boolean isInViewRange(WorldPoint wp1, WorldPoint wp2) {
        int distance = wp1.distanceTo(wp2);
        return distance < 15;
    }

    private static WorldPoint getWorldLocationBehind(NPC npc) {
        int orientation = npc.getOrientation() / 256;
        int dx = 0;
        int dy = 0;
        switch (orientation) {
            case 0: {
                dy = -1;
                break;
            }
            case 1: {
                dx = -1;
                dy = -1;
                break;
            }
            case 2: {
                dx = -1;
                break;
            }
            case 3: {
                dx = -1;
                dy = 1;
                break;
            }
            case 4: {
                dy = 1;
                break;
            }
            case 5: {
                dx = 1;
                dy = 1;
                break;
            }
            case 6: {
                dx = 1;
                break;
            }
            case 7: {
                dx = 1;
                dy = -1;
            }
        }
        WorldPoint currWP = npc.getWorldLocation();
        return new WorldPoint(currWP.getX() - dx, currWP.getY() - dy, currWP.getPlane());
    }

    private void memorizeNpc(NPC npc) {
        int npcIndex = npc.getIndex();
        this.memorizedNpcs.putIfAbsent(npcIndex, new MemorizedNpc(npc));
    }

    private void removeOldHighlightedRespawns() {
        this.deadNpcsToDisplay.values().removeIf(x -> x.getDiedOnTick() + x.getRespawnTime() <= this.client.getTickCount() + 1);
    }

    @VisibleForTesting
    List<String> getHighlights() {
        String configNpcs = this.config.getNpcToHighlight().toLowerCase();
        if (configNpcs.isEmpty()) {
            return Collections.emptyList();
        }
        return Text.fromCSV(configNpcs);
    }

    private void rebuildAllNpcs() {
        this.highlightedNpcs.clear();
        if (this.client.getGameState() != GameState.LOGGED_IN && this.client.getGameState() != GameState.LOADING) {
            return;
        }
        block0: for (NPC npc : this.client.getNpcs()) {
            String npcName = npc.getName();
            if (npcName == null) continue;
            if (this.npcTags.contains(npc.getIndex())) {
                this.highlightedNpcs.add(npc);
                continue;
            }
            for (String highlight : this.highlights) {
                if (!WildcardMatcher.matches(highlight, npcName)) continue;
                this.memorizeNpc(npc);
                this.highlightedNpcs.add(npc);
                continue block0;
            }
            this.memorizedNpcs.remove(npc.getIndex());
        }
    }

    private void validateSpawnedNpcs() {
        if (this.skipNextSpawnCheck) {
            this.skipNextSpawnCheck = false;
        } else {
            MemorizedNpc mn;
            for (NPC npc : this.despawnedNpcsThisTick) {
                if (!this.teleportGraphicsObjectSpawnedThisTick.isEmpty() && this.teleportGraphicsObjectSpawnedThisTick.contains(npc.getWorldLocation()) || !NpcIndicatorsPlugin.isInViewRange(this.client.getLocalPlayer().getWorldLocation(), npc.getWorldLocation()) || (mn = this.memorizedNpcs.get(npc.getIndex())) == null) continue;
                mn.setDiedOnTick(this.client.getTickCount() + 1);
                if (mn.getPossibleRespawnLocations().isEmpty()) continue;
                log.debug("Starting {} tick countdown for {}", (Object)mn.getRespawnTime(), (Object)mn.getNpcName());
                this.deadNpcsToDisplay.put(mn.getNpcIndex(), mn);
            }
            for (NPC npc : this.spawnedNpcsThisTick) {
                if (!this.teleportGraphicsObjectSpawnedThisTick.isEmpty() && (this.teleportGraphicsObjectSpawnedThisTick.contains(npc.getWorldLocation()) || this.teleportGraphicsObjectSpawnedThisTick.contains(NpcIndicatorsPlugin.getWorldLocationBehind(npc))) || this.lastPlayerLocation == null || !NpcIndicatorsPlugin.isInViewRange(this.lastPlayerLocation, npc.getWorldLocation())) continue;
                mn = this.memorizedNpcs.get(npc.getIndex());
                if (mn.getDiedOnTick() != -1) {
                    mn.setRespawnTime(this.client.getTickCount() + 1 - mn.getDiedOnTick());
                    mn.setDiedOnTick(-1);
                }
                WorldPoint npcLocation = npc.getWorldLocation();
                WorldPoint possibleOtherNpcLocation = NpcIndicatorsPlugin.getWorldLocationBehind(npc);
                mn.getPossibleRespawnLocations().removeIf(x -> x.distanceTo(npcLocation) != 0 && x.distanceTo(possibleOtherNpcLocation) != 0);
                if (!mn.getPossibleRespawnLocations().isEmpty()) continue;
                mn.getPossibleRespawnLocations().add(npcLocation);
                mn.getPossibleRespawnLocations().add(possibleOtherNpcLocation);
            }
        }
        this.spawnedNpcsThisTick.clear();
        this.despawnedNpcsThisTick.clear();
        this.teleportGraphicsObjectSpawnedThisTick.clear();
    }

    void setHotKeyPressed(boolean hotKeyPressed) {
        this.hotKeyPressed = hotKeyPressed;
    }

    Set<NPC> getHighlightedNpcs() {
        return this.highlightedNpcs;
    }

    Map<Integer, MemorizedNpc> getDeadNpcsToDisplay() {
        return this.deadNpcsToDisplay;
    }

    Instant getLastTickUpdate() {
        return this.lastTickUpdate;
    }
}

