/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.nightmarezone;

import com.google.inject.Provides;
import java.util.Arrays;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.Varbits;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ConfigChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.nightmarezone.NightmareZoneConfig;
import net.runelite.client.plugins.nightmarezone.NightmareZoneOverlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.Text;

public class NightmareZonePlugin
extends Plugin {
    private static final int[] NMZ_MAP_REGION = new int[]{9033};
    @Inject
    private Notifier notifier;
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private NightmareZoneConfig config;
    @Inject
    private NightmareZoneOverlay overlay;
    private boolean absorptionNotificationSend = true;

    @Override
    protected void startUp() throws Exception {
        this.overlayManager.add(this.overlay);
        this.overlay.removeAbsorptionCounter();
    }

    @Override
    protected void shutDown() throws Exception {
        this.overlayManager.remove(this.overlay);
        this.overlay.removeAbsorptionCounter();
        Widget nmzWidget = this.client.getWidget(WidgetInfo.NIGHTMARE_ZONE);
        if (nmzWidget != null) {
            nmzWidget.setHidden(false);
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        this.overlay.updateConfig();
    }

    @Provides
    NightmareZoneConfig getConfig(ConfigManager configManager) {
        return configManager.getConfig(NightmareZoneConfig.class);
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (!this.isInNightmareZone()) {
            if (!this.absorptionNotificationSend) {
                this.absorptionNotificationSend = true;
            }
            return;
        }
        if (this.config.absorptionNotification()) {
            this.checkAbsorption();
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() != ChatMessageType.GAMEMESSAGE || !this.isInNightmareZone()) {
            return;
        }
        String msg = Text.removeTags(event.getMessage());
        if (msg.contains("The effects of overload have worn off, and you feel normal again.")) {
            if (this.config.overloadNotification()) {
                this.notifier.notify("Your overload has worn off");
            }
        } else if (msg.contains("A power-up has spawned:")) {
            if (msg.contains("Power surge")) {
                if (this.config.powerSurgeNotification()) {
                    this.notifier.notify(msg);
                }
            } else if (msg.contains("Recurrent damage")) {
                if (this.config.recurrentDamageNotification()) {
                    this.notifier.notify(msg);
                }
            } else if (msg.contains("Zapper")) {
                if (this.config.zapperNotification()) {
                    this.notifier.notify(msg);
                }
            } else if (msg.contains("Ultimate force") && this.config.ultimateForceNotification()) {
                this.notifier.notify(msg);
            }
        }
    }

    private void checkAbsorption() {
        int absorptionPoints = this.client.getVar(Varbits.NMZ_ABSORPTION);
        if (!this.absorptionNotificationSend) {
            if (absorptionPoints < this.config.absorptionThreshold()) {
                this.notifier.notify("Absorption points below: " + this.config.absorptionThreshold());
                this.absorptionNotificationSend = true;
            }
        } else if (absorptionPoints > this.config.absorptionThreshold()) {
            this.absorptionNotificationSend = false;
        }
    }

    public boolean isInNightmareZone() {
        return Arrays.equals(this.client.getMapRegions(), NMZ_MAP_REGION);
    }
}

