/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.musicindicator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.EnumComposition;
import net.runelite.api.VarPlayer;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;

@PluginDescriptor(name="Music Track Indicator", description="Show chat notifications when unlocking music tracks")
public class MusicIndicatorPlugin
extends Plugin {
    private static final List<VarPlayer> MUSIC_TRACK_VARPS = ImmutableList.of(VarPlayer.MUSIC_TRACKS_UNLOCKED_1, VarPlayer.MUSIC_TRACKS_UNLOCKED_2, VarPlayer.MUSIC_TRACKS_UNLOCKED_3, VarPlayer.MUSIC_TRACKS_UNLOCKED_4, VarPlayer.MUSIC_TRACKS_UNLOCKED_5, VarPlayer.MUSIC_TRACKS_UNLOCKED_6, VarPlayer.MUSIC_TRACKS_UNLOCKED_7, VarPlayer.MUSIC_TRACKS_UNLOCKED_8, VarPlayer.MUSIC_TRACKS_UNLOCKED_9, VarPlayer.MUSIC_TRACKS_UNLOCKED_10, VarPlayer.MUSIC_TRACKS_UNLOCKED_11, VarPlayer.MUSIC_TRACKS_UNLOCKED_12, new VarPlayer[]{VarPlayer.MUSIC_TRACKS_UNLOCKED_13, VarPlayer.MUSIC_TRACKS_UNLOCKED_14, VarPlayer.MUSIC_TRACKS_UNLOCKED_15, VarPlayer.MUSIC_TRACKS_UNLOCKED_16, VarPlayer.MUSIC_TRACKS_UNLOCKED_17, VarPlayer.MUSIC_TRACKS_UNLOCKED_18, VarPlayer.MUSIC_TRACKS_UNLOCKED_19});
    private static final Map<Integer, VarPlayer> VARP_INDEX_TO_VARPLAYER = MUSIC_TRACK_VARPS.stream().collect(Collectors.collectingAndThen(Collectors.toMap(VarPlayer::getId, Function.identity()), ImmutableMap::copyOf));
    @Inject
    private Client client;
    @Inject
    private ChatMessageManager chatMessageManager;
    private final Map<VarPlayer, Integer> musicTrackVarpValues = new HashMap<VarPlayer, Integer>();
    private boolean loggingIn;

    @Override
    public void startUp() {
        this.loggingIn = true;
    }

    @Override
    public void shutDown() {
        this.musicTrackVarpValues.clear();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        switch (event.getGameState()) {
            case LOGGING_IN: 
            case CONNECTION_LOST: 
            case HOPPING: {
                this.musicTrackVarpValues.clear();
                this.loggingIn = true;
            }
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (!this.loggingIn) {
            return;
        }
        this.loggingIn = false;
        for (VarPlayer musicTrackVarp : MUSIC_TRACK_VARPS) {
            int value = this.client.getVar(musicTrackVarp);
            this.musicTrackVarpValues.put(musicTrackVarp, value);
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        int idx = event.getIndex();
        VarPlayer varPlayer = VARP_INDEX_TO_VARPLAYER.get(idx);
        if (varPlayer == null) {
            return;
        }
        if (this.musicTrackVarpValues.isEmpty()) {
            return;
        }
        assert (this.musicTrackVarpValues.containsKey((Object)varPlayer));
        int newValue = this.client.getVar(varPlayer);
        int oldValue = this.musicTrackVarpValues.put(varPlayer, newValue);
        int musicTracksUnlocked = ~oldValue & newValue;
        if (musicTracksUnlocked == 0) {
            return;
        }
        EnumComposition names = this.client.getEnum(812);
        int varpId = MUSIC_TRACK_VARPS.indexOf((Object)varPlayer) + 1;
        for (int bit = 0; bit < 32; ++bit) {
            if ((musicTracksUnlocked & 1 << bit) == 0) continue;
            int musicTrackId = this.getTrackId(varpId, bit);
            String musicTrackName = names.getStringValue(musicTrackId);
            this.sendChatMessage("You have unlocked a new music track: " + musicTrackName + ".");
        }
    }

    private int getTrackId(int variableId, int bit) {
        int packed = variableId << 14 | bit;
        EnumComposition ids = this.client.getEnum(819);
        for (int key : ids.getKeys()) {
            int value = ids.getIntValue(key);
            if (value != packed) continue;
            return key;
        }
        return -1;
    }

    private void sendChatMessage(String chatMessage) {
        String message = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append(chatMessage).build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(message).build());
    }
}

