/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.mousehighlight;

import com.google.common.base.Strings;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.VarClientInt;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.plugins.mousehighlight.MouseHighlightConfig;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;

class MouseHighlightOverlay
extends Overlay {
    private final TooltipManager tooltipManager;
    private final Client client;
    private final MouseHighlightConfig config;

    @Inject
    MouseHighlightOverlay(Client client2, TooltipManager tooltipManager, MouseHighlightConfig config) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.client = client2;
        this.tooltipManager = tooltipManager;
        this.config = config;
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        int tooltipTimeout;
        if (this.client.isMenuOpen()) {
            return null;
        }
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        int last = menuEntries.length - 1;
        if (last < 0) {
            return null;
        }
        MenuEntry menuEntry = menuEntries[last];
        String target = menuEntry.getTarget();
        String option = menuEntry.getOption();
        int type = menuEntry.getType();
        if (type == MenuAction.RUNELITE_OVERLAY.getId() || type == MenuAction.EXAMINE_ITEM_BANK_EQ.getId()) {
            return null;
        }
        if (Strings.isNullOrEmpty(option)) {
            return null;
        }
        switch (option) {
            case "Walk here": 
            case "Cancel": 
            case "Continue": {
                return null;
            }
            case "Move": {
                if (!target.contains("Sliding piece")) break;
                return null;
            }
        }
        int widgetId = menuEntry.getParam1();
        int groupId = WidgetInfo.TO_GROUP(widgetId);
        int childId = WidgetInfo.TO_CHILD(widgetId);
        Widget widget = this.client.getWidget(groupId, childId);
        if (!this.config.uiTooltip() && widget != null) {
            return null;
        }
        if (!this.config.chatboxTooltip() && groupId == WidgetInfo.CHATBOX.getGroupId()) {
            return null;
        }
        if (widget != null && (tooltipTimeout = this.client.getVar(VarClientInt.TOOLTIP_TIMEOUT)) > this.client.getGameCycle()) {
            return null;
        }
        int tooltipDisplayed = this.client.getVar(VarClientInt.TOOLTIP_VISIBLE);
        if (tooltipDisplayed == 1) {
            return null;
        }
        this.tooltipManager.addFront(new Tooltip(option + (String)(Strings.isNullOrEmpty(target) ? "" : " " + target)));
        return null;
    }
}

