/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.motherlode;

import com.google.common.collect.ImmutableSet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.time.Duration;
import java.time.Instant;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.plugins.motherlode.MotherlodeConfig;
import net.runelite.client.plugins.motherlode.MotherlodePlugin;
import net.runelite.client.plugins.motherlode.MotherlodeSession;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

class MotherlodeOverlay
extends Overlay {
    private static final Set<Integer> MINING_ANIMATION_IDS = ImmutableSet.of(Integer.valueOf(6753), Integer.valueOf(6754), Integer.valueOf(6755), Integer.valueOf(3866), Integer.valueOf(6757), Integer.valueOf(6756), new Integer[]{6752, 6758, 335, 4481});
    private final Client client;
    private final MotherlodePlugin plugin;
    private final MotherlodeSession motherlodeSession;
    private final MotherlodeConfig config;
    private final PanelComponent panelComponent = new PanelComponent();

    @Inject
    MotherlodeOverlay(Client client2, MotherlodePlugin plugin, MotherlodeSession motherlodeSession, MotherlodeConfig config) {
        super(plugin);
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.client = client2;
        this.plugin = plugin;
        this.motherlodeSession = motherlodeSession;
        this.config = config;
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        if (!this.plugin.isInMlm() || !this.config.showMiningStats()) {
            return null;
        }
        MotherlodeSession session = this.motherlodeSession;
        if (session.getLastPayDirtMined() == null) {
            return null;
        }
        Duration statTimeout = Duration.ofMinutes(this.config.statTimeout());
        Duration sinceCut = Duration.between(session.getLastPayDirtMined(), Instant.now());
        if (sinceCut.compareTo(statTimeout) >= 0) {
            return null;
        }
        this.panelComponent.getChildren().clear();
        if (this.config.showMiningState()) {
            if (MINING_ANIMATION_IDS.contains(this.client.getLocalPlayer().getAnimation())) {
                this.panelComponent.getChildren().add(TitleComponent.builder().text("Mining").color(Color.GREEN).build());
            } else {
                this.panelComponent.getChildren().add(TitleComponent.builder().text("NOT mining").color(Color.RED).build());
            }
        }
        this.panelComponent.getChildren().add(LineComponent.builder().left("Pay-dirt mined:").right(Integer.toString(session.getTotalMined())).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Pay-dirt/hr:").right(session.getRecentMined() > 2 ? Integer.toString(session.getPerHour()) : "").build());
        return this.panelComponent.render(graphics);
    }
}

