/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.minimap;

import com.google.inject.Provides;
import java.awt.Color;
import java.util.Arrays;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.SpritePixels;
import net.runelite.api.events.ConfigChanged;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.WidgetHiddenChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.minimap.MinimapConfig;
import net.runelite.client.plugins.minimap.MinimapDot;

@PluginDescriptor(name="Minimap", description="Customize the color of minimap dots", tags={"items", "npcs", "players"})
public class MinimapPlugin
extends Plugin {
    private static final int NUM_MAPDOTS = 6;
    @Inject
    private Client client;
    @Inject
    private MinimapConfig config;
    private SpritePixels[] originalDotSprites;

    @Provides
    private MinimapConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(MinimapConfig.class);
    }

    @Override
    protected void startUp() throws Exception {
        this.updateMinimapWidgetVisibility(this.config.hideMinimap());
        this.storeOriginalDots();
        this.replaceMapDots();
    }

    @Override
    protected void shutDown() throws Exception {
        this.updateMinimapWidgetVisibility(false);
        this.restoreOriginalDots();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGIN_SCREEN && this.originalDotSprites == null) {
            this.storeOriginalDots();
            this.replaceMapDots();
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("minimap")) {
            return;
        }
        if (event.getKey().equals("hideMinimap")) {
            this.updateMinimapWidgetVisibility(this.config.hideMinimap());
            return;
        }
        this.replaceMapDots();
    }

    @Subscribe
    public void onWidgetHiddenChanged(WidgetHiddenChanged event) {
        this.updateMinimapWidgetVisibility(this.config.hideMinimap());
    }

    private void updateMinimapWidgetVisibility(boolean enable) {
        Widget resizableNormalWidget;
        Widget resizableStonesWidget = this.client.getWidget(WidgetInfo.RESIZABLE_MINIMAP_STONES_WIDGET);
        if (resizableStonesWidget != null) {
            resizableStonesWidget.setHidden(enable);
        }
        if ((resizableNormalWidget = this.client.getWidget(WidgetInfo.RESIZABLE_MINIMAP_WIDGET)) != null && !resizableNormalWidget.isSelfHidden()) {
            for (Widget widget : resizableNormalWidget.getStaticChildren()) {
                if (widget.getId() == WidgetInfo.RESIZABLE_VIEWPORT_BOTTOM_LINE_LOGOUT_BUTTON.getId() || widget.getId() == WidgetInfo.RESIZABLE_MINIMAP_LOGOUT_BUTTON.getId()) continue;
                widget.setHidden(enable);
            }
        }
    }

    private void replaceMapDots() {
        SpritePixels[] mapDots = this.client.getMapDots();
        if (mapDots == null) {
            return;
        }
        Color[] minimapDotColors = this.getColors();
        for (int i = 0; i < mapDots.length && i < minimapDotColors.length; ++i) {
            mapDots[i] = MinimapDot.create(this.client, minimapDotColors[i]);
        }
    }

    private Color[] getColors() {
        Color[] colors = new Color[]{this.config.itemColor(), this.config.npcColor(), this.config.playerColor(), this.config.friendColor(), this.config.teamColor(), this.config.clanColor()};
        return colors;
    }

    private void storeOriginalDots() {
        SpritePixels[] originalDots = this.client.getMapDots();
        if (originalDots == null) {
            return;
        }
        this.originalDotSprites = Arrays.copyOf(originalDots, originalDots.length);
    }

    private void restoreOriginalDots() {
        SpritePixels[] mapDots = this.client.getMapDots();
        if (this.originalDotSprites == null || mapDots == null) {
            return;
        }
        System.arraycopy(this.originalDotSprites, 0, mapDots, 0, mapDots.length);
    }
}

