/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.metronome;

import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.metronome.MetronomePluginConfiguration;

@PluginDescriptor(name="Metronome", description="Play a sound on a specified tick to aid in efficient skilling", tags={"skilling", "tick", "timers"}, enabledByDefault=false)
public class MetronomePlugin
extends Plugin {
    @Inject
    private Client client;
    @Inject
    private MetronomePluginConfiguration config;
    private int tickCounter = 0;
    private boolean shouldTock = false;

    @Provides
    MetronomePluginConfiguration provideConfig(ConfigManager configManager) {
        return configManager.getConfig(MetronomePluginConfiguration.class);
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        if (this.config.tickCount() == 0) {
            return;
        }
        if (++this.tickCounter % this.config.tickCount() == 0) {
            if (this.config.enableTock() && this.shouldTock) {
                this.client.playSoundEffect(3930);
            } else {
                this.client.playSoundEffect(3929);
            }
            this.shouldTock = !this.shouldTock;
        }
    }
}

