/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.menuentryswapper;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.ItemComposition;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.NPC;
import net.runelite.api.events.ConfigChanged;
import net.runelite.api.events.FocusChanged;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.MenuOpened;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.PostItemComposition;
import net.runelite.api.events.WidgetMenuOptionClicked;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.ItemVariationMapping;
import net.runelite.client.input.KeyManager;
import net.runelite.client.menus.MenuManager;
import net.runelite.client.menus.WidgetMenuOption;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.menuentryswapper.FairyRingMode;
import net.runelite.client.plugins.menuentryswapper.HouseMode;
import net.runelite.client.plugins.menuentryswapper.MenuEntrySwapperConfig;
import net.runelite.client.plugins.menuentryswapper.ShiftClickInputListener;
import net.runelite.client.util.Text;
import org.apache.commons.lang3.ArrayUtils;

@PluginDescriptor(name="Menu Entry Swapper", description="Change the default option that is displayed when hovering over objects", tags={"npcs", "inventory", "items", "objects"}, enabledByDefault=false)
public class MenuEntrySwapperPlugin
extends Plugin {
    private static final String CONFIGURE = "Configure";
    private static final String SAVE = "Save";
    private static final String RESET = "Reset";
    private static final String MENU_TARGET = "Shift-click";
    private static final String CONFIG_GROUP = "shiftclick";
    private static final String ITEM_KEY_PREFIX = "item_";
    private static final WidgetMenuOption FIXED_INVENTORY_TAB_CONFIGURE = new WidgetMenuOption("Configure", "Shift-click", WidgetInfo.FIXED_VIEWPORT_INVENTORY_TAB);
    private static final WidgetMenuOption FIXED_INVENTORY_TAB_SAVE = new WidgetMenuOption("Save", "Shift-click", WidgetInfo.FIXED_VIEWPORT_INVENTORY_TAB);
    private static final WidgetMenuOption RESIZABLE_INVENTORY_TAB_CONFIGURE = new WidgetMenuOption("Configure", "Shift-click", WidgetInfo.RESIZABLE_VIEWPORT_INVENTORY_TAB);
    private static final WidgetMenuOption RESIZABLE_INVENTORY_TAB_SAVE = new WidgetMenuOption("Save", "Shift-click", WidgetInfo.RESIZABLE_VIEWPORT_INVENTORY_TAB);
    private static final WidgetMenuOption RESIZABLE_BOTTOM_LINE_INVENTORY_TAB_CONFIGURE = new WidgetMenuOption("Configure", "Shift-click", WidgetInfo.RESIZABLE_VIEWPORT_BOTTOM_LINE_INVENTORY_TAB);
    private static final WidgetMenuOption RESIZABLE_BOTTOM_LINE_INVENTORY_TAB_SAVE = new WidgetMenuOption("Save", "Shift-click", WidgetInfo.RESIZABLE_VIEWPORT_BOTTOM_LINE_INVENTORY_TAB);
    private static final Set<MenuAction> NPC_MENU_TYPES = ImmutableSet.of(MenuAction.NPC_FIRST_OPTION, MenuAction.NPC_SECOND_OPTION, MenuAction.NPC_THIRD_OPTION, MenuAction.NPC_FOURTH_OPTION, MenuAction.NPC_FIFTH_OPTION, MenuAction.EXAMINE_NPC, new MenuAction[0]);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private MenuEntrySwapperConfig config;
    @Inject
    private ShiftClickInputListener inputListener;
    @Inject
    private ConfigManager configManager;
    @Inject
    private KeyManager keyManager;
    @Inject
    private MenuManager menuManager;
    @Inject
    private ItemManager itemManager;
    private boolean configuringShiftClick = false;
    private boolean shiftModifier = false;

    @Provides
    MenuEntrySwapperConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(MenuEntrySwapperConfig.class);
    }

    @Override
    public void startUp() {
        if (this.config.shiftClickCustomization()) {
            this.enableCustomization();
        }
    }

    @Override
    public void shutDown() {
        this.disableCustomization();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!CONFIG_GROUP.equals(event.getGroup())) {
            return;
        }
        if (event.getKey().equals("shiftClickCustomization")) {
            if (this.config.shiftClickCustomization()) {
                this.enableCustomization();
            } else {
                this.disableCustomization();
            }
        } else if (event.getKey().startsWith(ITEM_KEY_PREFIX)) {
            this.clientThread.invoke(this::resetItemCompositionCache);
        }
    }

    private void resetItemCompositionCache() {
        this.itemManager.invalidateItemCompositionCache();
        this.client.getItemCompositionCache().reset();
    }

    private Integer getSwapConfig(int itemId) {
        String config = this.configManager.getConfiguration(CONFIG_GROUP, ITEM_KEY_PREFIX + (itemId = ItemVariationMapping.map(itemId)));
        if (config == null || config.isEmpty()) {
            return null;
        }
        return Integer.parseInt(config);
    }

    private void setSwapConfig(int itemId, int index) {
        itemId = ItemVariationMapping.map(itemId);
        this.configManager.setConfiguration(CONFIG_GROUP, ITEM_KEY_PREFIX + itemId, index);
    }

    private void unsetSwapConfig(int itemId) {
        itemId = ItemVariationMapping.map(itemId);
        this.configManager.unsetConfiguration(CONFIG_GROUP, ITEM_KEY_PREFIX + itemId);
    }

    private void enableCustomization() {
        this.keyManager.registerKeyListener(this.inputListener);
        this.refreshShiftClickCustomizationMenus();
        this.clientThread.invoke(this::resetItemCompositionCache);
    }

    private void disableCustomization() {
        this.keyManager.unregisterKeyListener(this.inputListener);
        this.removeShiftClickCustomizationMenus();
        this.configuringShiftClick = false;
        this.clientThread.invoke(this::resetItemCompositionCache);
    }

    @Subscribe
    public void onWidgetMenuOptionClicked(WidgetMenuOptionClicked event) {
        if (event.getWidget() == WidgetInfo.FIXED_VIEWPORT_INVENTORY_TAB || event.getWidget() == WidgetInfo.RESIZABLE_VIEWPORT_INVENTORY_TAB || event.getWidget() == WidgetInfo.RESIZABLE_VIEWPORT_BOTTOM_LINE_INVENTORY_TAB) {
            this.configuringShiftClick = event.getMenuOption().equals(CONFIGURE) && Text.removeTags(event.getMenuTarget()).equals(MENU_TARGET);
            this.refreshShiftClickCustomizationMenus();
        }
    }

    @Subscribe
    public void onMenuOpened(MenuOpened event) {
        MenuEntry[] entries;
        if (!this.configuringShiftClick) {
            return;
        }
        MenuEntry firstEntry = event.getFirstEntry();
        if (firstEntry == null) {
            return;
        }
        int widgetId = firstEntry.getParam1();
        if (widgetId != WidgetInfo.INVENTORY.getId()) {
            return;
        }
        int itemId = firstEntry.getIdentifier();
        if (itemId == -1) {
            return;
        }
        ItemComposition itemComposition = this.client.getItemDefinition(itemId);
        String itemName = itemComposition.getName();
        String option = "Use";
        int shiftClickActionindex = itemComposition.getShiftClickActionIndex();
        String[] inventoryActions = itemComposition.getInventoryActions();
        if (shiftClickActionindex >= 0 && shiftClickActionindex < inventoryActions.length) {
            option = inventoryActions[shiftClickActionindex];
        }
        for (MenuEntry entry : entries = event.getMenuEntries()) {
            if (!itemName.equals(Text.removeTags(entry.getTarget()))) continue;
            entry.setType(MenuAction.RUNELITE.getId());
            if (!option.equals(entry.getOption())) continue;
            entry.setOption("* " + option);
        }
        MenuEntry resetShiftClickEntry = new MenuEntry();
        resetShiftClickEntry.setOption(RESET);
        resetShiftClickEntry.setTarget(MENU_TARGET);
        resetShiftClickEntry.setIdentifier(itemId);
        resetShiftClickEntry.setParam1(widgetId);
        resetShiftClickEntry.setType(MenuAction.RUNELITE.getId());
        this.client.setMenuEntries(ArrayUtils.addAll(entries, resetShiftClickEntry));
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (event.getMenuAction() != MenuAction.RUNELITE || event.getWidgetId() != WidgetInfo.INVENTORY.getId()) {
            return;
        }
        int itemId = event.getId();
        if (itemId == -1) {
            return;
        }
        String option = event.getMenuOption();
        String target = event.getMenuTarget();
        ItemComposition itemComposition = this.client.getItemDefinition(itemId);
        if (option.equals(RESET) && target.equals(MENU_TARGET)) {
            this.unsetSwapConfig(itemId);
            return;
        }
        if (!itemComposition.getName().equals(Text.removeTags(target))) {
            return;
        }
        int index = -1;
        boolean valid = false;
        if (option.equals("Use")) {
            valid = true;
        } else {
            String[] inventoryActions = itemComposition.getInventoryActions();
            for (index = 0; index < inventoryActions.length; ++index) {
                if (!option.equals(inventoryActions[index])) continue;
                valid = true;
                break;
            }
        }
        if (valid) {
            this.setSwapConfig(itemId, index);
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        int eventId = event.getIdentifier();
        String option = Text.removeTags(event.getOption()).toLowerCase();
        String target = Text.removeTags(event.getTarget()).toLowerCase();
        NPC hintArrowNpc = this.client.getHintArrowNpc();
        if (hintArrowNpc != null && hintArrowNpc.getIndex() == eventId && NPC_MENU_TYPES.contains((Object)MenuAction.of(event.getType()))) {
            return;
        }
        if (option.equals("talk-to")) {
            if (this.config.swapPickpocket() && target.contains("h.a.m.")) {
                this.swap("pickpocket", option, target, true);
            }
            if (this.config.swapAbyssTeleport() && target.contains("mage of zamorak")) {
                this.swap("teleport", option, target, true);
            }
            if (this.config.swapBank()) {
                this.swap("bank", option, target, true);
            }
            if (this.config.swapContract()) {
                this.swap("contract", option, target, true);
            }
            if (this.config.swapExchange()) {
                this.swap("exchange", option, target, true);
            }
            if (this.config.swapDarkMage()) {
                this.swap("repairs", option, target, true);
            }
            if (this.config.swapAssignment()) {
                this.swap("assignment", option, target, true);
            }
            if (this.config.swapTrade()) {
                this.swap("trade", option, target, true);
                this.swap("trade-with", option, target, true);
            }
            if (this.config.claimSlime() && target.equals("robin")) {
                this.swap("claim-slime", option, target, true);
            }
            if (this.config.swapTravel()) {
                this.swap("travel", option, target, true);
                this.swap("pay-fare", option, target, true);
                this.swap("charter", option, target, true);
                this.swap("take-boat", option, target, true);
                this.swap("fly", option, target, true);
                this.swap("jatizso", option, target, true);
                this.swap("neitiznot", option, target, true);
                this.swap("rellekka", option, target, true);
                this.swap("follow", option, target, true);
                this.swap("transport", option, target, true);
            }
            if (this.config.swapPay()) {
                this.swap("pay", option, target, true);
                this.swap("pay (", option, target, false);
            }
            if (this.config.swapDecant()) {
                this.swap("decant", option, target, true);
            }
            if (this.config.swapQuick()) {
                this.swap("quick-travel", option, target, true);
            }
        } else if (this.config.swapTravel() && option.equals("pass") && target.equals("energy barrier")) {
            this.swap("pay-toll(2-ecto)", option, target, true);
        } else if (this.config.swapTravel() && option.equals("open") && target.equals("gate")) {
            this.swap("pay-toll(10gp)", option, target, true);
        } else if (this.config.swapTravel() && option.equals("inspect") && target.equals("trapdoor")) {
            this.swap("travel", option, target, true);
        } else if (this.config.swapHarpoon() && option.equals("cage")) {
            this.swap("harpoon", option, target, true);
        } else if (this.config.swapHarpoon() && (option.equals("big net") || option.equals("net"))) {
            this.swap("harpoon", option, target, true);
        } else if (this.config.swapHomePortal() != HouseMode.ENTER && option.equals("enter")) {
            switch (this.config.swapHomePortal()) {
                case HOME: {
                    this.swap("home", option, target, true);
                    break;
                }
                case BUILD_MODE: {
                    this.swap("build mode", option, target, true);
                    break;
                }
                case FRIENDS_HOUSE: {
                    this.swap("friend's house", option, target, true);
                }
            }
        } else if (this.config.swapFairyRing() != FairyRingMode.OFF && this.config.swapFairyRing() != FairyRingMode.ZANARIS && (option.equals("zanaris") || option.equals("configure") || option.equals("tree"))) {
            if (this.config.swapFairyRing() == FairyRingMode.LAST_DESTINATION) {
                this.swap("last-destination", option, target, false);
            } else if (this.config.swapFairyRing() == FairyRingMode.CONFIGURE) {
                this.swap("configure", option, target, false);
            }
        } else if (this.config.swapFairyRing() == FairyRingMode.ZANARIS && option.equals("tree")) {
            this.swap("zanaris", option, target, false);
        } else if (this.config.swapBoxTrap() && (option.equals("check") || option.equals("dismantle"))) {
            this.swap("reset", option, target, true);
        } else if (this.config.swapBoxTrap() && option.equals("take")) {
            this.swap("lay", option, target, true);
        } else if (this.config.swapChase() && option.equals("pick-up")) {
            this.swap("chase", option, target, true);
        } else if (this.config.swapBirdhouseEmpty() && option.equals("interact") && target.contains("birdhouse")) {
            this.swap("empty", option, target, true);
        } else if (this.config.swapQuick() && option.equals("ring")) {
            this.swap("quick-start", option, target, true);
        } else if (this.config.swapQuick() && option.equals("pass")) {
            this.swap("quick-pass", option, target, true);
            this.swap("quick pass", option, target, true);
        } else if (this.config.swapQuick() && option.equals("open")) {
            this.swap("quick-open", option, target, true);
        } else if (this.config.swapAdmire() && option.equals("admire")) {
            this.swap("teleport", option, target, true);
            this.swap("spellbook", option, target, true);
            this.swap("perks", option, target, true);
        } else if (this.config.swapPrivate() && option.equals("shared")) {
            this.swap("private", option, target, true);
        } else if (this.config.swapPick() && option.equals("pick")) {
            this.swap("pick-lots", option, target, true);
        } else if (this.config.shiftClickCustomization() && this.shiftModifier && !option.equals("use")) {
            Integer customOption = this.getSwapConfig(eventId);
            if (customOption != null && customOption == -1) {
                this.swap("use", option, target, true);
            }
        } else if (this.config.swapTeleportItem() && option.equals("wear")) {
            this.swap("rub", option, target, true);
            this.swap("teleport", option, target, true);
        } else if (option.equals("wield")) {
            if (this.config.swapTeleportItem()) {
                this.swap("teleport", option, target, true);
            }
        } else if (this.config.swapBones() && option.equals("bury")) {
            this.swap("use", option, target, true);
        }
    }

    @Subscribe
    public void onPostItemComposition(PostItemComposition event) {
        ItemComposition itemComposition = event.getItemComposition();
        Integer option = this.getSwapConfig(itemComposition.getId());
        if (option != null) {
            itemComposition.setShiftClickActionIndex(option);
        }
    }

    @Subscribe
    public void onFocusChanged(FocusChanged event) {
        if (!event.isFocused()) {
            this.shiftModifier = false;
        }
    }

    private int searchIndex(MenuEntry[] entries, String option, String target, boolean strict) {
        for (int i = entries.length - 1; i >= 0; --i) {
            MenuEntry entry = entries[i];
            String entryOption = Text.removeTags(entry.getOption()).toLowerCase();
            String entryTarget = Text.removeTags(entry.getTarget()).toLowerCase();
            if (!(strict ? entryOption.equals(option) && entryTarget.equals(target) : entryOption.contains(option.toLowerCase()) && entryTarget.equals(target))) continue;
            return i;
        }
        return -1;
    }

    private void swap(String optionA, String optionB, String target, boolean strict) {
        MenuEntry[] entries = this.client.getMenuEntries();
        int idxA = this.searchIndex(entries, optionA, target, strict);
        int idxB = this.searchIndex(entries, optionB, target, strict);
        if (idxA >= 0 && idxB >= 0) {
            MenuEntry entry = entries[idxA];
            entries[idxA] = entries[idxB];
            entries[idxB] = entry;
            this.client.setMenuEntries(entries);
        }
    }

    private void removeShiftClickCustomizationMenus() {
        this.menuManager.removeManagedCustomMenu(FIXED_INVENTORY_TAB_CONFIGURE);
        this.menuManager.removeManagedCustomMenu(FIXED_INVENTORY_TAB_SAVE);
        this.menuManager.removeManagedCustomMenu(RESIZABLE_BOTTOM_LINE_INVENTORY_TAB_CONFIGURE);
        this.menuManager.removeManagedCustomMenu(RESIZABLE_BOTTOM_LINE_INVENTORY_TAB_SAVE);
        this.menuManager.removeManagedCustomMenu(RESIZABLE_INVENTORY_TAB_CONFIGURE);
        this.menuManager.removeManagedCustomMenu(RESIZABLE_INVENTORY_TAB_SAVE);
    }

    private void refreshShiftClickCustomizationMenus() {
        this.removeShiftClickCustomizationMenus();
        if (this.configuringShiftClick) {
            this.menuManager.addManagedCustomMenu(FIXED_INVENTORY_TAB_SAVE);
            this.menuManager.addManagedCustomMenu(RESIZABLE_BOTTOM_LINE_INVENTORY_TAB_SAVE);
            this.menuManager.addManagedCustomMenu(RESIZABLE_INVENTORY_TAB_SAVE);
        } else {
            this.menuManager.addManagedCustomMenu(FIXED_INVENTORY_TAB_CONFIGURE);
            this.menuManager.addManagedCustomMenu(RESIZABLE_BOTTOM_LINE_INVENTORY_TAB_CONFIGURE);
            this.menuManager.addManagedCustomMenu(RESIZABLE_INVENTORY_TAB_CONFIGURE);
        }
    }

    public boolean isConfiguringShiftClick() {
        return this.configuringShiftClick;
    }

    public void setShiftModifier(boolean shiftModifier) {
        this.shiftModifier = shiftModifier;
    }
}

