/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.lowmemory;

import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;

@PluginDescriptor(name="Low Detail", description="Turn off ground decorations and certain textures, reducing memory usage", tags={"memory", "usage", "ground", "decorations"}, enabledByDefault=false)
public class LowMemoryPlugin
extends Plugin {
    @Inject
    private Client client;

    @Override
    protected void startUp() throws Exception {
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.client.changeMemoryMode(true);
        }
    }

    @Override
    protected void shutDown() throws Exception {
        this.client.changeMemoryMode(false);
    }

    @Subscribe
    private void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGIN_SCREEN) {
            this.client.changeMemoryMode(true);
        }
    }
}

