/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.loottracker;

import java.util.Arrays;
import net.runelite.client.plugins.loottracker.LootTrackerItem;

final class LootTrackerRecord {
    private final String title;
    private final String subTitle;
    private final LootTrackerItem[] items;
    private final long timestamp;

    boolean matches(String id) {
        if (id == null) {
            return true;
        }
        return this.title.equals(id);
    }

    public LootTrackerRecord(String title, String subTitle, LootTrackerItem[] items, long timestamp) {
        this.title = title;
        this.subTitle = subTitle;
        this.items = items;
        this.timestamp = timestamp;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSubTitle() {
        return this.subTitle;
    }

    public LootTrackerItem[] getItems() {
        return this.items;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LootTrackerRecord)) {
            return false;
        }
        LootTrackerRecord other = (LootTrackerRecord)o;
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$subTitle = this.getSubTitle();
        String other$subTitle = other.getSubTitle();
        if (this$subTitle == null ? other$subTitle != null : !this$subTitle.equals(other$subTitle)) {
            return false;
        }
        return Arrays.deepEquals(this.getItems(), other.getItems());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $subTitle = this.getSubTitle();
        result = result * 59 + ($subTitle == null ? 43 : $subTitle.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getItems());
        return result;
    }

    public String toString() {
        return "LootTrackerRecord(title=" + this.getTitle() + ", subTitle=" + this.getSubTitle() + ", items=" + Arrays.deepToString(this.getItems()) + ", timestamp=" + this.getTimestamp() + ")";
    }
}

