/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.loottracker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.loottracker.LootTrackerBox;
import net.runelite.client.plugins.loottracker.LootTrackerConfig;
import net.runelite.client.plugins.loottracker.LootTrackerItem;
import net.runelite.client.plugins.loottracker.LootTrackerPlugin;
import net.runelite.client.plugins.loottracker.LootTrackerRecord;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.PluginErrorPanel;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.StackFormatter;
import net.runelite.http.api.loottracker.LootTrackerClient;

class LootTrackerPanel
extends PluginPanel {
    private static final int MAX_LOOT_BOXES = 500;
    private static final ImageIcon SINGLE_LOOT_VIEW;
    private static final ImageIcon SINGLE_LOOT_VIEW_FADED;
    private static final ImageIcon SINGLE_LOOT_VIEW_HOVER;
    private static final ImageIcon GROUPED_LOOT_VIEW;
    private static final ImageIcon GROUPED_LOOT_VIEW_FADED;
    private static final ImageIcon GROUPED_LOOT_VIEW_HOVER;
    private static final ImageIcon BACK_ARROW_ICON;
    private static final ImageIcon BACK_ARROW_ICON_HOVER;
    private static final ImageIcon VISIBLE_ICON;
    private static final ImageIcon VISIBLE_ICON_HOVER;
    private static final ImageIcon INVISIBLE_ICON;
    private static final ImageIcon INVISIBLE_ICON_HOVER;
    private static final String HTML_LABEL_TEMPLATE = "<html><body style='color:%s'>%s<span style='color:white'>%s</span></body></html>";
    private final PluginErrorPanel errorPanel = new PluginErrorPanel();
    private final JPanel logsContainer = new JPanel();
    private final JPanel overallPanel = new JPanel();
    private final JLabel overallKillsLabel = new JLabel();
    private final JLabel overallGpLabel = new JLabel();
    private final JLabel overallIcon = new JLabel();
    private final JPanel actionsContainer = new JPanel();
    private final JLabel detailsTitle = new JLabel();
    private final JLabel backBtn = new JLabel();
    private final JLabel viewHiddenBtn = new JLabel();
    private final JLabel singleLootBtn = new JLabel();
    private final JLabel groupedLootBtn = new JLabel();
    private final List<LootTrackerRecord> records = new ArrayList<LootTrackerRecord>();
    private final List<LootTrackerBox> boxes = new ArrayList<LootTrackerBox>();
    private final ItemManager itemManager;
    private final LootTrackerPlugin plugin;
    private final LootTrackerConfig config;
    private boolean groupLoot;
    private boolean hideIgnoredItems;
    private String currentView;

    LootTrackerPanel(LootTrackerPlugin plugin, ItemManager itemManager, LootTrackerConfig config) {
        this.itemManager = itemManager;
        this.plugin = plugin;
        this.config = config;
        this.hideIgnoredItems = true;
        this.setBorder(new EmptyBorder(6, 6, 6, 6));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setLayout(new BorderLayout());
        JPanel layoutPanel = new JPanel();
        layoutPanel.setLayout(new BoxLayout(layoutPanel, 1));
        this.add((Component)layoutPanel, "North");
        this.actionsContainer.setLayout(new BorderLayout());
        this.actionsContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.actionsContainer.setPreferredSize(new Dimension(0, 30));
        this.actionsContainer.setBorder(new EmptyBorder(5, 5, 5, 10));
        this.actionsContainer.setVisible(false);
        JPanel viewControls = new JPanel(new GridLayout(1, 3, 10, 0));
        viewControls.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.singleLootBtn.setIcon(SINGLE_LOOT_VIEW);
        this.singleLootBtn.setToolTipText("Show each kill separately");
        this.singleLootBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                LootTrackerPanel.this.changeGrouping(false);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                LootTrackerPanel.this.singleLootBtn.setIcon(LootTrackerPanel.this.groupLoot ? SINGLE_LOOT_VIEW_FADED : SINGLE_LOOT_VIEW);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                LootTrackerPanel.this.singleLootBtn.setIcon(LootTrackerPanel.this.groupLoot ? SINGLE_LOOT_VIEW_HOVER : SINGLE_LOOT_VIEW);
            }
        });
        this.groupedLootBtn.setIcon(GROUPED_LOOT_VIEW);
        this.groupedLootBtn.setToolTipText("Group loot by source");
        this.groupedLootBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                LootTrackerPanel.this.changeGrouping(true);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                LootTrackerPanel.this.groupedLootBtn.setIcon(LootTrackerPanel.this.groupLoot ? GROUPED_LOOT_VIEW : GROUPED_LOOT_VIEW_FADED);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                LootTrackerPanel.this.groupedLootBtn.setIcon(LootTrackerPanel.this.groupLoot ? GROUPED_LOOT_VIEW : GROUPED_LOOT_VIEW_HOVER);
            }
        });
        this.viewHiddenBtn.setIcon(VISIBLE_ICON);
        this.viewHiddenBtn.setToolTipText("Show ignored items");
        this.viewHiddenBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                LootTrackerPanel.this.changeItemHiding(!LootTrackerPanel.this.hideIgnoredItems);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                LootTrackerPanel.this.viewHiddenBtn.setIcon(LootTrackerPanel.this.hideIgnoredItems ? INVISIBLE_ICON : VISIBLE_ICON);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                LootTrackerPanel.this.viewHiddenBtn.setIcon(LootTrackerPanel.this.hideIgnoredItems ? INVISIBLE_ICON_HOVER : VISIBLE_ICON_HOVER);
            }
        });
        viewControls.add(this.groupedLootBtn);
        viewControls.add(this.singleLootBtn);
        viewControls.add(this.viewHiddenBtn);
        this.changeGrouping(true);
        this.changeItemHiding(true);
        JPanel leftTitleContainer = new JPanel(new BorderLayout(5, 0));
        leftTitleContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.detailsTitle.setForeground(Color.WHITE);
        this.backBtn.setIcon(BACK_ARROW_ICON);
        this.backBtn.setVisible(false);
        this.backBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                LootTrackerPanel.this.currentView = null;
                LootTrackerPanel.this.backBtn.setVisible(false);
                LootTrackerPanel.this.detailsTitle.setText("");
                LootTrackerPanel.this.rebuild();
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                LootTrackerPanel.this.backBtn.setIcon(BACK_ARROW_ICON);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                LootTrackerPanel.this.backBtn.setIcon(BACK_ARROW_ICON_HOVER);
            }
        });
        leftTitleContainer.add((Component)this.backBtn, "West");
        leftTitleContainer.add((Component)this.detailsTitle, "Center");
        this.actionsContainer.add((Component)leftTitleContainer, "West");
        this.actionsContainer.add((Component)viewControls, "East");
        this.overallPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(5, 0, 0, 0, ColorScheme.DARK_GRAY_COLOR), BorderFactory.createEmptyBorder(8, 10, 8, 10)));
        this.overallPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.overallPanel.setLayout(new BorderLayout());
        this.overallPanel.setVisible(false);
        JPanel overallInfo = new JPanel();
        overallInfo.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        overallInfo.setLayout(new GridLayout(2, 1));
        overallInfo.setBorder(new EmptyBorder(2, 10, 2, 0));
        this.overallKillsLabel.setFont(FontManager.getRunescapeSmallFont());
        this.overallGpLabel.setFont(FontManager.getRunescapeSmallFont());
        overallInfo.add(this.overallKillsLabel);
        overallInfo.add(this.overallGpLabel);
        this.overallPanel.add((Component)this.overallIcon, "West");
        this.overallPanel.add((Component)overallInfo, "Center");
        JMenuItem reset = new JMenuItem("Reset All");
        reset.addActionListener(e -> {
            this.records.removeIf(r -> r.matches(this.currentView));
            this.boxes.removeIf(b -> b.matches(this.currentView));
            this.updateOverall();
            this.logsContainer.removeAll();
            this.logsContainer.repaint();
            LootTrackerClient client2 = plugin.getLootTrackerClient();
            if (client2 != null && config.syncPanel()) {
                client2.delete(this.currentView);
            }
        });
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setBorder(new EmptyBorder(5, 5, 5, 5));
        popupMenu.add(reset);
        this.overallPanel.setComponentPopupMenu(popupMenu);
        this.logsContainer.setLayout(new BoxLayout(this.logsContainer, 1));
        layoutPanel.add(this.actionsContainer);
        layoutPanel.add(this.overallPanel);
        layoutPanel.add(this.logsContainer);
        this.errorPanel.setContent("Loot trackers", "You have not received any loot yet.");
        this.add(this.errorPanel);
    }

    void loadHeaderIcon(BufferedImage img) {
        this.overallIcon.setIcon(new ImageIcon(img));
    }

    void add(String eventName, int actorLevel, LootTrackerItem[] items) {
        Object subTitle = actorLevel > -1 ? "(lvl-" + actorLevel + ")" : "";
        LootTrackerRecord record = new LootTrackerRecord(eventName, (String)subTitle, items, System.currentTimeMillis());
        this.records.add(record);
        LootTrackerBox box = this.buildBox(record);
        if (box != null) {
            box.rebuild();
            this.updateOverall();
        }
    }

    void addRecords(Collection<LootTrackerRecord> recs) {
        this.records.addAll(recs);
        this.rebuild();
    }

    private void changeGrouping(boolean group) {
        this.groupLoot = group;
        this.rebuild();
        this.groupedLootBtn.setIcon(group ? GROUPED_LOOT_VIEW : GROUPED_LOOT_VIEW_FADED);
        this.singleLootBtn.setIcon(group ? SINGLE_LOOT_VIEW_FADED : SINGLE_LOOT_VIEW);
    }

    private void changeItemHiding(boolean hide) {
        this.hideIgnoredItems = hide;
        this.rebuild();
        this.viewHiddenBtn.setIcon(this.hideIgnoredItems ? VISIBLE_ICON : INVISIBLE_ICON);
    }

    void updateIgnoredRecords() {
        for (LootTrackerRecord r : this.records) {
            for (LootTrackerItem item : r.getItems()) {
                if (this.plugin.isIgnored(item.getName()) == item.isIgnored()) continue;
                item.setIgnored(this.plugin.isIgnored(item.getName()));
            }
        }
        this.rebuild();
    }

    private void rebuild() {
        this.logsContainer.removeAll();
        this.boxes.clear();
        int start = 0;
        if (!this.groupLoot && this.records.size() > 500) {
            start = this.records.size() - 500;
        }
        for (int i = start; i < this.records.size(); ++i) {
            this.buildBox(this.records.get(i));
        }
        this.boxes.forEach(LootTrackerBox::rebuild);
        this.updateOverall();
        this.logsContainer.revalidate();
        this.logsContainer.repaint();
    }

    private LootTrackerBox buildBox(LootTrackerRecord record) {
        if (!record.matches(this.currentView)) {
            return null;
        }
        if (this.groupLoot) {
            for (LootTrackerBox box : this.boxes) {
                if (!box.matches(record)) continue;
                box.combine(record);
                return box;
            }
        }
        this.remove(this.errorPanel);
        this.actionsContainer.setVisible(true);
        this.overallPanel.setVisible(true);
        LootTrackerBox box = new LootTrackerBox(this.itemManager, record.getTitle(), record.getSubTitle(), this.hideIgnoredItems, this.plugin::toggleItem);
        box.combine(record);
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setBorder(new EmptyBorder(5, 5, 5, 5));
        box.setComponentPopupMenu(popupMenu);
        JMenuItem reset = new JMenuItem("Reset");
        reset.addActionListener(e -> {
            this.records.removeAll(box.getRecords());
            this.boxes.remove(box);
            this.updateOverall();
            this.logsContainer.remove(box);
            this.logsContainer.repaint();
            LootTrackerClient client2 = this.plugin.getLootTrackerClient();
            if (client2 != null && this.groupLoot && this.config.syncPanel()) {
                client2.delete(box.getId());
            }
        });
        popupMenu.add(reset);
        JMenuItem details = new JMenuItem("View details");
        details.addActionListener(e -> {
            this.currentView = record.getTitle();
            this.detailsTitle.setText(this.currentView);
            this.backBtn.setVisible(true);
            this.rebuild();
        });
        popupMenu.add(details);
        this.boxes.add(box);
        this.logsContainer.add((Component)box, 0);
        if (!this.groupLoot && this.boxes.size() > 500) {
            this.logsContainer.remove(this.boxes.remove(0));
        }
        return box;
    }

    private void updateOverall() {
        long overallKills = 0L;
        long overallGp = 0L;
        for (LootTrackerRecord record : this.records) {
            if (!record.matches(this.currentView)) continue;
            int present = record.getItems().length;
            for (LootTrackerItem item : record.getItems()) {
                if (this.hideIgnoredItems && item.isIgnored()) {
                    --present;
                    continue;
                }
                overallGp += item.getPrice();
            }
            if (present <= 0) continue;
            ++overallKills;
        }
        this.overallKillsLabel.setText(LootTrackerPanel.htmlLabel("Total count: ", overallKills));
        this.overallGpLabel.setText(LootTrackerPanel.htmlLabel("Total value: ", overallGp));
    }

    private static String htmlLabel(String key, long value) {
        String valueStr = StackFormatter.quantityToStackSize(value);
        return String.format(HTML_LABEL_TEMPLATE, ColorUtil.toHexColor(ColorScheme.LIGHT_GRAY_COLOR), key, valueStr);
    }

    static {
        BufferedImage singleLootImg = ImageUtil.getResourceStreamFromClass(LootTrackerPlugin.class, "single_loot_icon.png");
        BufferedImage groupedLootImg = ImageUtil.getResourceStreamFromClass(LootTrackerPlugin.class, "grouped_loot_icon.png");
        BufferedImage backArrowImg = ImageUtil.getResourceStreamFromClass(LootTrackerPlugin.class, "back_icon.png");
        BufferedImage visibleImg = ImageUtil.getResourceStreamFromClass(LootTrackerPlugin.class, "visible_icon.png");
        BufferedImage invisibleImg = ImageUtil.getResourceStreamFromClass(LootTrackerPlugin.class, "invisible_icon.png");
        SINGLE_LOOT_VIEW = new ImageIcon(singleLootImg);
        SINGLE_LOOT_VIEW_FADED = new ImageIcon(ImageUtil.alphaOffset(singleLootImg, -180));
        SINGLE_LOOT_VIEW_HOVER = new ImageIcon(ImageUtil.alphaOffset(singleLootImg, -220));
        GROUPED_LOOT_VIEW = new ImageIcon(groupedLootImg);
        GROUPED_LOOT_VIEW_FADED = new ImageIcon(ImageUtil.alphaOffset(groupedLootImg, -180));
        GROUPED_LOOT_VIEW_HOVER = new ImageIcon(ImageUtil.alphaOffset(groupedLootImg, -220));
        BACK_ARROW_ICON = new ImageIcon(backArrowImg);
        BACK_ARROW_ICON_HOVER = new ImageIcon(ImageUtil.alphaOffset(backArrowImg, -180));
        VISIBLE_ICON = new ImageIcon(visibleImg);
        VISIBLE_ICON_HOVER = new ImageIcon(ImageUtil.alphaOffset(visibleImg, -220));
        INVISIBLE_ICON = new ImageIcon(invisibleImg);
        INVISIBLE_ICON_HOVER = new ImageIcon(ImageUtil.alphaOffset(invisibleImg, -220));
    }
}

