/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.loottracker;

import com.google.common.base.Strings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import net.runelite.client.game.AsyncBufferedImage;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.loottracker.LootTrackerItem;
import net.runelite.client.plugins.loottracker.LootTrackerRecord;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.StackFormatter;
import net.runelite.client.util.Text;

class LootTrackerBox
extends JPanel {
    private static final int ITEMS_PER_ROW = 5;
    private final JPanel itemContainer = new JPanel();
    private final JLabel priceLabel = new JLabel();
    private final JLabel subTitleLabel = new JLabel();
    private final ItemManager itemManager;
    private final String id;
    private final List<LootTrackerRecord> records = new ArrayList<LootTrackerRecord>();
    private long totalPrice;
    private boolean hideIgnoredItems;
    private BiConsumer<String, Boolean> onItemToggle;

    LootTrackerBox(ItemManager itemManager, String id, @Nullable String subtitle, boolean hideIgnoredItems, BiConsumer<String, Boolean> onItemToggle) {
        this.id = id;
        this.itemManager = itemManager;
        this.onItemToggle = onItemToggle;
        this.hideIgnoredItems = hideIgnoredItems;
        this.setLayout(new BorderLayout(0, 1));
        this.setBorder(new EmptyBorder(5, 0, 0, 0));
        JPanel logTitle = new JPanel(new BorderLayout(5, 0));
        logTitle.setBorder(new EmptyBorder(7, 7, 7, 7));
        logTitle.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
        JLabel titleLabel = new JLabel(Text.removeTags(id));
        titleLabel.setFont(FontManager.getRunescapeSmallFont());
        titleLabel.setForeground(Color.WHITE);
        logTitle.add((Component)titleLabel, "West");
        this.subTitleLabel.setFont(FontManager.getRunescapeSmallFont());
        this.subTitleLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        logTitle.add((Component)this.subTitleLabel, "Center");
        if (!Strings.isNullOrEmpty(subtitle)) {
            this.subTitleLabel.setText(subtitle);
        }
        this.priceLabel.setFont(FontManager.getRunescapeSmallFont());
        this.priceLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        logTitle.add((Component)this.priceLabel, "East");
        this.add((Component)logTitle, "North");
        this.add((Component)this.itemContainer, "Center");
    }

    private long getTotalKills() {
        return this.hideIgnoredItems ? this.records.stream().filter(r -> !Arrays.stream(r.getItems()).allMatch(LootTrackerItem::isIgnored)).count() : (long)this.records.size();
    }

    boolean matches(LootTrackerRecord record) {
        return record.getTitle().equals(this.id);
    }

    boolean matches(String id) {
        if (id == null) {
            return true;
        }
        return this.id.equals(id);
    }

    void combine(LootTrackerRecord record) {
        if (!this.matches(record)) {
            throw new IllegalArgumentException(record.toString());
        }
        this.records.add(record);
    }

    void rebuild() {
        this.buildItems();
        this.priceLabel.setText(StackFormatter.quantityToStackSize(this.totalPrice) + " gp");
        this.priceLabel.setToolTipText(StackFormatter.formatNumber(this.totalPrice) + " gp");
        long kills = this.getTotalKills();
        if (kills > 1L) {
            this.subTitleLabel.setText("x " + kills);
        }
        this.validate();
        this.repaint();
    }

    private void buildItems() {
        ArrayList<LootTrackerItem> allItems = new ArrayList<LootTrackerItem>();
        ArrayList<LootTrackerItem> items = new ArrayList<LootTrackerItem>();
        this.totalPrice = 0L;
        for (LootTrackerRecord record : this.records) {
            allItems.addAll(Arrays.asList(record.getItems()));
        }
        if (this.hideIgnoredItems) {
            boolean hideBox = allItems.stream().allMatch(LootTrackerItem::isIgnored);
            this.setVisible(!hideBox);
            if (hideBox) {
                return;
            }
        }
        for (LootTrackerItem entry : allItems) {
            if (entry.isIgnored() && this.hideIgnoredItems) continue;
            this.totalPrice += entry.getPrice();
            int quantity = 0;
            for (LootTrackerItem i : items) {
                if (i.getId() != entry.getId()) continue;
                quantity = i.getQuantity();
                items.remove(i);
                break;
            }
            if (quantity > 0) {
                int newQuantity = entry.getQuantity() + quantity;
                long pricePerItem = entry.getPrice() == 0L ? 0L : entry.getPrice() / (long)entry.getQuantity();
                items.add(new LootTrackerItem(entry.getId(), entry.getName(), newQuantity, pricePerItem * (long)newQuantity, entry.isIgnored()));
                continue;
            }
            items.add(entry);
        }
        items.sort((i1, i2) -> Long.compare(i2.getPrice(), i1.getPrice()));
        int rowSize = (items.size() % 5 == 0 ? 0 : 1) + items.size() / 5;
        this.itemContainer.removeAll();
        this.itemContainer.setLayout(new GridLayout(rowSize, 5, 1, 1));
        for (int i = 0; i < rowSize * 5; ++i) {
            JPanel slotContainer = new JPanel();
            slotContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            if (i < items.size()) {
                LootTrackerItem item = (LootTrackerItem)items.get(i);
                JLabel imageLabel = new JLabel();
                imageLabel.setToolTipText(LootTrackerBox.buildToolTip(item));
                imageLabel.setVerticalAlignment(0);
                imageLabel.setHorizontalAlignment(0);
                AsyncBufferedImage itemImage = this.itemManager.getImage(item.getId(), item.getQuantity(), item.getQuantity() > 1);
                if (item.isIgnored()) {
                    Runnable addTransparency = () -> {
                        BufferedImage transparentImage = ImageUtil.alphaOffset((BufferedImage)itemImage, 0.3f);
                        imageLabel.setIcon(new ImageIcon(transparentImage));
                    };
                    itemImage.onChanged(addTransparency);
                    addTransparency.run();
                } else {
                    itemImage.addTo(imageLabel);
                }
                slotContainer.add(imageLabel);
                JPopupMenu popupMenu = new JPopupMenu();
                popupMenu.setBorder(new EmptyBorder(5, 5, 5, 5));
                slotContainer.setComponentPopupMenu(popupMenu);
                JMenuItem toggle = new JMenuItem("Toggle item");
                toggle.addActionListener(e -> {
                    item.setIgnored(!item.isIgnored());
                    this.onItemToggle.accept(item.getName(), item.isIgnored());
                });
                popupMenu.add(toggle);
            }
            this.itemContainer.add(slotContainer);
        }
        this.itemContainer.repaint();
    }

    private static String buildToolTip(LootTrackerItem item) {
        String name = item.getName();
        int quantity = item.getQuantity();
        long price = item.getPrice();
        String ignoredLabel = item.isIgnored() ? " - Ignored" : "";
        return name + " x " + quantity + " (" + StackFormatter.quantityToStackSize(price) + ") " + ignoredLabel;
    }

    String getId() {
        return this.id;
    }

    public List<LootTrackerRecord> getRecords() {
        return this.records;
    }
}

