/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.loginscreen;

import com.google.common.base.Strings;
import com.google.inject.Provides;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyEvent;
import java.io.IOException;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.SessionOpen;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.loginscreen.LoginScreenConfig;
import net.runelite.client.util.OSType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Login Screen", description="Provides various enhancements for login screen")
public class LoginScreenPlugin
extends Plugin
implements KeyListener {
    private static final Logger log = LoggerFactory.getLogger(LoginScreenPlugin.class);
    private static final int MAX_USERNAME_LENGTH = 254;
    private static final int MAX_PASSWORD_LENGTH = 20;
    @Inject
    private Client client;
    @Inject
    private LoginScreenConfig config;
    @Inject
    private KeyManager keyManager;
    private String usernameCache;

    @Override
    protected void startUp() throws Exception {
        this.applyUsername();
        this.keyManager.registerKeyListener(this);
    }

    @Override
    protected void shutDown() throws Exception {
        if (this.config.syncUsername()) {
            this.client.getPreferences().setRememberedUsername(this.usernameCache);
        }
        this.keyManager.unregisterKeyListener(this);
    }

    @Provides
    LoginScreenConfig getConfig(ConfigManager configManager) {
        return configManager.getConfig(LoginScreenConfig.class);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (!this.config.syncUsername()) {
            return;
        }
        if (event.getGameState() == GameState.LOGIN_SCREEN) {
            this.applyUsername();
        } else if (event.getGameState() == GameState.LOGGED_IN) {
            String username = "";
            if (this.client.getPreferences().getRememberedUsername() != null) {
                username = this.client.getUsername();
            }
            if (this.config.username().equals(username)) {
                return;
            }
            log.debug("Saving username: {}", (Object)username);
            this.config.username(username);
        }
    }

    @Subscribe
    public void onSessionOpen(SessionOpen event) {
        this.applyUsername();
    }

    private void applyUsername() {
        if (!this.config.syncUsername()) {
            return;
        }
        GameState gameState = this.client.getGameState();
        if (gameState == GameState.LOGIN_SCREEN) {
            String username = this.config.username();
            if (Strings.isNullOrEmpty(username)) {
                return;
            }
            if (this.usernameCache == null) {
                this.usernameCache = this.client.getPreferences().getRememberedUsername();
            }
            this.client.getPreferences().setRememberedUsername(username);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        boolean isModifierDown;
        if (!this.config.pasteEnabled() || this.client.getGameState() != GameState.LOGIN_SCREEN) {
            return;
        }
        boolean bl = isModifierDown = OSType.getOSType() == OSType.MacOS ? e.isMetaDown() : e.isControlDown();
        if (e.getKeyCode() == 86 && isModifierDown) {
            try {
                String data = Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor).toString().trim();
                if (this.client.getCurrentLoginField() == 0) {
                    this.client.setUsername(data.substring(0, Math.min(data.length(), 254)));
                } else {
                    this.client.setPassword(data.substring(0, Math.min(data.length(), 20)));
                }
            }
            catch (UnsupportedFlavorException | IOException ex) {
                log.warn("failed to fetch clipboard data", ex);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

