/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.kingdomofmiscellania;

import com.google.common.collect.ImmutableSet;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.VarPlayer;
import net.runelite.api.Varbits;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.kingdomofmiscellania.KingdomCounter;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KingdomPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(KingdomPlugin.class);
    private static final ImmutableSet<Integer> KINGDOM_REGION = ImmutableSet.of(Integer.valueOf(10044), Integer.valueOf(10300));
    @Inject
    private Client client;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private ItemManager itemManager;
    private int favor = 0;
    private int coffer = 0;
    private KingdomCounter counter;

    @Override
    protected void shutDown() throws Exception {
        this.removeKingdomInfobox();
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        this.favor = this.client.getVar(Varbits.KINGDOM_FAVOR);
        this.coffer = this.client.getVar(Varbits.KINGDOM_COFFER);
        this.processInfobox();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGGED_IN) {
            this.processInfobox();
        }
    }

    private void processInfobox() {
        if (this.client.getGameState() == GameState.LOGGED_IN && this.hasCompletedQuest() && this.isInKingdom()) {
            this.addKingdomInfobox();
        } else {
            this.removeKingdomInfobox();
        }
    }

    private void addKingdomInfobox() {
        if (this.counter == null) {
            this.counter = new KingdomCounter(this.itemManager.getImage(8150), this);
            this.infoBoxManager.addInfoBox(this.counter);
            log.debug("Added Kingdom Infobox");
        }
    }

    private void removeKingdomInfobox() {
        if (this.counter != null) {
            this.infoBoxManager.removeInfoBox(this.counter);
            this.counter = null;
            log.debug("Removed Kingdom Infobox");
        }
    }

    private boolean isInKingdom() {
        return this.client.getLocalPlayer() != null && KINGDOM_REGION.contains(this.client.getLocalPlayer().getWorldLocation().getRegionID());
    }

    private boolean hasCompletedQuest() {
        return this.client.getVar(VarPlayer.THRONE_OF_MISCELLANIA) > 0;
    }

    static int getFavorPercent(int favor) {
        return favor * 100 / 127;
    }

    public int getFavor() {
        return this.favor;
    }

    public int getCoffer() {
        return this.coffer;
    }
}

