/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.keptondeath;

import java.util.Arrays;
import java.util.Collection;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WidgetButton {
    private static final Logger log = LoggerFactory.getLogger(WidgetButton.class);
    private static final int ICON_HEIGHT = 26;
    private static final int ICON_WIDTH = 26;
    private static final int BACKGROUND_HEIGHT = 32;
    private static final int BACKGROUND_WIDTH = 32;
    private static final int PADDING = 5;
    private static final int ICON_PADDING = 3;
    private static final int BACKGROUND_SPRITE_ID = 170;
    private static final int SELECTED_BACKGROUND_SPRITE_ID = 179;
    private String name;
    private int spriteID;
    private Widget icon;
    private Widget background;
    private boolean selected;
    private WidgetButtonCallback callback;

    WidgetButton(String name, int spriteID, boolean selectedStartState, WidgetButtonCallback callback, Client client2) {
        this.name = name;
        this.spriteID = spriteID;
        this.selected = selectedStartState;
        this.callback = callback;
        this.createBackgroundWidget(client2);
        this.createIconWidget(client2);
    }

    private void createBackgroundWidget(Client client2) {
        this.background = this.createWidget(client2);
        this.background.setOriginalWidth(32);
        this.background.setOriginalHeight(32);
        this.syncBackgroundSprite();
    }

    private void createIconWidget(Client client2) {
        this.icon = this.createWidget(client2);
        this.icon.setAction(1, "Toggle:");
        this.icon.setOnOpListener(ev -> this.onButtonClicked());
        this.icon.setHasListener(true);
        this.icon.setSpriteId(this.spriteID);
    }

    private Widget createWidget(Client client2) {
        Widget w = client2.createWidget();
        w.setType(5);
        w.setOriginalWidth(26);
        w.setOriginalHeight(26);
        w.setName("<col=ff981f>" + this.name);
        w.setIsIf3(true);
        return w;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.syncBackgroundSprite();
    }

    private void syncBackgroundSprite() {
        this.background.setSpriteId(this.selected ? 179 : 170);
    }

    static void addButtonsToContainerWidget(Widget container, Collection<WidgetButton> buttons) {
        Widget[] children = container.getChildren();
        if (children == null) {
            container.createChild(0, 5);
            children = container.getChildren();
        }
        Widget[] itemsArray = Arrays.copyOf(children, buttons.size() * 2);
        int parentId = container.getId();
        int xIncrement = 37;
        int yIncrement = 37;
        int maxRowItems = container.getWidth() / xIncrement;
        maxRowItems = maxRowItems < 1 ? 1 : maxRowItems;
        int startingIndex = 0;
        for (WidgetButton w : buttons) {
            Widget icon;
            Widget background;
            int originalX = startingIndex / 2 % maxRowItems * xIncrement;
            int originalY = startingIndex / 2 / maxRowItems * yIncrement;
            itemsArray[startingIndex] = background = WidgetButton.updateWidgetPosition(w.getBackground(), parentId, startingIndex, originalX, originalY);
            itemsArray[++startingIndex] = icon = WidgetButton.updateWidgetPosition(w.getIcon(), parentId, startingIndex, originalX + 3, originalY + 3);
            ++startingIndex;
        }
        int rows = 1 + (buttons.size() > maxRowItems ? buttons.size() / maxRowItems : 0);
        container.setOriginalHeight(yIncrement * rows);
        container.setChildren(itemsArray);
        container.revalidate();
    }

    private static Widget updateWidgetPosition(Widget w, int id, int index, int originalX, int originalY) {
        w.setParentId(id);
        w.setId(id);
        w.setIndex(index);
        w.setOriginalX(originalX);
        w.setOriginalY(originalY);
        w.revalidate();
        return w;
    }

    private void onButtonClicked() {
        this.setSelected(!this.selected);
        this.callback.run(this.name, this.selected);
    }

    public Widget getIcon() {
        return this.icon;
    }

    public Widget getBackground() {
        return this.background;
    }

    public static interface WidgetButtonCallback {
        public void run(String var1, boolean var2);
    }
}

