/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.keptondeath;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemContainer;
import net.runelite.api.SkullIcon;
import net.runelite.api.Varbits;
import net.runelite.api.WorldType;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.api.vars.AccountType;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.ItemVariationMapping;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.keptondeath.ActuallyTradeableItem;
import net.runelite.client.plugins.keptondeath.AlwaysLostItem;
import net.runelite.client.plugins.keptondeath.BrokenOnDeathItem;
import net.runelite.client.plugins.keptondeath.WidgetButton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Kept on Death", description="Reworks the Items Kept on Death interface to be more accurate", enabledByDefault=false)
public class KeptOnDeathPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(KeptOnDeathPlugin.class);
    private static final int SCRIPT_ID = 1603;
    private static final double HIGH_ALCH = 0.6;
    private static final int MAX_ROW_ITEMS = 8;
    private static final int STARTING_X = 5;
    private static final int STARTING_Y = 25;
    private static final int X_INCREMENT = 40;
    private static final int Y_INCREMENT = 38;
    private static final int ORIGINAL_WIDTH = 36;
    private static final int ORIGINAL_HEIGHT = 32;
    private static final int ORIGINAL_LOST_HEIGHT = 209;
    private static final int ORIGINAL_LOST_Y = 107;
    private static final DecimalFormat NUMBER_FORMAT = new DecimalFormat("#,###");
    private static final String MAX_KEPT_ITEMS_FORMAT = "<col=ffcc33>Max items kept on death :<br><br><col=ffcc33>~ %s ~";
    private static final String ACTION_TEXT = "Item: <col=ff981f>%s";
    private static final String DEFAULT = "<col=FFFFFF>3<col=FF981F> items protected by default";
    private static final String IS_SKULLED = "<col=ff3333>PK skull<col=ff981f> -3";
    private static final String PROTECTING_ITEM = "<col=ff3333>Protect Item prayer<col=ff981f> +1";
    private static final String ACTUAL = "Actually protecting <col=FFFFFF>%s<col=FF981F> items";
    private static final String WHITE_OUTLINE = "Items with a <col=ffffff>white outline<col=ff981f> will always be lost.";
    private static final String CHANGED_MECHANICS = "Untradeable items are kept on death in non-pvp scenarios.";
    private static final String NON_PVP = "You will have 1 hour to retrieve your lost items.";
    private static final String LINE_BREAK = "<br>";
    private static final String UIM_DEFAULT = "You are an <col=FFFFFF>UIM<col=FF981F> which means <col=FFFFFF>0<col=FF981F> items are protected by default";
    private static final int ORIGINAL_INFO_HEIGHT = 183;
    private static final int FONT_COLOR = 16750623;
    private static final String PROTECT_ITEM_BUTTON_NAME = "Protect Item Prayer";
    private static final String SKULLED_BUTTON_NAME = "Skulled";
    private static final String LOW_WILDY_BUTTON_NAME = "Low Wildy (1-20)";
    private static final String DEEP_WILDY_BUTTON_NAME = "Deep Wildy (21+)";
    private static final int PROTECT_ITEM_SPRITE_ID = 123;
    private static final int SKULL_SPRITE_ID = 523;
    private static final int SWORD_SPRITE_ID = 442;
    private static final int SKULL_2_SPRITE_ID = 524;
    @Inject
    private Client client;
    @Inject
    private ItemManager itemManager;
    private boolean widgetVisible = false;
    private LinkedHashMap<String, WidgetButton> buttonMap = new LinkedHashMap();
    private boolean isSkulled = false;
    private boolean protectingItem = false;
    private boolean hasAlwaysLost = false;
    private int wildyLevel = -1;

    @Subscribe
    protected void onScriptCallbackEvent(ScriptCallbackEvent event) {
        if (event.getEventName().equals("deathKeepBuild")) {
            if (this.isInSafeArea() || this.client.getWorldType().contains((Object)WorldType.DEADMAN)) {
                return;
            }
            this.syncSettings();
            this.createWidgetButtons();
            this.recreateItemsKeptOnDeathWidget();
        }
    }

    private void syncSettings() {
        SkullIcon s = this.client.getLocalPlayer().getSkullIcon();
        this.isSkulled = s != null && s.equals((Object)SkullIcon.SKULL) || this.isUltimateIronman();
        this.protectingItem = this.client.getVar(Varbits.PRAYER_PROTECT_ITEM) == 1;
        this.syncCurrentWildyLevel();
    }

    private void syncCurrentWildyLevel() {
        if (this.client.getVar(Varbits.IN_WILDERNESS) != 1) {
            if (this.isInPvpWorld() && !this.isInPvPSafeZone()) {
                this.wildyLevel = 1;
                return;
            }
            this.wildyLevel = -1;
            return;
        }
        int y = this.client.getLocalPlayer().getWorldLocation().getY();
        int underLevel = (y - 9920) / 8 + 1;
        int upperLevel = (y - 3520) / 8 + 1;
        this.wildyLevel = y > 6400 ? underLevel : upperLevel;
    }

    private boolean isInPvpWorld() {
        EnumSet<WorldType> world = this.client.getWorldType();
        return world.contains((Object)WorldType.PVP) || world.contains((Object)WorldType.HIGH_RISK);
    }

    private boolean isInPvPSafeZone() {
        Widget w = this.client.getWidget(WidgetInfo.PVP_WORLD_SAFE_ZONE);
        return w != null && !w.isHidden();
    }

    private boolean isInSafeArea() {
        Widget w = this.client.getWidget(WidgetInfo.ITEMS_KEPT_SAFE_ZONE_CONTAINER);
        return w != null && !w.isHidden();
    }

    private boolean isUltimateIronman() {
        return this.client.getAccountType().equals((Object)AccountType.ULTIMATE_IRONMAN);
    }

    private int getDefaultItemsKept() {
        int count;
        int n = count = this.isSkulled ? 0 : 3;
        if (this.protectingItem) {
            ++count;
        }
        return count;
    }

    private void recreateItemsKeptOnDeathWidget() {
        this.hasAlwaysLost = false;
        Widget lost = this.client.getWidget(WidgetInfo.ITEMS_LOST_ON_DEATH_CONTAINER);
        Widget kept = this.client.getWidget(WidgetInfo.ITEMS_KEPT_ON_DEATH_CONTAINER);
        if (lost != null && kept != null) {
            ArrayList items = new ArrayList();
            ItemContainer inventory = this.client.getItemContainer(InventoryID.INVENTORY);
            Item[] inv = inventory == null ? new Item[]{} : inventory.getItems();
            ItemContainer equipment = this.client.getItemContainer(InventoryID.EQUIPMENT);
            Item[] equip = equipment == null ? new Item[]{} : equipment.getItems();
            Collections.addAll(items, inv);
            Collections.addAll(items, equip);
            items.sort((o1, o2) -> {
                int o1ID = ItemVariationMapping.map(this.itemManager.canonicalize(o1.getId()));
                int o2ID = ItemVariationMapping.map(this.itemManager.canonicalize(o2.getId()));
                ItemComposition c1 = this.itemManager.getItemComposition(o1ID);
                ItemComposition c2 = this.itemManager.getItemComposition(o2ID);
                int exchangePrice1 = c1.isTradeable() ? this.itemManager.getItemPrice(c1.getId()) : c1.getPrice();
                int exchangePrice2 = c2.isTradeable() ? this.itemManager.getItemPrice(c2.getId()) : c2.getPrice();
                return exchangePrice2 - exchangePrice1;
            });
            int keepCount = this.getDefaultItemsKept();
            ArrayList<Widget> keptItems = new ArrayList<Widget>();
            ArrayList<Widget> lostItems = new ArrayList<Widget>();
            for (Item i : items) {
                int id = i.getId();
                if (id == -1) continue;
                ItemComposition c = this.itemManager.getItemComposition(i.getId());
                Widget itemWidget = this.createItemWidget(i.getQuantity(), c);
                if (id == 13190 || id == 13192) {
                    keptItems.add(itemWidget);
                    continue;
                }
                AlwaysLostItem item = AlwaysLostItem.getByItemID(i.getId());
                if (!(item == null || item.isKept() && this.wildyLevel <= 0)) {
                    itemWidget.setOnOpListener(1603, 0, i.getQuantity(), c.getName());
                    itemWidget.setBorderType(2);
                    lostItems.add(itemWidget);
                    this.hasAlwaysLost = true;
                    continue;
                }
                if (keepCount > 0) {
                    if (i.getQuantity() > keepCount) {
                        keptItems.add(this.createItemWidget(keepCount, c));
                        itemWidget.setItemQuantity(i.getQuantity() - keepCount);
                        keepCount = 0;
                    } else {
                        keptItems.add(itemWidget);
                        keepCount -= i.getQuantity();
                        continue;
                    }
                }
                if (!this.checkTradeable(i.getId(), c) && this.wildyLevel < 21) {
                    if (BrokenOnDeathItem.check(i.getId())) {
                        keptItems.add(itemWidget);
                        continue;
                    }
                    if (this.wildyLevel > 0) {
                        lostItems.add(itemWidget);
                        continue;
                    }
                    keptItems.add(itemWidget);
                    continue;
                }
                itemWidget.setOnOpListener(1603, 0, i.getQuantity(), c.getName());
                lostItems.add(itemWidget);
            }
            int rows = keptItems.size() > 8 ? keptItems.size() / 8 : 0;
            lost.setOriginalY(107 + rows * 38);
            lost.setOriginalHeight(209 - rows * 38);
            this.setWidgetChildren(kept, keptItems);
            this.setWidgetChildren(lost, lostItems);
            this.updateKeptWidgetInfoText();
        }
    }

    private void setWidgetChildren(Widget parent, List<Widget> widgets) {
        Widget[] children = parent.getChildren();
        if (children == null) {
            parent.createChild(0, 5);
            children = parent.getChildren();
        }
        Widget[] itemsArray = Arrays.copyOf(children, widgets.size());
        int parentId = parent.getId();
        int startingIndex = 0;
        for (Widget w : widgets) {
            int originalX = 5 + startingIndex % 8 * 40;
            int originalY = 25 + startingIndex / 8 * 38;
            w.setParentId(parentId);
            w.setId(parentId);
            w.setIndex(startingIndex);
            w.setOriginalX(originalX);
            w.setOriginalY(originalY);
            w.revalidate();
            itemsArray[startingIndex] = w;
            ++startingIndex;
        }
        parent.setChildren(itemsArray);
        parent.revalidate();
    }

    private String getUpdatedInfoText() {
        Object textToAdd = DEFAULT;
        if (this.isUltimateIronman()) {
            textToAdd = UIM_DEFAULT;
        } else {
            if (this.isSkulled) {
                textToAdd = (String)textToAdd + "<br><col=ff3333>PK skull<col=ff981f> -3";
            }
            if (this.protectingItem) {
                textToAdd = (String)textToAdd + "<br><col=ff3333>Protect Item prayer<col=ff981f> +1";
            }
            textToAdd = (String)textToAdd + LINE_BREAK + String.format(ACTUAL, this.getDefaultItemsKept());
        }
        if (this.wildyLevel < 1) {
            textToAdd = (String)textToAdd + "<br><br>You will have 1 hour to retrieve your lost items.";
        }
        if (this.hasAlwaysLost) {
            textToAdd = (String)textToAdd + "<br><br>Items with a <col=ffffff>white outline<col=ff981f> will always be lost.";
        }
        textToAdd = (String)textToAdd + "<br><br>Untradeable items are kept on death in non-pvp scenarios.";
        return textToAdd;
    }

    private void updateKeptWidgetInfoText() {
        this.createNewTextWidget();
        Widget lost = this.client.getWidget(WidgetInfo.ITEMS_LOST_ON_DEATH_CONTAINER);
        double total = 0.0;
        for (Widget w : lost.getChildren()) {
            if (w.getItemId() == -1) continue;
            double price = this.itemManager.getItemPrice(w.getItemId());
            if (price == 0.0) {
                price = (double)this.itemManager.getItemComposition(w.getItemId()).getPrice() * 0.6;
            }
            total += price;
        }
        Widget lostValue = this.client.getWidget(WidgetInfo.ITEMS_LOST_VALUE);
        lostValue.setText(NUMBER_FORMAT.format(total) + " gp");
        Widget kept = this.client.getWidget(WidgetInfo.ITEMS_KEPT_ON_DEATH_CONTAINER);
        Widget max = this.client.getWidget(WidgetInfo.ITEMS_KEPT_MAX);
        max.setText(String.format(MAX_KEPT_ITEMS_FORMAT, kept.getChildren().length));
    }

    private boolean checkTradeable(int id, ItemComposition c) {
        if (c.getNote() != -1) {
            return this.checkTradeable(c.getLinkedNoteId(), this.itemManager.getItemComposition(c.getLinkedNoteId()));
        }
        switch (id) {
            case 995: 
            case 13204: {
                return true;
            }
        }
        if (ActuallyTradeableItem.check(id).booleanValue()) {
            return true;
        }
        return c.isTradeable();
    }

    private void createNewTextWidget() {
        Widget x;
        Widget old = this.client.getWidget(WidgetInfo.ITEMS_KEPT_INFORMATION_CONTAINER);
        Widget[] children = old.getChildren();
        if (children != null && children.length > 0 && (x = old.getChild(children.length - 1)).getId() == WidgetInfo.ITEMS_KEPT_CUSTOM_TEXT_CONTAINER.getId()) {
            x.setText(this.getUpdatedInfoText());
            x.revalidate();
            return;
        }
        Widget w = old.createChild(-1, 4);
        w.setOriginalWidth(old.getOriginalWidth());
        w.setOriginalHeight(183 - old.getOriginalHeight());
        w.setOriginalY(old.getOriginalHeight());
        w.setFontId(494);
        w.setTextShadowed(true);
        w.setTextColor(16750623);
        w.setText(this.getUpdatedInfoText());
        w.setId(WidgetInfo.ITEMS_KEPT_CUSTOM_TEXT_CONTAINER.getId());
        w.revalidate();
        old.setOriginalHeight(183);
        old.revalidate();
    }

    private void createWidgetButtons() {
        this.buttonMap.clear();
        if (!this.isUltimateIronman()) {
            this.createButton(PROTECT_ITEM_BUTTON_NAME, 123, this.protectingItem);
            this.createButton(SKULLED_BUTTON_NAME, 523, this.isSkulled);
        }
        this.createButton(LOW_WILDY_BUTTON_NAME, 442, this.wildyLevel > 0 && this.wildyLevel <= 20);
        this.createButton(DEEP_WILDY_BUTTON_NAME, 524, this.wildyLevel > 20);
        Widget parent = this.client.getWidget(WidgetInfo.ITEMS_KEPT_INFORMATION_CONTAINER);
        parent.setType(0);
        parent.revalidate();
        WidgetButton.addButtonsToContainerWidget(parent, this.buttonMap.values());
    }

    private void createButton(String name, int spriteID, boolean startingFlag) {
        WidgetButton button = new WidgetButton(name, spriteID, startingFlag, this::buttonCallback, this.client);
        this.buttonMap.put(name, button);
    }

    private void buttonCallback(String name, boolean selected) {
        log.debug("Clicked Widget Button {}. New value: {}", (Object)name, (Object)selected);
        switch (name) {
            case "Protect Item Prayer": {
                this.protectingItem = selected;
                break;
            }
            case "Skulled": {
                this.isSkulled = selected;
                break;
            }
            case "Low Wildy (1-20)": {
                if (!selected) {
                    this.syncCurrentWildyLevel();
                    break;
                }
                this.wildyLevel = 1;
                this.buttonMap.get(DEEP_WILDY_BUTTON_NAME).setSelected(false);
                break;
            }
            case "Deep Wildy (21+)": {
                if (!selected) {
                    this.syncCurrentWildyLevel();
                    break;
                }
                this.wildyLevel = 21;
                this.buttonMap.get(LOW_WILDY_BUTTON_NAME).setSelected(false);
                break;
            }
            default: {
                log.warn("Unhandled Button Name: {}", (Object)name);
                return;
            }
        }
        this.recreateItemsKeptOnDeathWidget();
    }

    private Widget createItemWidget(int qty, ItemComposition c) {
        Widget itemWidget = this.client.createWidget();
        itemWidget.setType(5);
        itemWidget.setItemId(c.getId());
        itemWidget.setItemQuantity(qty);
        itemWidget.setHasListener(true);
        itemWidget.setIsIf3(true);
        itemWidget.setOriginalWidth(36);
        itemWidget.setOriginalHeight(32);
        itemWidget.setBorderType(1);
        itemWidget.setAction(1, String.format(ACTION_TEXT, c.getName()));
        itemWidget.setOnOpListener(1603, 1, qty, c.getName());
        return itemWidget;
    }

    public boolean isWidgetVisible() {
        return this.widgetVisible;
    }
}

