/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.itemstats.special;

import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.stream.Stream;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.client.plugins.itemstats.Builders;
import net.runelite.client.plugins.itemstats.Effect;
import net.runelite.client.plugins.itemstats.StatChange;
import net.runelite.client.plugins.itemstats.StatsChanges;
import net.runelite.client.plugins.itemstats.stats.Stats;

public class CastleWarsBandage
implements Effect {
    private static final ImmutableSet<Integer> BRACELETS = ImmutableSet.of(Integer.valueOf(11083), Integer.valueOf(11081), Integer.valueOf(11079));
    private static final double BASE_HP_PERC = 0.1;
    private static final double BRACELET_HP_PERC = 0.5;

    @Override
    public StatsChanges calculate(Client client2) {
        ItemContainer equipmentContainer = client2.getItemContainer(InventoryID.EQUIPMENT);
        double percH = this.hasBracelet(equipmentContainer) ? 0.5 : 0.1;
        StatChange hitPoints = Builders.heal(Stats.HITPOINTS, Builders.perc(percH, 0)).effect(client2);
        StatChange runEnergy = Builders.heal(Stats.RUN_ENERGY, 30).effect(client2);
        StatsChanges changes = new StatsChanges(2);
        changes.setStatChanges(new StatChange[]{hitPoints, runEnergy});
        changes.setPositivity(Stream.of(changes.getStatChanges()).map(StatChange::getPositivity).max(Comparator.comparing(Enum::ordinal)).get());
        return changes;
    }

    private boolean hasBracelet(ItemContainer equipmentContainer) {
        if (equipmentContainer == null) {
            return false;
        }
        Item[] equipment = equipmentContainer.getItems();
        if (equipment.length > EquipmentInventorySlot.GLOVES.getSlotIdx()) {
            return BRACELETS.contains(equipment[EquipmentInventorySlot.GLOVES.getSlotIdx()].getId());
        }
        return false;
    }
}

