/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.itemstats;

import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuEntry;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.itemstats.Effect;
import net.runelite.client.plugins.itemstats.ItemStatChanges;
import net.runelite.client.plugins.itemstats.ItemStatConfig;
import net.runelite.client.plugins.itemstats.Positivity;
import net.runelite.client.plugins.itemstats.StatChange;
import net.runelite.client.plugins.itemstats.StatsChanges;
import net.runelite.client.ui.JagexColors;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;
import net.runelite.client.util.ColorUtil;
import net.runelite.http.api.item.ItemEquipmentStats;
import net.runelite.http.api.item.ItemStats;

public class ItemStatOverlay
extends Overlay {
    private static final ItemStats UNARMED = new ItemStats(false, true, 0.0, ItemEquipmentStats.builder().aspeed(6).build());
    @Inject
    private Client client;
    @Inject
    private ItemManager itemManager;
    @Inject
    private TooltipManager tooltipManager;
    @Inject
    private ItemStatChanges statChanges;
    @Inject
    private ItemStatConfig config;

    @Override
    public Dimension render(Graphics2D graphics) {
        String tooltip;
        ItemStats stats;
        Effect change;
        Widget widgetItem;
        int child;
        if (this.client.isMenuOpen() || !this.config.relative() && !this.config.absolute() && !this.config.theoretical()) {
            return null;
        }
        MenuEntry[] menu = this.client.getMenuEntries();
        int menuSize = menu.length;
        if (menuSize <= 0) {
            return null;
        }
        MenuEntry entry = menu[menuSize - 1];
        int group = WidgetInfo.TO_GROUP(entry.getParam1());
        Widget widget = this.client.getWidget(group, child = WidgetInfo.TO_CHILD(entry.getParam1()));
        if (widget == null || group != WidgetInfo.INVENTORY.getGroupId() && group != WidgetInfo.EQUIPMENT.getGroupId() && group != WidgetInfo.EQUIPMENT_INVENTORY_ITEMS_CONTAINER.getGroupId()) {
            return null;
        }
        int itemId = entry.getIdentifier();
        if (group == WidgetInfo.EQUIPMENT.getGroupId()) {
            widgetItem = widget.getChild(1);
            if (widgetItem != null) {
                itemId = widgetItem.getItemId();
            }
        } else if (group == WidgetInfo.EQUIPMENT_INVENTORY_ITEMS_CONTAINER.getGroupId() && (widgetItem = widget.getChild(entry.getParam0())) != null) {
            itemId = widgetItem.getItemId();
        }
        if (this.config.consumableStats() && (change = this.statChanges.get(itemId)) != null) {
            StringBuilder b = new StringBuilder();
            StatsChanges statsChanges = change.calculate(this.client);
            for (StatChange c : statsChanges.getStatChanges()) {
                b.append(this.buildStatChangeString(c));
            }
            String tooltip2 = b.toString();
            if (!tooltip2.isEmpty()) {
                this.tooltipManager.add(new Tooltip(tooltip2));
            }
        }
        if (this.config.equipmentStats() && (stats = this.itemManager.getItemStats(itemId, false)) != null && !(tooltip = this.buildStatBonusString(stats)).isEmpty()) {
            this.tooltipManager.add(new Tooltip(tooltip));
        }
        return null;
    }

    private String getChangeString(String label, double value, boolean inverse, boolean showPercent) {
        Color plus = Positivity.getColor(this.config, Positivity.BETTER_UNCAPPED);
        Color minus = Positivity.getColor(this.config, Positivity.WORSE);
        if (value == 0.0) {
            return "";
        }
        Color color = inverse ? (value > 0.0 ? minus : plus) : (value > 0.0 ? plus : minus);
        String prefix = value > 0.0 ? "+" : "";
        String suffix = showPercent ? "%" : "";
        String valueString = (double)((int)value) == value ? String.valueOf((int)value) : String.valueOf(value);
        return label + ": " + ColorUtil.wrapWithColorTag(prefix + valueString + suffix, color) + "</br>";
    }

    private String buildStatBonusString(ItemStats s) {
        StringBuilder b = new StringBuilder();
        b.append(this.getChangeString("Weight", s.getWeight(), true, false));
        ItemStats other = null;
        ItemEquipmentStats currentEquipment = s.getEquipment();
        ItemContainer c = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (s.isEquipable() && currentEquipment != null && c != null) {
            Item item;
            Item[] items = c.getItems();
            int slot = currentEquipment.getSlot();
            if (slot != -1 && slot < items.length && (item = items[slot]) != null) {
                other = this.itemManager.getItemStats(item.getId(), false);
            }
            if (other == null && slot == EquipmentInventorySlot.WEAPON.getSlotIdx()) {
                other = UNARMED;
            }
        }
        ItemStats subtracted = s.subtract(other);
        ItemEquipmentStats e = subtracted.getEquipment();
        if (subtracted.isEquipable() && e != null) {
            b.append(this.getChangeString("Prayer", e.getPrayer(), false, false));
            b.append(this.getChangeString("Speed", e.getAspeed(), true, false));
            b.append(this.getChangeString("Melee Str", e.getStr(), false, false));
            b.append(this.getChangeString("Range Str", e.getRstr(), false, false));
            b.append(this.getChangeString("Magic Dmg", e.getMdmg(), false, true));
            if (e.getAstab() != 0 || e.getAslash() != 0 || e.getAcrush() != 0 || e.getAmagic() != 0 || e.getArange() != 0) {
                b.append(ColorUtil.wrapWithColorTag("Attack Bonus</br>", JagexColors.MENU_TARGET));
                b.append(this.getChangeString("Stab", e.getAstab(), false, false));
                b.append(this.getChangeString("Slash", e.getAslash(), false, false));
                b.append(this.getChangeString("Crush", e.getAcrush(), false, false));
                b.append(this.getChangeString("Magic", e.getAmagic(), false, false));
                b.append(this.getChangeString("Range", e.getArange(), false, false));
            }
            if (e.getDstab() != 0 || e.getDslash() != 0 || e.getDcrush() != 0 || e.getDmagic() != 0 || e.getDrange() != 0) {
                b.append(ColorUtil.wrapWithColorTag("Defence Bonus</br>", JagexColors.MENU_TARGET));
                b.append(this.getChangeString("Stab", e.getDstab(), false, false));
                b.append(this.getChangeString("Slash", e.getDslash(), false, false));
                b.append(this.getChangeString("Crush", e.getDcrush(), false, false));
                b.append(this.getChangeString("Magic", e.getDmagic(), false, false));
                b.append(this.getChangeString("Range", e.getDrange(), false, false));
            }
        }
        return b.toString();
    }

    private String buildStatChangeString(StatChange c) {
        StringBuilder b = new StringBuilder();
        b.append(ColorUtil.colorTag(Positivity.getColor(this.config, c.getPositivity())));
        if (this.config.relative()) {
            b.append(c.getFormattedRelative());
        }
        if (this.config.theoretical()) {
            if (this.config.relative()) {
                b.append("/");
            }
            b.append(c.getFormattedTheoretical());
        }
        if (this.config.absolute() && (this.config.relative() || this.config.theoretical())) {
            b.append(" (");
        }
        if (this.config.absolute()) {
            b.append(c.getAbsolute());
        }
        if (this.config.absolute() && (this.config.relative() || this.config.theoretical())) {
            b.append(")");
        }
        b.append(" ").append(c.getStat().getName());
        b.append("</br>");
        return b.toString();
    }
}

