/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.itemstats;

import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.runelite.client.plugins.itemstats.BoostedStatBoost;
import net.runelite.client.plugins.itemstats.Builders;
import net.runelite.client.plugins.itemstats.Effect;
import net.runelite.client.plugins.itemstats.food.Anglerfish;
import net.runelite.client.plugins.itemstats.potions.PrayerPotion;
import net.runelite.client.plugins.itemstats.potions.SaradominBrew;
import net.runelite.client.plugins.itemstats.potions.SuperRestore;
import net.runelite.client.plugins.itemstats.special.CastleWarsBandage;
import net.runelite.client.plugins.itemstats.special.SpicyStew;
import net.runelite.client.plugins.itemstats.stats.Stats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ItemStatChanges {
    private static final Logger log = LoggerFactory.getLogger(ItemStatChanges.class);
    private final Map<Integer, Effect> effects = new HashMap<Integer, Effect>();

    ItemStatChanges() {
        this.init();
    }

    private void init() {
        this.add(Builders.food(-5), 3146);
        this.add(Builders.food(1), 1942, 1957, 1965, 2130, 1871, 319);
        this.add(Builders.food(2), 1982, 1869, 1963, 3162, 2108, 2112, 2110, 2118, 2116, 7072, 1985, 1969, 2102, 2104, 2106, 2120, 2122, 2124, 2126);
        this.add(Builders.food(3), 315, 2142, 2140, 11324, 1973);
        this.add(Builders.food(4), 325, 1891, 1893, 1895, 1977, 6701, 403, 2955);
        this.add(Builders.food(5), 2309, 347, 1897, 1899, 1901, 3228, 7062, 7082, 7084, 2325, 2333, 11326);
        this.add(Builders.food(6), 6794, 355, 2327, 2331, 20871, 9980, 6965, 6963, 6961, 6962, 337);
        this.add(Builders.food(7), 333, 339, 2289, 2291, 2323, 2335, 7223, 2239, 2209, 2241, 2213);
        this.add(Builders.food(8), 351, 9988, 2293, 2295, 2237, 2205, 2243, 2217, 7064, 20860, 20873, 6883);
        this.add(Builders.food(9), 2036, 2048, 2034, 2084, 329, 2297, 2299);
        this.add(Builders.food(10), 361, 7521, 7086, 2878, 7934);
        this.add(Builders.food(11), 10136, 2003, 2301, 2303, 7530, 2227, 2281, 2219, 2253, 2221, 2255, 2223, 2259, 2225, 2277, 7066, 20875, 2149);
        this.add(Builders.food(12), 379, 2233, 2191, 2235, 2195);
        this.add(Builders.food(13), 365, 7068);
        this.add(Builders.food(14), 6703, 7054, 373, 20877, 1959, 1961);
        this.add(Builders.food(15), 2231, 2187, 2229, 2185, 7568);
        this.add(Builders.food(16), 7946, 6705, 7056);
        this.add(Builders.food(17), 20864, 20879);
        this.add(Builders.food(18), 3144);
        this.add(Builders.food(19), 2011, 1883, 1885);
        this.add(Builders.food(20), 7058, 385, 20866, 20881, 7579);
        this.add(Builders.food(21), 397);
        this.add(Builders.food(22), 391, 11936, 7060);
        this.add(Builders.food(23), 20868, 20883);
        this.add(new Anglerfish(), 13441);
        this.add(Builders.food(maxHP -> (int)Math.ceil((double)maxHP * 0.06)), 5504);
        this.add(Builders.food(maxHP -> (int)Math.ceil((double)maxHP * 0.05)), 5984);
        this.add(Builders.food(Builders.perc(0.1, 1)), 5988, 7088);
        this.add(Builders.combo(Builders.food(1), Builders.boost(Stats.DEFENCE, Builders.perc(0.02, 1))), 1967);
        this.add(Builders.combo(2, Builders.food(8), Builders.heal(Stats.RUN_ENERGY, 5)), 5972);
        this.add(Builders.range(Builders.food(5), Builders.food(7)), 3369);
        this.add(Builders.range(Builders.food(7), Builders.food(9)), 3373);
        this.add(Builders.food(2), 10964, 10963, 10969, 10965, 10962, 10961, 10960, 10966, 10968, 10967);
        this.add(Builders.food(3), 10970);
        this.add(Builders.range(Builders.food(3), Builders.food(6)), 5004);
        this.add(Builders.range(Builders.food(6), Builders.food(10)), 3381);
        this.add(Builders.range(Builders.food(8), Builders.food(12)), 5003);
        this.add(Builders.food(10), 10971);
        this.add(Builders.combo(Builders.food(11), Builders.dec(Stats.ATTACK, 2)), 1993);
        this.add(Builders.combo(Builders.food(14), Builders.dec(Stats.ATTACK, 3)), 7919);
        this.add(Builders.combo(2, Builders.food(5), Builders.boost(Stats.STRENGTH, 6), Builders.heal(Stats.ATTACK, -4)), 2040, 2054);
        this.add(Builders.combo(2, Builders.food(5), Builders.boost(Stats.STRENGTH, 4), Builders.heal(Stats.ATTACK, -3)), 2038, 2080);
        this.add(Builders.combo(2, Builders.food(5), Builders.boost(Stats.STRENGTH, 7), Builders.heal(Stats.ATTACK, -4)), 2032, 2092);
        this.add(Builders.combo(2, Builders.food(5), Builders.boost(Stats.STRENGTH, 7), Builders.heal(Stats.ATTACK, -4)), 2030, 2074);
        this.add(Builders.heal(Stats.RUN_ENERGY, 5), 10851);
        this.add(Builders.combo(Builders.heal(Stats.RUN_ENERGY, 10), Builders.boost(Stats.THIEVING, 1)), 10848);
        this.add(Builders.combo(Builders.heal(Stats.RUN_ENERGY, 15), Builders.boost(Stats.THIEVING, 2)), 10850);
        this.add(Builders.combo(Builders.heal(Stats.RUN_ENERGY, 20), Builders.boost(Stats.THIEVING, 3)), 10849);
        this.add(Builders.boost(Stats.ATTACK, Builders.perc(0.1, 3)), 125, 123, 121, 2428);
        this.add(Builders.boost(Stats.STRENGTH, Builders.perc(0.1, 3)), 119, 117, 115, 113);
        this.add(Builders.boost(Stats.DEFENCE, Builders.perc(0.1, 3)), 137, 135, 133, 2432);
        this.add(Builders.boost(Stats.MAGIC, 4), 3046, 3044, 3042, 3040);
        this.add(Builders.boost(Stats.RANGED, Builders.perc(0.1, 4)), 173, 171, 169, 2444);
        this.add(Builders.combo(2, Builders.boost(Stats.ATTACK, Builders.perc(0.1, 3)), Builders.boost(Stats.STRENGTH, Builders.perc(0.1, 3))), 9745, 9743, 9741, 9739);
        this.add(Builders.boost(Stats.ATTACK, Builders.perc(0.15, 5)), 149, 147, 145, 2436);
        this.add(Builders.boost(Stats.STRENGTH, Builders.perc(0.15, 5)), 161, 159, 157, 2440);
        this.add(Builders.boost(Stats.DEFENCE, Builders.perc(0.15, 5)), 167, 165, 163, 2442);
        this.add(Builders.boost(Stats.MAGIC, 3), 9024, 9023, 9022, 9021);
        this.add(Builders.combo(3, Builders.boost(Stats.ATTACK, Builders.perc(0.15, 5)), Builders.boost(Stats.STRENGTH, Builders.perc(0.15, 5)), Builders.boost(Stats.DEFENCE, Builders.perc(0.15, 5))), 12701, 12699, 12697, 12695);
        this.add(Builders.combo(3, Builders.boost(Stats.ATTACK, Builders.perc(0.2, 2)), Builders.boost(Stats.STRENGTH, Builders.perc(0.12, 2)), Builders.heal(Stats.PRAYER, Builders.perc(0.1, 0)), Builders.heal(Stats.DEFENCE, Builders.perc(0.1, -2)), new BoostedStatBoost(Stats.HITPOINTS, false, Builders.perc(-0.12, 0))), 193, 191, 189, 2450);
        this.add(new SaradominBrew(0.15, 0.2, 0.1, 2, 2), 6691, 6689, 6687, 6685);
        this.add(Builders.boost(Stats.RANGED, Builders.perc(0.15, 5)), 11725, 11724, 11723, 11722);
        this.add(Builders.boost(Stats.MAGIC, Builders.perc(0.15, 5)), 11729, 11728, 11727, 11726);
        this.add(Builders.combo(2, Builders.boost(Stats.RANGED, Builders.perc(0.1, 4)), Builders.boost(Stats.DEFENCE, Builders.perc(0.15, 5))), 22470, 22467, 22464, 22461);
        this.add(Builders.combo(2, Builders.boost(Stats.MAGIC, 4), Builders.boost(Stats.DEFENCE, Builders.perc(0.15, 5))), 22458, 22455, 22452, 22449);
        this.add(Builders.combo(5, Builders.boost(Stats.ATTACK, Builders.perc(0.15, 5)), Builders.boost(Stats.STRENGTH, Builders.perc(0.15, 5)), Builders.boost(Stats.DEFENCE, Builders.perc(0.15, 5)), Builders.boost(Stats.RANGED, Builders.perc(0.15, 5)), Builders.boost(Stats.MAGIC, Builders.perc(0.15, 5)), Builders.heal(Stats.HITPOINTS, -50)), 11733, 11732, 11731, 11730);
        this.add(new CastleWarsBandage(), 4049);
        this.add(Builders.combo(5, Builders.heal(Stats.ATTACK, Builders.perc(0.3, 10)), Builders.heal(Stats.STRENGTH, Builders.perc(0.3, 10)), Builders.heal(Stats.DEFENCE, Builders.perc(0.3, 10)), Builders.heal(Stats.RANGED, Builders.perc(0.3, 10)), Builders.heal(Stats.MAGIC, Builders.perc(0.3, 10))), 131, 129, 127, 2430);
        this.add(Builders.heal(Stats.RUN_ENERGY, 10), 3014, 3012, 3010, 3008);
        this.add(new PrayerPotion(7), 143, 141, 139, 2434);
        this.add(Builders.heal(Stats.RUN_ENERGY, 20), 3022, 3020, 3018, 3016);
        this.add(new SuperRestore(0.25, 8), 3030, 3028, 3026, 3024);
        this.add(new SuperRestore(0.25, 9), 10931, 10929, 10927, 10925);
        this.add(Builders.heal(Stats.RUN_ENERGY, 20), 12631, 12629, 12627, 12625);
        this.add(Builders.combo(5, Builders.boost(Stats.ATTACK, Builders.perc(0.16, 6)), Builders.boost(Stats.STRENGTH, Builders.perc(0.16, 6)), Builders.boost(Stats.DEFENCE, Builders.perc(0.16, 6)), Builders.boost(Stats.RANGED, Builders.perc(0.16, 6)), Builders.boost(Stats.MAGIC, Builders.perc(0.16, 6)), Builders.heal(Stats.HITPOINTS, -50)), 20993, 20994, 20995, 20996);
        this.add(Builders.combo(3, Builders.boost(Stats.ATTACK, Builders.perc(0.16, 6)), Builders.boost(Stats.STRENGTH, Builders.perc(0.16, 6)), Builders.boost(Stats.DEFENCE, Builders.perc(0.16, 6))), 20921, 20922, 20923, 20924);
        this.add(Builders.combo(2, Builders.boost(Stats.RANGED, Builders.perc(0.16, 6)), Builders.boost(Stats.DEFENCE, Builders.perc(0.16, 6))), 20933, 20934, 20935, 20936);
        this.add(Builders.combo(2, Builders.boost(Stats.MAGIC, Builders.perc(0.16, 6)), Builders.boost(Stats.DEFENCE, Builders.perc(0.16, 6))), 20945, 20946, 20947, 20948);
        this.add(new SuperRestore(0.3, 11), 20957, 20958, 20959, 20960);
        this.add(new SaradominBrew(0.15, 0.2, 0.1, 5, 4), 20981, 20982, 20983, 20984);
        this.add(Builders.combo(5, Builders.boost(Stats.ATTACK, Builders.perc(0.13, 5)), Builders.boost(Stats.STRENGTH, Builders.perc(0.13, 5)), Builders.boost(Stats.DEFENCE, Builders.perc(0.13, 5)), Builders.boost(Stats.RANGED, Builders.perc(0.13, 5)), Builders.boost(Stats.MAGIC, Builders.perc(0.13, 5)), Builders.heal(Stats.HITPOINTS, -50)), 20989, 20990, 20991, 20992);
        this.add(Builders.combo(3, Builders.boost(Stats.ATTACK, Builders.perc(0.13, 5)), Builders.boost(Stats.STRENGTH, Builders.perc(0.13, 5)), Builders.boost(Stats.DEFENCE, Builders.perc(0.13, 5))), 20917, 20918, 20919, 20920);
        this.add(Builders.combo(2, Builders.boost(Stats.RANGED, Builders.perc(0.13, 5)), Builders.boost(Stats.DEFENCE, Builders.perc(0.13, 5))), 20929, 20930, 20931, 20932);
        this.add(Builders.combo(2, Builders.boost(Stats.MAGIC, Builders.perc(0.13, 5)), Builders.boost(Stats.DEFENCE, Builders.perc(0.13, 5))), 20941, 20942, 20943, 20944);
        this.add(Builders.combo(5, Builders.boost(Stats.ATTACK, Builders.perc(0.1, 4)), Builders.boost(Stats.STRENGTH, Builders.perc(0.1, 4)), Builders.boost(Stats.DEFENCE, Builders.perc(0.1, 4)), Builders.boost(Stats.RANGED, Builders.perc(0.1, 4)), Builders.boost(Stats.MAGIC, Builders.perc(0.1, 4)), Builders.heal(Stats.HITPOINTS, -50)), 20985, 20986, 20987, 20988);
        this.add(Builders.combo(3, Builders.boost(Stats.ATTACK, Builders.perc(0.1, 4)), Builders.boost(Stats.STRENGTH, Builders.perc(0.1, 4)), Builders.boost(Stats.DEFENCE, Builders.perc(0.1, 4))), 20913, 20914, 20915, 20916);
        this.add(Builders.combo(3, Builders.boost(Stats.RANGED, Builders.perc(0.1, 4)), Builders.boost(Stats.DEFENCE, Builders.perc(0.1, 4))), 20925, 20926, 20927, 20928);
        this.add(Builders.combo(3, Builders.boost(Stats.MAGIC, Builders.perc(0.1, 4)), Builders.boost(Stats.DEFENCE, Builders.perc(0.1, 4))), 20937, 20938, 20939, 20940);
        this.add(Builders.boost(Stats.AGILITY, 3), 3038, 3036, 3034, 3032);
        this.add(Builders.boost(Stats.FISHING, 3), 155, 153, 151, 2438);
        this.add(Builders.boost(Stats.HUNTER, 3), 10004, 10002, 10000, 9998);
        this.add(Builders.combo(2, Builders.boost(Stats.HITPOINTS, 5), Builders.heal(Stats.RUN_ENERGY, 5)), 4423, 4421, 4419, 4417);
        this.add(Builders.heal(Stats.RUN_ENERGY, 10), 6469);
        this.add(Builders.heal(Stats.RUN_ENERGY, 30), 464);
        this.add(Builders.heal(Stats.RUN_ENERGY, 50), 9475);
        this.add(Builders.combo(Builders.food(12), Builders.heal(Stats.RUN_ENERGY, 50)), 6311);
        this.add(Builders.combo(2, Builders.heal(Stats.HITPOINTS, 6), Builders.boost(Stats.FARMING, 3)), 7178, 7180);
        this.add(Builders.combo(2, Builders.heal(Stats.HITPOINTS, 6), Builders.boost(Stats.FISHING, 3)), 7188, 7190);
        this.add(Builders.combo(2, Builders.heal(Stats.HITPOINTS, 7), Builders.boost(Stats.HERBLORE, 4)), 19662, 19659);
        this.add(Builders.combo(2, Builders.heal(Stats.HITPOINTS, 8), Builders.boost(Stats.CRAFTING, 4)), 21690, 21687);
        this.add(Builders.combo(2, Builders.heal(Stats.HITPOINTS, 8), Builders.boost(Stats.FISHING, 5)), 7198, 7200);
        this.add(Builders.combo(2, Builders.heal(Stats.HITPOINTS, 11), Builders.boost(Stats.SLAYER, 5), Builders.boost(Stats.RANGED, 4)), 7208, 7210);
        this.add(Builders.combo(2, Builders.heal(Stats.HITPOINTS, 11), Builders.boost(Stats.AGILITY, 5), Builders.heal(Stats.RUN_ENERGY, 10)), 7218, 7220);
        this.add(Builders.combo(Builders.range(Builders.food(1), Builders.food(3)), Builders.heal(Stats.RUN_ENERGY, 10)), 10476);
        this.add(new SpicyStew(), 7479);
        this.add(Builders.boost(Stats.MAGIC, Builders.perc(0.1, 1)), 20724);
        this.add(Builders.combo(Builders.boost(Stats.ATTACK, 2), Builders.boost(Stats.STRENGTH, 1), Builders.heal(Stats.DEFENCE, -1)), 247);
        log.debug("{} items; {} behaviours loaded", (Object)this.effects.size(), (Object)new HashSet<Effect>(this.effects.values()).size());
    }

    private void add(Effect effect, int ... items) {
        assert (items.length > 0);
        for (int item : items) {
            Effect prev = this.effects.put(item, effect);
            assert (prev == null) : "Item already added";
        }
    }

    public Effect get(int id) {
        return this.effects.get(id);
    }
}

