/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.itemprices;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.itemprices.ItemPricesConfig;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.StackFormatter;

class ItemPricesOverlay
extends Overlay {
    private static final float HIGH_ALCHEMY_CONSTANT = 0.6f;
    private static final int INVENTORY_ITEM_WIDGETID = WidgetInfo.INVENTORY.getPackedId();
    private static final int BANK_INVENTORY_ITEM_WIDGETID = WidgetInfo.BANK_INVENTORY_ITEMS_CONTAINER.getPackedId();
    private static final int BANK_ITEM_WIDGETID = WidgetInfo.BANK_ITEM_CONTAINER.getPackedId();
    private final Client client;
    private final ItemPricesConfig config;
    private final TooltipManager tooltipManager;
    private final StringBuilder itemStringBuilder = new StringBuilder();
    @Inject
    ItemManager itemManager;

    @Inject
    ItemPricesOverlay(Client client2, ItemPricesConfig config, TooltipManager tooltipManager) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.client = client2;
        this.config = config;
        this.tooltipManager = tooltipManager;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Dimension render(Graphics2D graphics) {
        if (this.client.isMenuOpen()) {
            return null;
        }
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        int last = menuEntries.length - 1;
        if (last < 0) {
            return null;
        }
        MenuEntry menuEntry = menuEntries[last];
        MenuAction action = MenuAction.of(menuEntry.getType());
        int widgetId = menuEntry.getParam1();
        int groupId = WidgetInfo.TO_GROUP(widgetId);
        switch (action) {
            case WIDGET_DEFAULT: 
            case ITEM_USE: 
            case ITEM_FIRST_OPTION: 
            case ITEM_SECOND_OPTION: 
            case ITEM_THIRD_OPTION: 
            case ITEM_FOURTH_OPTION: 
            case ITEM_FIFTH_OPTION: {
                switch (groupId) {
                    case 149: {
                        if (this.config.hideInventory()) {
                            return null;
                        }
                    }
                    case 12: 
                    case 15: {
                        String text = this.makeValueTooltip(menuEntry);
                        if (text == null) return null;
                        this.tooltipManager.add(new Tooltip(ColorUtil.prependColorTag(text, new Color(238, 238, 238))));
                    }
                }
                return null;
            }
        }
        return null;
    }

    private String makeValueTooltip(MenuEntry menuEntry) {
        if (!this.config.showGEPrice() && !this.config.showHAValue()) {
            return null;
        }
        int widgetId = menuEntry.getParam1();
        ItemContainer container = null;
        if (widgetId == INVENTORY_ITEM_WIDGETID || widgetId == BANK_INVENTORY_ITEM_WIDGETID) {
            container = this.client.getItemContainer(InventoryID.INVENTORY);
        } else if (widgetId == BANK_ITEM_WIDGETID) {
            container = this.client.getItemContainer(InventoryID.BANK);
        }
        if (container == null) {
            return null;
        }
        Item[] items = container.getItems();
        int index = menuEntry.getParam0();
        if (index < items.length) {
            Item item = items[index];
            return this.getItemStackValueText(item);
        }
        return null;
    }

    private String getItemStackValueText(Item item) {
        int id = item.getId();
        int qty = item.getQuantity();
        if (id == 995) {
            return StackFormatter.formatNumber(qty) + " gp";
        }
        if (id == 13204) {
            return StackFormatter.formatNumber(qty * 1000) + " gp";
        }
        ItemComposition itemDef = this.itemManager.getItemComposition(id);
        if (itemDef.getNote() != -1) {
            id = itemDef.getLinkedNoteId();
            itemDef = this.itemManager.getItemComposition(id);
        }
        if (itemDef.getPrice() <= 0) {
            return null;
        }
        int gePrice = 0;
        int haPrice = 0;
        int haProfit = 0;
        if (this.config.showGEPrice()) {
            gePrice = this.itemManager.getItemPrice(id);
        }
        if (this.config.showHAValue()) {
            haPrice = Math.round((float)itemDef.getPrice() * 0.6f);
        }
        if (gePrice > 0 && haPrice > 0 && this.config.showAlchProfit()) {
            haProfit = this.calculateHAProfit(haPrice, gePrice);
        }
        if (gePrice > 0 || haPrice > 0) {
            return this.stackValueText(qty, gePrice, haPrice, haProfit);
        }
        return null;
    }

    private String stackValueText(int qty, int gePrice, int haValue, int haProfit) {
        if (gePrice > 0) {
            this.itemStringBuilder.append("EX: ").append(StackFormatter.quantityToStackSize(gePrice * qty)).append(" gp");
            if (this.config.showEA() && qty > 1) {
                this.itemStringBuilder.append(" (").append(StackFormatter.quantityToStackSize(gePrice)).append(" ea)");
            }
        }
        if (haValue > 0) {
            if (gePrice > 0) {
                this.itemStringBuilder.append("</br>");
            }
            this.itemStringBuilder.append("HA: ").append(StackFormatter.quantityToStackSize(haValue * qty)).append(" gp");
            if (this.config.showEA() && qty > 1) {
                this.itemStringBuilder.append(" (").append(StackFormatter.quantityToStackSize(haValue)).append(" ea)");
            }
        }
        if (haProfit != 0) {
            Color haColor = ItemPricesOverlay.haProfitColor(haProfit);
            this.itemStringBuilder.append("</br>");
            this.itemStringBuilder.append("HA Profit: ").append(ColorUtil.wrapWithColorTag(String.valueOf(haProfit * qty), haColor)).append(" gp");
            if (this.config.showEA() && qty > 1) {
                this.itemStringBuilder.append(" (").append(ColorUtil.wrapWithColorTag(String.valueOf(haProfit), haColor)).append(" ea)");
            }
        }
        String text = this.itemStringBuilder.toString();
        this.itemStringBuilder.setLength(0);
        return text;
    }

    private int calculateHAProfit(int haPrice, int gePrice) {
        int natureRunePrice = this.itemManager.getItemPrice(561);
        return haPrice - gePrice - natureRunePrice;
    }

    private static Color haProfitColor(int haProfit) {
        return haProfit >= 0 ? Color.GREEN : Color.RED;
    }
}

