/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.itemidentification;

import com.google.inject.Inject;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.plugins.itemidentification.ItemIdentification;
import net.runelite.client.plugins.itemidentification.ItemIdentificationConfig;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.WidgetItemOverlay;
import net.runelite.client.ui.overlay.components.TextComponent;

class ItemIdentificationOverlay
extends WidgetItemOverlay {
    private final ItemIdentificationConfig config;

    @Inject
    ItemIdentificationOverlay(ItemIdentificationConfig config) {
        this.config = config;
        this.showOnInventory();
        this.showOnBank();
        this.showOnInterfaces(4, 464);
    }

    @Override
    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem itemWidget) {
        ItemIdentification iden = ItemIdentification.get(itemId);
        if (iden == null) {
            return;
        }
        switch (iden.type) {
            case SEED: {
                if (this.config.showSeeds()) break;
                return;
            }
            case HERB: {
                if (this.config.showHerbs()) break;
                return;
            }
            case SAPLING: {
                if (this.config.showSaplings()) break;
                return;
            }
            case TELEPORT_SCROLL: {
                if (this.config.showTeleportScrolls()) break;
                return;
            }
        }
        graphics.setFont(FontManager.getRunescapeSmallFont());
        this.renderText(graphics, itemWidget.getCanvasBounds(), iden);
    }

    private void renderText(Graphics2D graphics, Rectangle bounds, ItemIdentification iden) {
        TextComponent textComponent = new TextComponent();
        textComponent.setPosition(new Point(bounds.x, bounds.y + bounds.height));
        textComponent.setColor(this.config.textColor());
        switch (this.config.identificationType()) {
            case SHORT: {
                textComponent.setText(iden.shortName);
                break;
            }
            case MEDIUM: {
                textComponent.setText(iden.medName);
            }
        }
        textComponent.render(graphics);
    }
}

