/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.itemcharges;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.runelite.client.plugins.itemcharges.ItemChargeType;

enum ItemWithCharge {
    ABRACE1(ItemChargeType.ABYSSAL_BRACELET, 11103, 1),
    ABRACE2(ItemChargeType.ABYSSAL_BRACELET, 11101, 2),
    ABRACE3(ItemChargeType.ABYSSAL_BRACELET, 11099, 3),
    ABRACE4(ItemChargeType.ABYSSAL_BRACELET, 11097, 4),
    ABRACE5(ItemChargeType.ABYSSAL_BRACELET, 11095, 5),
    BELLOWS0(ItemChargeType.BELLOWS, 2871, 0),
    BELLOWS1(ItemChargeType.BELLOWS, 2874, 1),
    BELLOWS2(ItemChargeType.BELLOWS, 2873, 2),
    BELLOWS3(ItemChargeType.BELLOWS, 2872, 3),
    BURNING1(ItemChargeType.TELEPORT, 21175, 1),
    BURNING2(ItemChargeType.TELEPORT, 21173, 2),
    BURNING3(ItemChargeType.TELEPORT, 21171, 3),
    BURNING4(ItemChargeType.TELEPORT, 21169, 4),
    BURNING5(ItemChargeType.TELEPORT, 21166, 5),
    CBRACE1(ItemChargeType.TELEPORT, 11124, 1),
    CBRACE2(ItemChargeType.TELEPORT, 11122, 2),
    CBRACE3(ItemChargeType.TELEPORT, 11120, 3),
    CBRACE4(ItemChargeType.TELEPORT, 11118, 4),
    CBRACE5(ItemChargeType.TELEPORT, 11974, 5),
    CBRACE6(ItemChargeType.TELEPORT, 11972, 6),
    DIGSITE1(ItemChargeType.TELEPORT, 11190, 1),
    DIGSITE2(ItemChargeType.TELEPORT, 11191, 2),
    DIGSITE3(ItemChargeType.TELEPORT, 11192, 3),
    DIGSITE4(ItemChargeType.TELEPORT, 11193, 4),
    DIGSITE5(ItemChargeType.TELEPORT, 11194, 5),
    ELYRE1(ItemChargeType.TELEPORT, 3691, 1),
    ELYRE2(ItemChargeType.TELEPORT, 6125, 2),
    ELYRE3(ItemChargeType.TELEPORT, 6126, 3),
    ELYRE4(ItemChargeType.TELEPORT, 6127, 4),
    ELYRE5(ItemChargeType.TELEPORT, 13079, 5),
    FUNGICIDE0(ItemChargeType.FUNGICIDE_SPRAY, 7431, 0),
    FUNGICIDE1(ItemChargeType.FUNGICIDE_SPRAY, 7430, 1),
    FUNGICIDE2(ItemChargeType.FUNGICIDE_SPRAY, 7429, 2),
    FUNGICIDE3(ItemChargeType.FUNGICIDE_SPRAY, 7428, 3),
    FUNGICIDE4(ItemChargeType.FUNGICIDE_SPRAY, 7427, 4),
    FUNGICIDE5(ItemChargeType.FUNGICIDE_SPRAY, 7426, 5),
    FUNGICIDE6(ItemChargeType.FUNGICIDE_SPRAY, 7425, 6),
    FUNGICIDE7(ItemChargeType.FUNGICIDE_SPRAY, 7424, 7),
    FUNGICIDE8(ItemChargeType.FUNGICIDE_SPRAY, 7423, 8),
    FUNGICIDE9(ItemChargeType.FUNGICIDE_SPRAY, 7422, 9),
    FUNGICIDE10(ItemChargeType.FUNGICIDE_SPRAY, 7421, 10),
    GAMES1(ItemChargeType.TELEPORT, 3867, 1),
    GAMES2(ItemChargeType.TELEPORT, 3865, 2),
    GAMES3(ItemChargeType.TELEPORT, 3863, 3),
    GAMES4(ItemChargeType.TELEPORT, 3861, 4),
    GAMES5(ItemChargeType.TELEPORT, 3859, 5),
    GAMES6(ItemChargeType.TELEPORT, 3857, 6),
    GAMES7(ItemChargeType.TELEPORT, 3855, 7),
    GAMES8(ItemChargeType.TELEPORT, 3853, 8),
    GLORY1(ItemChargeType.TELEPORT, 1706, 1),
    GLORY2(ItemChargeType.TELEPORT, 1708, 2),
    GLORY3(ItemChargeType.TELEPORT, 1710, 3),
    GLORY4(ItemChargeType.TELEPORT, 1712, 4),
    GLORY5(ItemChargeType.TELEPORT, 11976, 5),
    GLORY6(ItemChargeType.TELEPORT, 11978, 6),
    GLORYT1(ItemChargeType.TELEPORT, 10360, 1),
    GLORYT2(ItemChargeType.TELEPORT, 10358, 2),
    GLORYT3(ItemChargeType.TELEPORT, 10356, 3),
    GLORYT4(ItemChargeType.TELEPORT, 10354, 4),
    GLORYT5(ItemChargeType.TELEPORT, 11966, 5),
    GLORYT6(ItemChargeType.TELEPORT, 11964, 6),
    IMP_IN_A_BOX1(ItemChargeType.IMPBOX, 10028, 1),
    IMP_IN_A_BOX2(ItemChargeType.IMPBOX, 10027, 2),
    PASSAGE1(ItemChargeType.TELEPORT, 21155, 1),
    PASSAGE2(ItemChargeType.TELEPORT, 21153, 2),
    PASSAGE3(ItemChargeType.TELEPORT, 21151, 3),
    PASSAGE4(ItemChargeType.TELEPORT, 21149, 4),
    PASSAGE5(ItemChargeType.TELEPORT, 21146, 5),
    PHARAO1(ItemChargeType.TELEPORT, 9048, 1),
    PHARAO2(ItemChargeType.TELEPORT, 9046, 2),
    PHARAO3(ItemChargeType.TELEPORT, 9044, 3),
    PHARAO4(ItemChargeType.TELEPORT, 13078, 4),
    PHARAO5(ItemChargeType.TELEPORT, 13077, 5),
    PHARAO6(ItemChargeType.TELEPORT, 13076, 6),
    PHARAO7(ItemChargeType.TELEPORT, 13075, 7),
    PHARAO8(ItemChargeType.TELEPORT, 13074, 8),
    RETURNING1(ItemChargeType.TELEPORT, 21138, 1),
    RETURNING2(ItemChargeType.TELEPORT, 21136, 2),
    RETURNING3(ItemChargeType.TELEPORT, 21134, 3),
    RETURNING4(ItemChargeType.TELEPORT, 21132, 4),
    RETURNING5(ItemChargeType.TELEPORT, 21129, 5),
    ROD1(ItemChargeType.TELEPORT, 2566, 1),
    ROD2(ItemChargeType.TELEPORT, 2564, 2),
    ROD3(ItemChargeType.TELEPORT, 2562, 3),
    ROD4(ItemChargeType.TELEPORT, 2560, 4),
    ROD5(ItemChargeType.TELEPORT, 2558, 5),
    ROD6(ItemChargeType.TELEPORT, 2556, 6),
    ROD7(ItemChargeType.TELEPORT, 2554, 7),
    ROD8(ItemChargeType.TELEPORT, 2552, 8),
    ROS1(ItemChargeType.TELEPORT, 11873, 1),
    ROS2(ItemChargeType.TELEPORT, 11872, 2),
    ROS3(ItemChargeType.TELEPORT, 11871, 3),
    ROS4(ItemChargeType.TELEPORT, 11870, 4),
    ROS5(ItemChargeType.TELEPORT, 11869, 5),
    ROS6(ItemChargeType.TELEPORT, 11868, 6),
    ROS7(ItemChargeType.TELEPORT, 11867, 7),
    ROS8(ItemChargeType.TELEPORT, 11866, 8),
    ROW1(ItemChargeType.TELEPORT, 11988, 1),
    ROW2(ItemChargeType.TELEPORT, 11986, 2),
    ROW3(ItemChargeType.TELEPORT, 11984, 3),
    ROW4(ItemChargeType.TELEPORT, 11982, 4),
    ROW5(ItemChargeType.TELEPORT, 11980, 5),
    SKILLS1(ItemChargeType.TELEPORT, 11111, 1),
    SKILLS2(ItemChargeType.TELEPORT, 11109, 2),
    SKILLS3(ItemChargeType.TELEPORT, 11107, 3),
    SKILLS4(ItemChargeType.TELEPORT, 11105, 4),
    SKILLS5(ItemChargeType.TELEPORT, 11970, 5),
    SKILLS6(ItemChargeType.TELEPORT, 11968, 6),
    TCRYSTAL1(ItemChargeType.TELEPORT, 6102, 1),
    TCRYSTAL2(ItemChargeType.TELEPORT, 6101, 2),
    TCRYSTAL3(ItemChargeType.TELEPORT, 6100, 3),
    TCRYSTAL4(ItemChargeType.TELEPORT, 6099, 4),
    TCRYSTAL5(ItemChargeType.TELEPORT, 13102, 5),
    WCAN0(ItemChargeType.WATERCAN, 5331, 0),
    WCAN1(ItemChargeType.WATERCAN, 5333, 1),
    WCAN2(ItemChargeType.WATERCAN, 5334, 2),
    WCAN3(ItemChargeType.WATERCAN, 5335, 3),
    WCAN4(ItemChargeType.WATERCAN, 5336, 4),
    WCAN5(ItemChargeType.WATERCAN, 5337, 5),
    WCAN6(ItemChargeType.WATERCAN, 5338, 6),
    WCAN7(ItemChargeType.WATERCAN, 5339, 7),
    WCAN8(ItemChargeType.WATERCAN, 5340, 8),
    WSKIN0(ItemChargeType.WATERSKIN, 1831, 0),
    WSKIN1(ItemChargeType.WATERSKIN, 1829, 1),
    WSKIN2(ItemChargeType.WATERSKIN, 1827, 2),
    WSKIN3(ItemChargeType.WATERSKIN, 1825, 3),
    WSKIN4(ItemChargeType.WATERSKIN, 1823, 4);

    private final ItemChargeType type;
    private final int id;
    private final int charges;
    private static final Map<Integer, ItemWithCharge> ID_MAP;

    @Nullable
    static ItemWithCharge findItem(int itemId) {
        return ID_MAP.get(itemId);
    }

    private ItemWithCharge(ItemChargeType type, int id, int charges) {
        this.type = type;
        this.id = id;
        this.charges = charges;
    }

    public ItemChargeType getType() {
        return this.type;
    }

    public int getId() {
        return this.id;
    }

    public int getCharges() {
        return this.charges;
    }

    static {
        ID_MAP = new HashMap<Integer, ItemWithCharge>();
        for (ItemWithCharge itemCharge : ItemWithCharge.values()) {
            ID_MAP.put(itemCharge.getId(), itemCharge);
        }
    }
}

