/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.itemcharges;

import com.google.inject.Provides;
import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ConfigChanged;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.AsyncBufferedImage;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.itemcharges.ItemChargeConfig;
import net.runelite.client.plugins.itemcharges.ItemChargeInfobox;
import net.runelite.client.plugins.itemcharges.ItemChargeOverlay;
import net.runelite.client.plugins.itemcharges.ItemWithCharge;
import net.runelite.client.plugins.itemcharges.ItemWithSlot;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;

@PluginDescriptor(name="Item Charges", description="Show number of item charges remaining", tags={"inventory", "notifications", "overlay"})
public class ItemChargePlugin
extends Plugin {
    private static final Pattern DODGY_CHECK_PATTERN = Pattern.compile("Your dodgy necklace has (\\d+) charges? left\\.");
    private static final Pattern DODGY_PROTECT_PATTERN = Pattern.compile("Your dodgy necklace protects you\\..*It has (\\d+) charges? left\\.");
    private static final Pattern DODGY_BREAK_PATTERN = Pattern.compile("Your dodgy necklace protects you\\..*It then crumbles to dust\\.");
    private static final String RING_OF_RECOIL_BREAK_MESSAGE = "<col=7f007f>Your Ring of Recoil has shattered.</col>";
    private static final Pattern BINDING_CHECK_PATTERN = Pattern.compile("You have ([0-9]+|one) charges? left before your Binding necklace disintegrates\\.");
    private static final Pattern BINDING_USED_PATTERN = Pattern.compile("You bind the temple's power into (mud|lava|steam|dust|smoke|mist) runes\\.");
    private static final String BINDING_BREAK_TEXT = "Your Binding necklace has disintegrated.";
    private static final int MAX_DODGY_CHARGES = 10;
    private static final int MAX_BINDING_CHARGES = 16;
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ItemChargeOverlay overlay;
    @Inject
    private ItemManager itemManager;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private Notifier notifier;
    @Inject
    private ItemChargeConfig config;
    private int lastCheckTick;

    @Provides
    ItemChargeConfig getConfig(ConfigManager configManager) {
        return configManager.getConfig(ItemChargeConfig.class);
    }

    @Override
    protected void startUp() {
        this.overlayManager.add(this.overlay);
    }

    @Override
    protected void shutDown() throws Exception {
        this.overlayManager.remove(this.overlay);
        this.infoBoxManager.removeIf(ItemChargeInfobox.class::isInstance);
        this.lastCheckTick = -1;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("itemCharge")) {
            return;
        }
        if (!this.config.showInfoboxes()) {
            this.infoBoxManager.removeIf(ItemChargeInfobox.class::isInstance);
            return;
        }
        if (!this.config.showTeleportCharges()) {
            this.removeInfobox(ItemWithSlot.TELEPORT);
        }
        if (!this.config.showAbyssalBraceletCharges()) {
            this.removeInfobox(ItemWithSlot.ABYSSAL_BRACELET);
        }
        if (!this.config.showDodgyCount()) {
            this.removeInfobox(ItemWithSlot.DODGY_NECKLACE);
        }
        if (!this.config.showBindingNecklaceCharges()) {
            this.removeInfobox(ItemWithSlot.BINDING_NECKLACE);
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        String message = event.getMessage();
        Matcher dodgyCheckMatcher = DODGY_CHECK_PATTERN.matcher(message);
        Matcher dodgyProtectMatcher = DODGY_PROTECT_PATTERN.matcher(message);
        Matcher dodgyBreakMatcher = DODGY_BREAK_PATTERN.matcher(message);
        Matcher bindingNecklaceCheckMatcher = BINDING_CHECK_PATTERN.matcher(event.getMessage());
        Matcher bindingNecklaceUsedMatcher = BINDING_USED_PATTERN.matcher(event.getMessage());
        if (event.getType() == ChatMessageType.GAMEMESSAGE || event.getType() == ChatMessageType.SPAM) {
            if (this.config.recoilNotification() && message.contains(RING_OF_RECOIL_BREAK_MESSAGE)) {
                this.notifier.notify("Your Ring of Recoil has shattered");
            } else if (dodgyBreakMatcher.find()) {
                if (this.config.dodgyNotification()) {
                    this.notifier.notify("Your dodgy necklace has crumbled to dust.");
                }
                this.updateDodgyNecklaceCharges(10);
            } else if (dodgyCheckMatcher.find()) {
                this.updateDodgyNecklaceCharges(Integer.parseInt(dodgyCheckMatcher.group(1)));
            } else if (dodgyProtectMatcher.find()) {
                this.updateDodgyNecklaceCharges(Integer.parseInt(dodgyProtectMatcher.group(1)));
            } else if (message.contains(BINDING_BREAK_TEXT)) {
                if (this.config.bindingNotification()) {
                    this.notifier.notify(BINDING_BREAK_TEXT);
                }
                this.updateBindingNecklaceCharges(17);
            } else if (bindingNecklaceUsedMatcher.find()) {
                this.updateBindingNecklaceCharges(this.config.bindingNecklace() - 1);
            } else if (bindingNecklaceCheckMatcher.find()) {
                String match = bindingNecklaceCheckMatcher.group(1);
                int charges = 1;
                if (!match.equals("one")) {
                    charges = Integer.parseInt(match);
                }
                this.updateBindingNecklaceCharges(charges);
            }
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getItemContainer() != this.client.getItemContainer(InventoryID.EQUIPMENT) || !this.config.showInfoboxes()) {
            return;
        }
        Item[] items = event.getItemContainer().getItems();
        if (this.config.showTeleportCharges()) {
            this.updateJewelleryInfobox(ItemWithSlot.TELEPORT, items);
        }
        if (this.config.showDodgyCount()) {
            this.updateJewelleryInfobox(ItemWithSlot.DODGY_NECKLACE, items);
        }
        if (this.config.showAbyssalBraceletCharges()) {
            this.updateJewelleryInfobox(ItemWithSlot.ABYSSAL_BRACELET, items);
        }
        if (this.config.showBindingNecklaceCharges()) {
            this.updateJewelleryInfobox(ItemWithSlot.BINDING_NECKLACE, items);
        }
    }

    @Subscribe
    private void onScriptCallbackEvent(ScriptCallbackEvent event) {
        if (!"destroyOnOpKey".equals(event.getEventName())) {
            return;
        }
        int yesOption = this.client.getIntStack()[this.client.getIntStackSize() - 1];
        if (yesOption == 1) {
            this.checkDestroyWidget();
        }
    }

    private void updateDodgyNecklaceCharges(int value) {
        this.config.dodgyNecklace(value);
        if (this.config.showInfoboxes() && this.config.showDodgyCount()) {
            ItemContainer itemContainer = this.client.getItemContainer(InventoryID.EQUIPMENT);
            if (itemContainer == null) {
                return;
            }
            this.updateJewelleryInfobox(ItemWithSlot.DODGY_NECKLACE, itemContainer.getItems());
        }
    }

    private void updateBindingNecklaceCharges(int value) {
        this.config.bindingNecklace(value);
        if (this.config.showInfoboxes() && this.config.showBindingNecklaceCharges()) {
            ItemContainer itemContainer = this.client.getItemContainer(InventoryID.EQUIPMENT);
            if (itemContainer == null) {
                return;
            }
            this.updateJewelleryInfobox(ItemWithSlot.BINDING_NECKLACE, itemContainer.getItems());
        }
    }

    private void checkDestroyWidget() {
        int currentTick = this.client.getTickCount();
        if (this.lastCheckTick == currentTick) {
            return;
        }
        this.lastCheckTick = currentTick;
        Widget widgetDestroyItemName = this.client.getWidget(WidgetInfo.DESTROY_ITEM_NAME);
        if (widgetDestroyItemName == null) {
            return;
        }
        switch (widgetDestroyItemName.getText()) {
            case "Binding necklace": {
                this.updateBindingNecklaceCharges(16);
                break;
            }
            case "Dodgy necklace": {
                this.updateDodgyNecklaceCharges(10);
            }
        }
    }

    private void updateJewelleryInfobox(ItemWithSlot item, Item[] items) {
        for (EquipmentInventorySlot equipmentInventorySlot : item.getSlots()) {
            this.updateJewelleryInfobox(item, items, equipmentInventorySlot);
        }
    }

    private void updateJewelleryInfobox(ItemWithSlot type, Item[] items, EquipmentInventorySlot slot) {
        this.removeInfobox(type, slot);
        if (slot.getSlotIdx() >= items.length) {
            return;
        }
        int id = items[slot.getSlotIdx()].getId();
        if (id < 0) {
            return;
        }
        ItemWithCharge itemWithCharge = ItemWithCharge.findItem(id);
        int charges = -1;
        if (itemWithCharge == null) {
            if (id == 21143 && type == ItemWithSlot.DODGY_NECKLACE) {
                charges = this.config.dodgyNecklace();
            } else if (id == 5521 && type == ItemWithSlot.BINDING_NECKLACE) {
                charges = this.config.bindingNecklace();
            }
        } else if (itemWithCharge.getType() == type.getType()) {
            charges = itemWithCharge.getCharges();
        }
        if (charges <= 0) {
            return;
        }
        String name = this.itemManager.getItemComposition(id).getName();
        AsyncBufferedImage image = this.itemManager.getImage(id);
        ItemChargeInfobox infobox = new ItemChargeInfobox(this, image, name, charges, type, slot);
        this.infoBoxManager.addInfoBox(infobox);
    }

    private void removeInfobox(ItemWithSlot item) {
        this.infoBoxManager.removeIf(t -> t instanceof ItemChargeInfobox && ((ItemChargeInfobox)t).getItem() == item);
    }

    private void removeInfobox(ItemWithSlot item, EquipmentInventorySlot slot) {
        this.infoBoxManager.removeIf(t -> {
            if (!(t instanceof ItemChargeInfobox)) {
                return false;
            }
            ItemChargeInfobox i = (ItemChargeInfobox)t;
            return i.getItem() == item && i.getSlot() == slot;
        });
    }

    Color getColor(int charges) {
        Color color = Color.WHITE;
        if (charges <= this.config.veryLowWarning()) {
            color = this.config.veryLowWarningColor();
        } else if (charges <= this.config.lowWarning()) {
            color = this.config.lowWarningolor();
        }
        return color;
    }
}

