/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.itemcharges;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import javax.inject.Inject;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.plugins.itemcharges.ItemChargeConfig;
import net.runelite.client.plugins.itemcharges.ItemChargePlugin;
import net.runelite.client.plugins.itemcharges.ItemChargeType;
import net.runelite.client.plugins.itemcharges.ItemWithCharge;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.WidgetItemOverlay;
import net.runelite.client.ui.overlay.components.TextComponent;

class ItemChargeOverlay
extends WidgetItemOverlay {
    private final ItemChargePlugin itemChargePlugin;
    private final ItemChargeConfig config;

    @Inject
    ItemChargeOverlay(ItemChargePlugin itemChargePlugin, ItemChargeConfig config) {
        this.itemChargePlugin = itemChargePlugin;
        this.config = config;
        this.showOnInventory();
        this.showOnEquipment();
    }

    @Override
    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem itemWidget) {
        int charges;
        if (!this.displayOverlay()) {
            return;
        }
        graphics.setFont(FontManager.getRunescapeSmallFont());
        if (itemId == 21143) {
            if (!this.config.showDodgyCount()) {
                return;
            }
            charges = this.config.dodgyNecklace();
        } else if (itemId == 5521) {
            if (!this.config.showBindingNecklaceCharges()) {
                return;
            }
            charges = this.config.bindingNecklace();
        } else {
            ItemWithCharge chargeItem = ItemWithCharge.findItem(itemId);
            if (chargeItem == null) {
                return;
            }
            ItemChargeType type = chargeItem.getType();
            if (type == ItemChargeType.TELEPORT && !this.config.showTeleportCharges() || type == ItemChargeType.FUNGICIDE_SPRAY && !this.config.showFungicideCharges() || type == ItemChargeType.IMPBOX && !this.config.showImpCharges() || type == ItemChargeType.WATERCAN && !this.config.showWateringCanCharges() || type == ItemChargeType.WATERSKIN && !this.config.showWaterskinCharges() || type == ItemChargeType.BELLOWS && !this.config.showBellowCharges() || type == ItemChargeType.ABYSSAL_BRACELET && !this.config.showAbyssalBraceletCharges()) {
                return;
            }
            charges = chargeItem.getCharges();
        }
        Rectangle bounds = itemWidget.getCanvasBounds();
        TextComponent textComponent = new TextComponent();
        textComponent.setPosition(new Point(bounds.x, bounds.y + 16));
        textComponent.setText(charges < 0 ? "?" : String.valueOf(charges));
        textComponent.setColor(this.itemChargePlugin.getColor(charges));
        textComponent.render(graphics);
    }

    private boolean displayOverlay() {
        return this.config.showTeleportCharges() || this.config.showDodgyCount() || this.config.showFungicideCharges() || this.config.showImpCharges() || this.config.showWateringCanCharges() || this.config.showWaterskinCharges() || this.config.showBellowCharges() || this.config.showAbyssalBraceletCharges();
    }
}

