/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.inventoryviewer;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemContainer;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.ImageComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;

class InventoryViewerOverlay
extends Overlay {
    private static final int INVENTORY_SIZE = 28;
    private static final int PLACEHOLDER_WIDTH = 36;
    private static final int PLACEHOLDER_HEIGHT = 32;
    private static final ImageComponent PLACEHOLDER_IMAGE = new ImageComponent(new BufferedImage(36, 32, 6));
    private final Client client;
    private final ItemManager itemManager;
    private final PanelComponent panelComponent = new PanelComponent();

    @Inject
    private InventoryViewerOverlay(Client client2, ItemManager itemManager) {
        this.setPosition(OverlayPosition.BOTTOM_RIGHT);
        this.panelComponent.setWrapping(4);
        this.panelComponent.setGap(new Point(6, 4));
        this.panelComponent.setOrientation(PanelComponent.Orientation.HORIZONTAL);
        this.itemManager = itemManager;
        this.client = client2;
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        ItemContainer itemContainer = this.client.getItemContainer(InventoryID.INVENTORY);
        if (itemContainer == null) {
            return null;
        }
        this.panelComponent.getChildren().clear();
        Item[] items = itemContainer.getItems();
        for (int i = 0; i < 28; ++i) {
            BufferedImage image;
            Item item;
            if (i < items.length && (item = items[i]).getQuantity() > 0 && (image = this.getImage(item)) != null) {
                this.panelComponent.getChildren().add(new ImageComponent(image));
                continue;
            }
            this.panelComponent.getChildren().add(PLACEHOLDER_IMAGE);
        }
        return this.panelComponent.render(graphics);
    }

    private BufferedImage getImage(Item item) {
        ItemComposition itemComposition = this.itemManager.getItemComposition(item.getId());
        return this.itemManager.getImage(item.getId(), item.getQuantity(), itemComposition.isStackable());
    }
}

