/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.inventorytags;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.inject.Provides;
import java.awt.Color;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.MenuOpened;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.WidgetMenuOptionClicked;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.menus.MenuManager;
import net.runelite.client.menus.WidgetMenuOption;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.inventorytags.InventoryTagsConfig;
import net.runelite.client.plugins.inventorytags.InventoryTagsOverlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.Text;

@PluginDescriptor(name="Inventory Tags", description="Add the ability to tag items in your inventory", tags={"highlight", "items", "overlay", "tagging"}, enabledByDefault=false)
public class InventoryTagsPlugin
extends Plugin {
    private static final String ITEM_KEY_PREFIX = "item_";
    private static final String SETNAME_GROUP_1 = "Group 1";
    private static final String SETNAME_GROUP_2 = "Group 2";
    private static final String SETNAME_GROUP_3 = "Group 3";
    private static final String SETNAME_GROUP_4 = "Group 4";
    private static final String CONFIGURE = "Configure";
    private static final String SAVE = "Save";
    private static final String MENU_TARGET = "Inventory Tags";
    private static final String MENU_SET = "Mark";
    private static final String MENU_REMOVE = "Remove";
    private static final WidgetMenuOption FIXED_INVENTORY_TAB_CONFIGURE = new WidgetMenuOption("Configure", "Inventory Tags", WidgetInfo.FIXED_VIEWPORT_INVENTORY_TAB);
    private static final WidgetMenuOption FIXED_INVENTORY_TAB_SAVE = new WidgetMenuOption("Save", "Inventory Tags", WidgetInfo.FIXED_VIEWPORT_INVENTORY_TAB);
    private static final WidgetMenuOption RESIZABLE_INVENTORY_TAB_CONFIGURE = new WidgetMenuOption("Configure", "Inventory Tags", WidgetInfo.RESIZABLE_VIEWPORT_INVENTORY_TAB);
    private static final WidgetMenuOption RESIZABLE_INVENTORY_TAB_SAVE = new WidgetMenuOption("Save", "Inventory Tags", WidgetInfo.RESIZABLE_VIEWPORT_INVENTORY_TAB);
    private static final WidgetMenuOption RESIZABLE_BOTTOM_LINE_INVENTORY_TAB_CONFIGURE = new WidgetMenuOption("Configure", "Inventory Tags", WidgetInfo.RESIZABLE_VIEWPORT_BOTTOM_LINE_INVENTORY_TAB);
    private static final WidgetMenuOption RESIZABLE_BOTTOM_LINE_INVENTORY_TAB_SAVE = new WidgetMenuOption("Save", "Inventory Tags", WidgetInfo.RESIZABLE_VIEWPORT_BOTTOM_LINE_INVENTORY_TAB);
    private static final List<String> GROUPS = ImmutableList.of("Group 4", "Group 3", "Group 2", "Group 1");
    @Inject
    private Client client;
    @Inject
    private ConfigManager configManager;
    @Inject
    private InventoryTagsConfig config;
    @Inject
    private MenuManager menuManager;
    @Inject
    private InventoryTagsOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    private boolean editorMode;

    @Provides
    InventoryTagsConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(InventoryTagsConfig.class);
    }

    String getTag(int itemId) {
        String tag = this.configManager.getConfiguration("inventorytags", ITEM_KEY_PREFIX + itemId);
        if (tag == null || tag.isEmpty()) {
            return null;
        }
        return tag;
    }

    private void setTag(int itemId, String tag) {
        this.configManager.setConfiguration("inventorytags", ITEM_KEY_PREFIX + itemId, tag);
    }

    private void unsetTag(int itemId) {
        this.configManager.unsetConfiguration("inventorytags", ITEM_KEY_PREFIX + itemId);
    }

    @Override
    protected void startUp() throws Exception {
        this.refreshInventoryMenuOptions();
        this.overlayManager.add(this.overlay);
    }

    @Override
    protected void shutDown() throws Exception {
        this.removeInventoryMenuOptions();
        this.overlayManager.remove(this.overlay);
        this.editorMode = false;
    }

    @Subscribe
    public void onWidgetMenuOptionClicked(WidgetMenuOptionClicked event) {
        if (event.getWidget() == WidgetInfo.FIXED_VIEWPORT_INVENTORY_TAB || event.getWidget() == WidgetInfo.RESIZABLE_VIEWPORT_INVENTORY_TAB || event.getWidget() == WidgetInfo.RESIZABLE_VIEWPORT_BOTTOM_LINE_INVENTORY_TAB) {
            this.editorMode = event.getMenuOption().equals(CONFIGURE) && Text.removeTags(event.getMenuTarget()).equals(MENU_TARGET);
            this.refreshInventoryMenuOptions();
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (event.getMenuAction() != MenuAction.RUNELITE) {
            return;
        }
        String selectedMenu = Text.removeTags(event.getMenuTarget());
        if (event.getMenuOption().equals(MENU_SET)) {
            this.setTag(event.getId(), selectedMenu);
        } else if (event.getMenuOption().equals(MENU_REMOVE)) {
            this.unsetTag(event.getId());
        }
    }

    @Subscribe
    public void onMenuOpened(MenuOpened event) {
        MenuEntry firstEntry = event.getFirstEntry();
        if (firstEntry == null) {
            return;
        }
        int widgetId = firstEntry.getParam1();
        if (widgetId == WidgetInfo.INVENTORY.getId() && this.editorMode) {
            int itemId = firstEntry.getIdentifier();
            if (itemId == -1) {
                return;
            }
            MenuEntry[] menuList = new MenuEntry[GROUPS.size() + 1];
            int num = 0;
            menuList[num++] = event.getMenuEntries()[0];
            for (String groupName : GROUPS) {
                String group = this.getTag(itemId);
                MenuEntry newMenu = new MenuEntry();
                Color color = this.getGroupNameColor(groupName);
                newMenu.setOption(groupName.equals(group) ? MENU_REMOVE : MENU_SET);
                newMenu.setTarget(ColorUtil.prependColorTag(groupName, MoreObjects.firstNonNull(color, Color.WHITE)));
                newMenu.setIdentifier(itemId);
                newMenu.setParam1(widgetId);
                newMenu.setType(MenuAction.RUNELITE.getId());
                menuList[num++] = newMenu;
            }
            this.client.setMenuEntries(menuList);
        }
    }

    Color getGroupNameColor(String name) {
        switch (name) {
            case "Group 1": {
                return this.config.getGroup1Color();
            }
            case "Group 2": {
                return this.config.getGroup2Color();
            }
            case "Group 3": {
                return this.config.getGroup3Color();
            }
            case "Group 4": {
                return this.config.getGroup4Color();
            }
        }
        return null;
    }

    private void removeInventoryMenuOptions() {
        this.menuManager.removeManagedCustomMenu(FIXED_INVENTORY_TAB_CONFIGURE);
        this.menuManager.removeManagedCustomMenu(FIXED_INVENTORY_TAB_SAVE);
        this.menuManager.removeManagedCustomMenu(RESIZABLE_INVENTORY_TAB_CONFIGURE);
        this.menuManager.removeManagedCustomMenu(RESIZABLE_INVENTORY_TAB_SAVE);
        this.menuManager.removeManagedCustomMenu(RESIZABLE_BOTTOM_LINE_INVENTORY_TAB_CONFIGURE);
        this.menuManager.removeManagedCustomMenu(RESIZABLE_BOTTOM_LINE_INVENTORY_TAB_SAVE);
    }

    private void refreshInventoryMenuOptions() {
        this.removeInventoryMenuOptions();
        if (this.editorMode) {
            this.menuManager.addManagedCustomMenu(FIXED_INVENTORY_TAB_SAVE);
            this.menuManager.addManagedCustomMenu(RESIZABLE_INVENTORY_TAB_SAVE);
            this.menuManager.addManagedCustomMenu(RESIZABLE_BOTTOM_LINE_INVENTORY_TAB_SAVE);
        } else {
            this.menuManager.addManagedCustomMenu(FIXED_INVENTORY_TAB_CONFIGURE);
            this.menuManager.addManagedCustomMenu(RESIZABLE_INVENTORY_TAB_CONFIGURE);
            this.menuManager.addManagedCustomMenu(RESIZABLE_BOTTOM_LINE_INVENTORY_TAB_CONFIGURE);
        }
    }
}

