/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.inventorytags;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.inventorytags.InventoryTagsPlugin;
import net.runelite.client.ui.overlay.WidgetItemOverlay;

public class InventoryTagsOverlay
extends WidgetItemOverlay {
    private final ItemManager itemManager;
    private final InventoryTagsPlugin plugin;

    @Inject
    private InventoryTagsOverlay(ItemManager itemManager, InventoryTagsPlugin plugin) {
        this.itemManager = itemManager;
        this.plugin = plugin;
        this.showOnEquipment();
        this.showOnInventory();
    }

    @Override
    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem itemWidget) {
        Color color;
        String group = this.plugin.getTag(itemId);
        if (group != null && (color = this.plugin.getGroupNameColor(group)) != null) {
            Rectangle bounds = itemWidget.getCanvasBounds();
            BufferedImage outline = this.itemManager.getItemOutline(itemId, itemWidget.getQuantity(), color);
            graphics.drawImage((Image)outline, (int)bounds.getX() + 1, (int)bounds.getY() + 1, null);
        }
    }
}

