/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.inventorysetups.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import net.runelite.api.InventoryID;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.inventorysetups.InventorySetup;
import net.runelite.client.plugins.inventorysetups.InventorySetupItem;
import net.runelite.client.plugins.inventorysetups.InventorySetupPlugin;
import net.runelite.client.plugins.inventorysetups.ui.InventorySetupEquipmentPanel;
import net.runelite.client.plugins.inventorysetups.ui.InventorySetupInventoryPanel;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.PluginErrorPanel;
import net.runelite.client.util.ImageUtil;

public class InventorySetupPluginPanel
extends PluginPanel {
    private static ImageIcon ADD_ICON;
    private static ImageIcon ADD_HOVER_ICON;
    private static ImageIcon REMOVE_ICON;
    private static ImageIcon REMOVE_HOVER_ICON;
    private final JPanel noSetupsPanel;
    private final JPanel invEqPanel;
    private final InventorySetupInventoryPanel invPanel;
    private final InventorySetupEquipmentPanel eqpPanel;
    private final JComboBox<String> setupComboBox;
    private final JLabel removeMarker;
    private final InventorySetupPlugin plugin;

    public InventorySetupPluginPanel(final InventorySetupPlugin plugin, ItemManager itemManager) {
        super(false);
        this.plugin = plugin;
        this.removeMarker = new JLabel(REMOVE_ICON);
        this.invPanel = new InventorySetupInventoryPanel(itemManager, plugin);
        this.eqpPanel = new InventorySetupEquipmentPanel(itemManager, plugin);
        this.noSetupsPanel = new JPanel();
        this.invEqPanel = new JPanel();
        this.setupComboBox = new JComboBox();
        final JLabel addMarker = new JLabel(ADD_ICON);
        JLabel title = new JLabel();
        title.setText("Inventory Setups");
        title.setForeground(Color.WHITE);
        addMarker.setToolTipText("Add a new inventory setup");
        addMarker.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                plugin.addInventorySetup();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                addMarker.setIcon(ADD_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                addMarker.setIcon(ADD_ICON);
            }
        });
        this.removeMarker.setToolTipText("Remove the current inventory setup");
        this.removeMarker.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String name = (String)InventorySetupPluginPanel.this.setupComboBox.getSelectedItem();
                plugin.removeInventorySetup(name, true);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (InventorySetupPluginPanel.this.removeMarker.isEnabled()) {
                    InventorySetupPluginPanel.this.removeMarker.setIcon(REMOVE_HOVER_ICON);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                InventorySetupPluginPanel.this.removeMarker.setIcon(REMOVE_ICON);
            }
        });
        this.setupComboBox.addItem("");
        this.setupComboBox.setSelectedIndex(0);
        this.setupComboBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                String selection = (String)e.getItem();
                this.setCurrentInventorySetup(selection);
            }
        });
        JPanel markersPanel = new JPanel();
        markersPanel.setLayout(new FlowLayout(2, 10, 0));
        markersPanel.add(this.removeMarker);
        markersPanel.add(addMarker);
        JPanel titleAndMarkersPanel = new JPanel();
        titleAndMarkersPanel.setLayout(new BorderLayout());
        titleAndMarkersPanel.add((Component)title, "West");
        titleAndMarkersPanel.add((Component)markersPanel, "East");
        JPanel northAnchoredPanel = new JPanel();
        northAnchoredPanel.setLayout(new BoxLayout(northAnchoredPanel, 1));
        northAnchoredPanel.setBorder(new EmptyBorder(0, 0, 10, 0));
        northAnchoredPanel.add(titleAndMarkersPanel);
        northAnchoredPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        northAnchoredPanel.add(this.setupComboBox);
        BoxLayout invEqLayout = new BoxLayout(this.invEqPanel, 1);
        this.invEqPanel.setLayout(invEqLayout);
        this.invEqPanel.add(this.invPanel);
        this.invEqPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.invEqPanel.add(this.eqpPanel);
        PluginErrorPanel errorPanel = new PluginErrorPanel();
        errorPanel.setContent("Inventory Setups", "Select or create an inventory setup.");
        this.noSetupsPanel.add(errorPanel);
        JPanel contentPanel = new JPanel();
        BoxLayout contentLayout = new BoxLayout(contentPanel, 1);
        contentPanel.setLayout(contentLayout);
        contentPanel.add(this.invEqPanel);
        contentPanel.add(this.noSetupsPanel);
        JPanel contentWrapper = new JPanel(new BorderLayout());
        contentWrapper.add(Box.createGlue(), "Center");
        contentWrapper.add((Component)contentPanel, "North");
        JScrollPane contentWrapperPane = new JScrollPane(contentWrapper);
        contentWrapperPane.setHorizontalScrollBarPolicy(31);
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.add((Component)northAnchoredPanel, "North");
        this.add((Component)contentWrapperPane, "Center");
        this.showNoSetupsPanel();
    }

    public void showNoSetupsPanel() {
        this.setupComboBox.setSelectedIndex(0);
        this.removeMarker.setEnabled(false);
        this.noSetupsPanel.setVisible(true);
        this.invEqPanel.setVisible(false);
    }

    private void showHasSetupPanel(String name) {
        this.setupComboBox.setSelectedItem(name);
        this.removeMarker.setEnabled(true);
        this.noSetupsPanel.setVisible(false);
        this.invEqPanel.setVisible(true);
    }

    public void setCurrentInventorySetup(String name) {
        if (name.isEmpty()) {
            this.showNoSetupsPanel();
            return;
        }
        this.showHasSetupPanel(name);
        InventorySetup inventorySetup = this.plugin.getInventorySetup(name);
        this.invPanel.setInventorySetupSlots(inventorySetup);
        this.eqpPanel.setEquipmentSetupSlots(inventorySetup);
        if (this.plugin.getHighlightDifference()) {
            ArrayList<InventorySetupItem> normInv = this.plugin.getNormalizedContainer(InventoryID.INVENTORY);
            ArrayList<InventorySetupItem> normEqp = this.plugin.getNormalizedContainer(InventoryID.EQUIPMENT);
            this.highlightDifferences(normInv, inventorySetup, InventoryID.INVENTORY);
            this.highlightDifferences(normEqp, inventorySetup, InventoryID.EQUIPMENT);
        } else {
            this.invPanel.resetInventorySlotsColor();
            this.eqpPanel.resetEquipmentSlotsColor();
        }
        this.validate();
        this.repaint();
    }

    public void addInventorySetup(String name) {
        this.setupComboBox.addItem(name);
    }

    public void removeInventorySetup(String name) {
        this.setupComboBox.removeItem(name);
        this.showNoSetupsPanel();
        this.invPanel.resetInventorySlotsColor();
        this.eqpPanel.resetEquipmentSlotsColor();
        this.validate();
        this.repaint();
    }

    public void highlightDifferences(ArrayList<InventorySetupItem> container, InventorySetup setupToCheck, InventoryID type) {
        switch (type) {
            case INVENTORY: {
                this.invPanel.highlightDifferentSlots(container, setupToCheck);
                break;
            }
            case EQUIPMENT: {
                this.eqpPanel.highlightDifferences(container, setupToCheck);
            }
        }
    }

    public final String getSelectedInventorySetup() {
        return (String)this.setupComboBox.getSelectedItem();
    }

    static {
        BufferedImage addIcon = ImageUtil.getResourceStreamFromClass(InventorySetupPlugin.class, "add_icon.png");
        ADD_ICON = new ImageIcon(addIcon);
        ADD_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset(addIcon, 0.53f));
        BufferedImage removeIcon = ImageUtil.getResourceStreamFromClass(InventorySetupPlugin.class, "remove_icon.png");
        REMOVE_ICON = new ImageIcon(removeIcon);
        REMOVE_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset(removeIcon, 0.53f));
    }
}

