/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.inventorysetups.ui;

import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.JPanel;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.inventorysetups.InventorySetup;
import net.runelite.client.plugins.inventorysetups.InventorySetupItem;
import net.runelite.client.plugins.inventorysetups.InventorySetupPlugin;
import net.runelite.client.plugins.inventorysetups.ui.InventorySetupContainerPanel;
import net.runelite.client.plugins.inventorysetups.ui.InventorySetupSlot;
import net.runelite.client.ui.ColorScheme;

public class InventorySetupInventoryPanel
extends InventorySetupContainerPanel {
    private static final int ITEMS_PER_ROW = 4;
    private static final int NUM_INVENTORY_ITEMS = 28;
    private ArrayList<InventorySetupSlot> inventorySlots;

    InventorySetupInventoryPanel(ItemManager itemManager, InventorySetupPlugin plugin) {
        super(itemManager, plugin, "Inventory");
    }

    @Override
    public void setupContainerPanel(JPanel containerSlotsPanel) {
        this.inventorySlots = new ArrayList();
        for (int i = 0; i < 28; ++i) {
            this.inventorySlots.add(new InventorySetupSlot(ColorScheme.DARKER_GRAY_COLOR));
        }
        int numRows = 7;
        containerSlotsPanel.setLayout(new GridLayout(numRows, 4, 1, 1));
        for (int i = 0; i < 28; ++i) {
            containerSlotsPanel.add(this.inventorySlots.get(i));
        }
    }

    void setInventorySetupSlots(InventorySetup setup) {
        ArrayList<InventorySetupItem> inventory = setup.getInventory();
        for (int i = 0; i < 28; ++i) {
            super.setContainerSlot(i, this.inventorySlots.get(i), inventory);
        }
        this.validate();
        this.repaint();
    }

    void highlightDifferentSlots(ArrayList<InventorySetupItem> currInventory, InventorySetup inventorySetup) {
        ArrayList<InventorySetupItem> inventoryToCheck = inventorySetup.getInventory();
        assert (currInventory.size() == inventoryToCheck.size()) : "size mismatch";
        for (int i = 0; i < 28; ++i) {
            super.highlightDifferentSlotColor(inventoryToCheck.get(i), currInventory.get(i), this.inventorySlots.get(i));
        }
    }

    void resetInventorySlotsColor() {
        for (InventorySetupSlot inventorySlot : this.inventorySlots) {
            inventorySlot.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        }
    }
}

