/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.inventorysetups.ui;

import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JPanel;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.inventorysetups.InventorySetup;
import net.runelite.client.plugins.inventorysetups.InventorySetupItem;
import net.runelite.client.plugins.inventorysetups.InventorySetupPlugin;
import net.runelite.client.plugins.inventorysetups.ui.InventorySetupContainerPanel;
import net.runelite.client.plugins.inventorysetups.ui.InventorySetupSlot;
import net.runelite.client.ui.ColorScheme;

public class InventorySetupEquipmentPanel
extends InventorySetupContainerPanel {
    private HashMap<EquipmentInventorySlot, InventorySetupSlot> equipmentSlots;

    InventorySetupEquipmentPanel(ItemManager itemManager, InventorySetupPlugin plugin) {
        super(itemManager, plugin, "Equipment");
    }

    @Override
    public void setupContainerPanel(JPanel containerSlotsPanel) {
        this.equipmentSlots = new HashMap();
        for (EquipmentInventorySlot slot : EquipmentInventorySlot.values()) {
            this.equipmentSlots.put(slot, new InventorySetupSlot(ColorScheme.DARKER_GRAY_COLOR));
        }
        GridLayout gridLayout = new GridLayout(5, 3, 1, 1);
        containerSlotsPanel.setLayout(gridLayout);
        containerSlotsPanel.add(new InventorySetupSlot(ColorScheme.DARK_GRAY_COLOR));
        containerSlotsPanel.add(this.equipmentSlots.get((Object)EquipmentInventorySlot.HEAD));
        containerSlotsPanel.add(new InventorySetupSlot(ColorScheme.DARK_GRAY_COLOR));
        containerSlotsPanel.add(this.equipmentSlots.get((Object)EquipmentInventorySlot.CAPE));
        containerSlotsPanel.add(this.equipmentSlots.get((Object)EquipmentInventorySlot.AMULET));
        containerSlotsPanel.add(this.equipmentSlots.get((Object)EquipmentInventorySlot.AMMO));
        containerSlotsPanel.add(this.equipmentSlots.get((Object)EquipmentInventorySlot.WEAPON));
        containerSlotsPanel.add(this.equipmentSlots.get((Object)EquipmentInventorySlot.BODY));
        containerSlotsPanel.add(this.equipmentSlots.get((Object)EquipmentInventorySlot.SHIELD));
        containerSlotsPanel.add(new InventorySetupSlot(ColorScheme.DARK_GRAY_COLOR));
        containerSlotsPanel.add(this.equipmentSlots.get((Object)EquipmentInventorySlot.LEGS));
        containerSlotsPanel.add(new InventorySetupSlot(ColorScheme.DARK_GRAY_COLOR));
        containerSlotsPanel.add(this.equipmentSlots.get((Object)EquipmentInventorySlot.GLOVES));
        containerSlotsPanel.add(this.equipmentSlots.get((Object)EquipmentInventorySlot.BOOTS));
        containerSlotsPanel.add(this.equipmentSlots.get((Object)EquipmentInventorySlot.RING));
    }

    void setEquipmentSetupSlots(InventorySetup setup) {
        ArrayList<InventorySetupItem> equipment = setup.getEquipment();
        for (EquipmentInventorySlot slot : EquipmentInventorySlot.values()) {
            int i = slot.getSlotIdx();
            super.setContainerSlot(i, this.equipmentSlots.get((Object)slot), equipment);
        }
        this.validate();
        this.repaint();
    }

    void highlightDifferences(ArrayList<InventorySetupItem> currEquipment, InventorySetup inventorySetup) {
        ArrayList<InventorySetupItem> equipToCheck = inventorySetup.getEquipment();
        assert (currEquipment.size() == equipToCheck.size()) : "size mismatch";
        for (EquipmentInventorySlot slot : EquipmentInventorySlot.values()) {
            int slotIdx = slot.getSlotIdx();
            super.highlightDifferentSlotColor(equipToCheck.get(slotIdx), currEquipment.get(slotIdx), this.equipmentSlots.get((Object)slot));
        }
    }

    void resetEquipmentSlotsColor() {
        for (EquipmentInventorySlot slot : EquipmentInventorySlot.values()) {
            this.equipmentSlots.get((Object)slot).setBackground(ColorScheme.DARKER_GRAY_COLOR);
        }
    }
}

