/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.inventorysetups.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.runelite.client.game.AsyncBufferedImage;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.ItemVariationMapping;
import net.runelite.client.plugins.inventorysetups.InventorySetupConfig;
import net.runelite.client.plugins.inventorysetups.InventorySetupItem;
import net.runelite.client.plugins.inventorysetups.InventorySetupPlugin;
import net.runelite.client.plugins.inventorysetups.ui.InventorySetupSlot;
import net.runelite.client.ui.ColorScheme;

public abstract class InventorySetupContainerPanel
extends JPanel {
    protected ItemManager itemManager;
    private final InventorySetupPlugin plugin;

    InventorySetupContainerPanel(ItemManager itemManager, InventorySetupPlugin plugin, String captionText) {
        this.itemManager = itemManager;
        this.plugin = plugin;
        JPanel containerPanel = new JPanel();
        JPanel containerSlotsPanel = new JPanel();
        this.setupContainerPanel(containerSlotsPanel);
        JLabel caption = new JLabel(captionText);
        caption.setHorizontalAlignment(0);
        caption.setVerticalAlignment(0);
        JPanel captionPanel = new JPanel();
        captionPanel.add(caption);
        containerPanel.setLayout(new BorderLayout());
        containerPanel.add((Component)captionPanel, "North");
        containerPanel.add((Component)containerSlotsPanel, "Center");
        this.add(containerPanel);
    }

    void setContainerSlot(int index, InventorySetupSlot containerSlot, ArrayList<InventorySetupItem> items) {
        if (index >= items.size() || items.get(index).getId() == -1) {
            containerSlot.setImageLabel(null, null);
            return;
        }
        int itemId = items.get(index).getId();
        int quantity = items.get(index).getQuantity();
        String itemName = items.get(index).getName();
        AsyncBufferedImage itemImg = this.itemManager.getImage(itemId, quantity, quantity > 1);
        Object toolTip = itemName;
        if (quantity > 1) {
            toolTip = (String)toolTip + " (" + quantity + ")";
        }
        containerSlot.setImageLabel((String)toolTip, itemImg);
    }

    void highlightDifferentSlotColor(InventorySetupItem savedItem, InventorySetupItem currItem, InventorySetupSlot containerSlot) {
        InventorySetupConfig config = this.plugin.getConfig();
        Color highlightColor = config.getHighlightColor();
        if (config.getStackDifference() && currItem.getQuantity() != savedItem.getQuantity()) {
            containerSlot.setBackground(highlightColor);
            return;
        }
        int currId = currItem.getId();
        int checkId = savedItem.getId();
        if (!config.getVariationDifference()) {
            currId = ItemVariationMapping.map(currId);
            checkId = ItemVariationMapping.map(checkId);
        }
        if (currId != checkId) {
            containerSlot.setBackground(highlightColor);
            return;
        }
        containerSlot.setBackground(ColorScheme.DARKER_GRAY_COLOR);
    }

    public abstract void setupContainerPanel(JPanel var1);
}

