/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.inventorysetups;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import javax.inject.Inject;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemContainer;
import net.runelite.api.events.ConfigChanged;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.ItemVariationMapping;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.inventorysetups.InventorySetup;
import net.runelite.client.plugins.inventorysetups.InventorySetupBankOverlay;
import net.runelite.client.plugins.inventorysetups.InventorySetupConfig;
import net.runelite.client.plugins.inventorysetups.InventorySetupItem;
import net.runelite.client.plugins.inventorysetups.ui.InventorySetupPluginPanel;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Inventory Setups", description="Save inventory setups", tags={"items", "inventory", "setups"}, enabledByDefault=false)
public class InventorySetupPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(InventorySetupPlugin.class);
    private static final String CONFIG_GROUP = "inventorysetups";
    private static final String CONFIG_KEY = "setups";
    private static final int NUM_INVENTORY_ITEMS = 28;
    private static final int NUM_EQUIPMENT_ITEMS = 14;
    @Inject
    private Client client;
    @Inject
    private ItemManager itemManager;
    @Inject
    private InventorySetupBankOverlay overlay;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private InventorySetupConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ConfigManager configManager;
    private InventorySetupPluginPanel panel;
    private HashMap<String, InventorySetup> inventorySetups;
    private NavigationButton navButton;
    private boolean highlightDifference;

    @Override
    public void startUp() {
        this.overlayManager.add(this.overlay);
        this.panel = new InventorySetupPluginPanel(this, this.itemManager);
        BufferedImage icon = ImageUtil.getResourceStreamFromClass(this.getClass(), "inventorysetups_icon.png");
        this.navButton = NavigationButton.builder().tooltip("Inventory Setups").icon(icon).priority(9).panel(this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
        this.clientThread.invokeLater(() -> {
            if (this.client.getGameState() != GameState.LOGIN_SCREEN) {
                return false;
            }
            this.loadConfig();
            this.panel.showNoSetupsPanel();
            return true;
        });
    }

    public void addInventorySetup() {
        String name = JOptionPane.showInputDialog(this.panel, "Enter the name of this setup.", "Add New Setup", -1);
        if (name == null) {
            return;
        }
        if (name.isEmpty()) {
            JOptionPane.showMessageDialog(this.panel, "Invalid Setup Name", "Names must not be empty.", -1);
            return;
        }
        if (this.inventorySetups.containsKey(name)) {
            String builder = "The setup " + name + " already exists. Would you like to replace it with the current setup?";
            int confirm = JOptionPane.showConfirmDialog(this.panel, builder, "Warning", 2, -1);
            if (confirm == 2) {
                return;
            }
            this.removeInventorySetup(name, false);
        }
        this.clientThread.invoke(() -> {
            ArrayList<InventorySetupItem> inv = this.getNormalizedContainer(InventoryID.INVENTORY);
            ArrayList<InventorySetupItem> eqp = this.getNormalizedContainer(InventoryID.EQUIPMENT);
            InventorySetup invSetup = new InventorySetup(inv, eqp);
            SwingUtilities.invokeLater(() -> {
                this.inventorySetups.put(name, invSetup);
                this.panel.addInventorySetup(name);
                this.panel.setCurrentInventorySetup(name);
                this.updateConfig();
            });
        });
    }

    public void removeInventorySetup(String name, boolean askForConfirmation) {
        if (this.inventorySetups.containsKey(name)) {
            int confirm = 0;
            if (askForConfirmation) {
                confirm = JOptionPane.showConfirmDialog(this.panel, "Are you sure you want to remove this setup?", "Warning", 0, -1);
            }
            if (confirm == 0) {
                this.inventorySetups.remove(name);
                this.panel.removeInventorySetup(name);
            }
            this.updateConfig();
        }
    }

    public final InventorySetup getInventorySetup(String name) {
        return this.inventorySetups.get(name);
    }

    @Provides
    InventorySetupConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(InventorySetupConfig.class);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals(CONFIG_GROUP)) {
            this.highlightDifference = this.config.getHighlightDifferences() && this.client.getGameState() == GameState.LOGGED_IN;
            String setupName = this.panel.getSelectedInventorySetup();
            if (this.highlightDifference && !setupName.isEmpty()) {
                this.panel.setCurrentInventorySetup(setupName);
            }
        }
    }

    private void updateConfig() {
        if (this.inventorySetups.isEmpty()) {
            this.configManager.unsetConfiguration(CONFIG_GROUP, CONFIG_KEY);
            return;
        }
        Gson gson = new Gson();
        String json = gson.toJson(this.inventorySetups);
        this.configManager.setConfiguration(CONFIG_GROUP, CONFIG_KEY, json);
    }

    private void loadConfig() {
        String json = this.configManager.getConfiguration(CONFIG_GROUP, CONFIG_KEY);
        if (json == null || json.isEmpty()) {
            this.inventorySetups = new HashMap();
        } else {
            Gson gson = new Gson();
            Type type = new TypeToken<HashMap<String, InventorySetup>>(){}.getType();
            this.inventorySetups = (HashMap)gson.fromJson(json, type);
        }
        for (String key : this.inventorySetups.keySet()) {
            this.panel.addInventorySetup(key);
        }
        this.highlightDifference = false;
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (!this.highlightDifference || this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        String selectedInventorySetup = this.panel.getSelectedInventorySetup();
        if (selectedInventorySetup.isEmpty()) {
            return;
        }
        ItemContainer container = event.getItemContainer();
        if (container == this.client.getItemContainer(InventoryID.INVENTORY)) {
            ArrayList<InventorySetupItem> normContainer = this.getNormalizedContainer(InventoryID.INVENTORY);
            InventorySetup setup = this.inventorySetups.get(selectedInventorySetup);
            this.panel.highlightDifferences(normContainer, setup, InventoryID.INVENTORY);
        } else if (container == this.client.getItemContainer(InventoryID.EQUIPMENT)) {
            ArrayList<InventorySetupItem> normContainer = this.getNormalizedContainer(InventoryID.EQUIPMENT);
            InventorySetup setup = this.inventorySetups.get(selectedInventorySetup);
            this.panel.highlightDifferences(normContainer, setup, InventoryID.EQUIPMENT);
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        switch (event.getGameState()) {
            case LOGIN_SCREEN: {
                this.highlightDifference = false;
                String setupName = this.panel.getSelectedInventorySetup();
                if (setupName.isEmpty()) break;
                this.panel.setCurrentInventorySetup(setupName);
                break;
            }
            case LOGGED_IN: {
                this.highlightDifference = this.config.getHighlightDifferences();
            }
        }
    }

    public ArrayList<InventorySetupItem> getNormalizedContainer(InventoryID id) {
        assert (id == InventoryID.INVENTORY || id == InventoryID.EQUIPMENT) : "invalid inventory ID";
        ItemContainer container = this.client.getItemContainer(id);
        ArrayList<InventorySetupItem> newContainer = new ArrayList<InventorySetupItem>();
        Item[] items = null;
        if (container != null) {
            items = container.getItems();
        }
        int size = id == InventoryID.INVENTORY ? 28 : 14;
        for (int i = 0; i < size; ++i) {
            if (items == null || i >= items.length) {
                newContainer.add(new InventorySetupItem(-1, "", 0));
                continue;
            }
            Item item = items[i];
            String itemName = "";
            if (this.client.isClientThread()) {
                itemName = this.itemManager.getItemComposition(item.getId()).getName();
            }
            newContainer.add(new InventorySetupItem(item.getId(), itemName, item.getQuantity()));
        }
        return newContainer;
    }

    public final InventorySetupConfig getConfig() {
        return this.config;
    }

    public boolean getHighlightDifference() {
        return this.highlightDifference;
    }

    @Override
    public void shutDown() {
        this.overlayManager.remove(this.overlay);
        this.clientToolbar.removeNavigation(this.navButton);
    }

    final int[] getCurrentInventorySetupIds() {
        InventorySetup setup = this.inventorySetups.get(this.panel.getSelectedInventorySetup());
        if (setup == null) {
            return null;
        }
        ArrayList<InventorySetupItem> items = new ArrayList<InventorySetupItem>();
        items.addAll(setup.getEquipment());
        items.addAll(setup.getInventory());
        ArrayList<Integer> itemIds = new ArrayList<Integer>();
        for (InventorySetupItem item : items) {
            int id2 = item.getId();
            ItemComposition itemComposition = this.itemManager.getItemComposition(id2);
            if (id2 <= 0) continue;
            itemIds.add(ItemVariationMapping.map(id2));
            itemIds.add(itemComposition.getPlaceholderId());
        }
        return itemIds.stream().mapToInt(i -> i).filter(Objects::nonNull).filter(id -> id != -1).toArray();
    }
}

