/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.inventorysetups;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.stream.IntStream;
import javax.inject.Inject;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.inventorysetups.InventorySetupConfig;
import net.runelite.client.plugins.inventorysetups.InventorySetupPlugin;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.WidgetItemOverlay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventorySetupBankOverlay
extends WidgetItemOverlay {
    private static final Logger log = LoggerFactory.getLogger(InventorySetupBankOverlay.class);
    private final ItemManager itemManager;
    private final InventorySetupPlugin plugin;
    private final InventorySetupConfig config;

    @Inject
    public InventorySetupBankOverlay(ItemManager itemManager, InventorySetupPlugin plugin, InventorySetupConfig config) {
        this.itemManager = itemManager;
        this.plugin = plugin;
        this.config = config;
        this.showOnBank();
    }

    @Override
    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem itemWidget) {
        if (this.config.getBankHighlight()) {
            int[] ids = this.plugin.getCurrentInventorySetupIds();
            if (ids == null) {
                return;
            }
            if (IntStream.of(ids).noneMatch(x -> x == itemId)) {
                return;
            }
            Color color = this.config.getBankHighlightColor();
            if (color != null) {
                Rectangle bounds = itemWidget.getCanvasBounds();
                BufferedImage outline = this.itemManager.getItemOutline(itemId, itemWidget.getQuantity(), color);
                graphics.drawImage((Image)outline, (int)bounds.getX() + 1, (int)bounds.getY() + 1, null);
                if (itemWidget.getQuantity() > 1) {
                    this.drawQuantity(graphics, itemWidget, Color.YELLOW);
                } else if (itemWidget.getQuantity() == 0) {
                    this.drawQuantity(graphics, itemWidget, Color.YELLOW.darker());
                }
            }
        }
    }

    private void drawQuantity(Graphics2D graphics, WidgetItem item, Color darker) {
        graphics.setColor(Color.BLACK);
        graphics.drawString(String.valueOf(item.getQuantity()), item.getCanvasLocation().getX() + 2, item.getCanvasLocation().getY() + 11);
        graphics.setColor(darker);
        graphics.setFont(FontManager.getRunescapeSmallFont());
        graphics.drawString(String.valueOf(item.getQuantity()), item.getCanvasLocation().getX() + 1, item.getCanvasLocation().getY() + 10);
    }
}

