/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.interfacestyles;

import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.HealthBar;
import net.runelite.api.HealthBarOverride;
import net.runelite.api.NodeCache;
import net.runelite.api.SpritePixels;
import net.runelite.api.events.BeforeMenuRender;
import net.runelite.api.events.ConfigChanged;
import net.runelite.api.events.PostHealthBar;
import net.runelite.api.events.WidgetPositioned;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.interfacestyles.InterfaceStylesConfig;
import net.runelite.client.plugins.interfacestyles.Skin;
import net.runelite.client.plugins.interfacestyles.SpriteOverride;
import net.runelite.client.plugins.interfacestyles.WidgetOffset;
import net.runelite.client.plugins.interfacestyles.WidgetOverride;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Interface Styles", description="Change the interface style to the 2005/2010 interface", tags={"2005", "2010", "skin", "theme", "ui"}, enabledByDefault=false)
public class InterfaceStylesPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(InterfaceStylesPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private InterfaceStylesConfig config;
    @Inject
    private SpriteManager spriteManager;
    private HealthBarOverride healthBarOverride;

    @Provides
    InterfaceStylesConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(InterfaceStylesConfig.class);
    }

    @Override
    protected void startUp() throws Exception {
        this.clientThread.invoke(this::updateAllOverrides);
    }

    @Override
    protected void shutDown() throws Exception {
        this.clientThread.invoke(() -> {
            this.restoreWidgetDimensions();
            this.removeGameframe();
            this.healthBarOverride = null;
            this.client.setHealthBarOverride(null);
            NodeCache heathBarCache = this.client.getHealthBarCache();
            heathBarCache.reset();
        });
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged config) {
        if (config.getGroup().equals("interfaceStyles")) {
            this.clientThread.invoke(this::updateAllOverrides);
        }
    }

    @Subscribe
    public void onWidgetPositioned(WidgetPositioned widgetPositioned) {
        this.adjustWidgetDimensions();
    }

    @Subscribe
    public void onPostHealthBar(PostHealthBar postHealthBar) {
        if (this.healthBarOverride == null || !this.config.hdHealthBars()) {
            return;
        }
        HealthBar healthBar = postHealthBar.getHealthBar();
        SpritePixels frontSprite = healthBar.getHealthBarFrontSprite();
        if (frontSprite == this.healthBarOverride.getFrontSprite() || frontSprite == this.healthBarOverride.getFrontSpriteLarge()) {
            healthBar.setPadding(1);
        }
    }

    private void updateAllOverrides() {
        this.removeGameframe();
        this.overrideSprites();
        this.overrideWidgetSprites();
        this.restoreWidgetDimensions();
        this.adjustWidgetDimensions();
        this.overrideHealthBars();
    }

    @Subscribe
    public void onBeforeMenuRender(BeforeMenuRender event) {
        if (this.config.hdMenu()) {
            this.client.draw2010Menu();
            event.consume();
        }
    }

    private void overrideSprites() {
        for (SpriteOverride spriteOverride : SpriteOverride.values()) {
            for (Skin skin : spriteOverride.getSkin()) {
                if (skin != this.config.skin()) continue;
                String file = this.config.skin().toString() + "/" + spriteOverride.getSpriteID() + ".png";
                SpritePixels spritePixels = this.getFileSpritePixels(file);
                if (spriteOverride.getSpriteID() == 169) {
                    this.client.setCompass(spritePixels);
                    continue;
                }
                this.client.getSpriteOverrides().put(spriteOverride.getSpriteID(), spritePixels);
            }
        }
    }

    private void restoreSprites() {
        this.client.getWidgetSpriteCache().reset();
        for (SpriteOverride spriteOverride : SpriteOverride.values()) {
            this.client.getSpriteOverrides().remove(spriteOverride.getSpriteID());
        }
    }

    private void overrideWidgetSprites() {
        for (WidgetOverride widgetOverride : WidgetOverride.values()) {
            String file;
            SpritePixels spritePixels;
            if (widgetOverride.getSkin() != this.config.skin() || (spritePixels = this.getFileSpritePixels(file = this.config.skin().toString() + "/widget/" + widgetOverride.getName() + ".png")) == null) continue;
            for (WidgetInfo widgetInfo : widgetOverride.getWidgetInfo()) {
                this.client.getWidgetSpriteOverrides().put(widgetInfo.getPackedId(), spritePixels);
            }
        }
    }

    private void restoreWidgetSprites() {
        for (WidgetOverride widgetOverride : WidgetOverride.values()) {
            for (WidgetInfo widgetInfo : widgetOverride.getWidgetInfo()) {
                this.client.getWidgetSpriteOverrides().remove(widgetInfo.getPackedId());
            }
        }
    }

    private SpritePixels getFileSpritePixels(String file) {
        try {
            log.debug("Loading: {}", (Object)file);
            BufferedImage image = ImageUtil.getResourceStreamFromClass(this.getClass(), file);
            return ImageUtil.getImageSpritePixels(image, this.client);
        }
        catch (RuntimeException ex) {
            log.debug("Unable to load image: ", ex);
            return null;
        }
    }

    private void adjustWidgetDimensions() {
        for (WidgetOffset widgetOffset : WidgetOffset.values()) {
            Widget widget;
            if (widgetOffset.getSkin() != this.config.skin() || (widget = this.client.getWidget(widgetOffset.getWidgetInfo())) == null) continue;
            if (widgetOffset.getOffsetX() != null) {
                widget.setRelativeX(widgetOffset.getOffsetX());
            }
            if (widgetOffset.getOffsetY() != null) {
                widget.setRelativeY(widgetOffset.getOffsetY());
            }
            if (widgetOffset.getWidth() != null) {
                widget.setWidth(widgetOffset.getWidth());
            }
            if (widgetOffset.getHeight() == null) continue;
            widget.setHeight(widgetOffset.getHeight());
        }
    }

    private void overrideHealthBars() {
        NodeCache healthBarCache = this.client.getHealthBarCache();
        healthBarCache.reset();
        if (this.config.hdHealthBars()) {
            HealthBarOverride override;
            String fileBase = Skin.AROUND_2010.toString() + "/healthbar/";
            SpritePixels frontSprite = this.getFileSpritePixels(fileBase + "front.png");
            SpritePixels backSprite = this.getFileSpritePixels(fileBase + "back.png");
            SpritePixels frontSpriteLarge = this.getFileSpritePixels(fileBase + "front_large.png");
            SpritePixels backSpriteLarge = this.getFileSpritePixels(fileBase + "back_large.png");
            this.healthBarOverride = override = new HealthBarOverride(frontSprite, backSprite, frontSpriteLarge, backSpriteLarge);
            this.client.setHealthBarOverride(override);
        } else {
            this.healthBarOverride = null;
            this.client.setHealthBarOverride(null);
        }
    }

    private void restoreWidgetDimensions() {
        for (WidgetOffset widgetOffset : WidgetOffset.values()) {
            Widget widget = this.client.getWidget(widgetOffset.getWidgetInfo());
            if (widget == null) continue;
            widget.revalidate();
        }
    }

    private void removeGameframe() {
        this.restoreSprites();
        this.restoreWidgetSprites();
        BufferedImage compassImage = this.spriteManager.getSprite(169, 0);
        if (compassImage != null) {
            SpritePixels compass = ImageUtil.getImageSpritePixels(compassImage, this.client);
            this.client.setCompass(compass);
        }
    }
}

