/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.implings;

import com.google.inject.Provides;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.GameState;
import net.runelite.api.NPC;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.implings.Impling;
import net.runelite.client.plugins.implings.ImplingMinimapOverlay;
import net.runelite.client.plugins.implings.ImplingType;
import net.runelite.client.plugins.implings.ImplingsConfig;
import net.runelite.client.plugins.implings.ImplingsOverlay;
import net.runelite.client.ui.overlay.OverlayManager;

@PluginDescriptor(name="Implings", description="Highlight nearby implings on the minimap and on-screen", tags={"hunter", "minimap", "overlay"})
public class ImplingsPlugin
extends Plugin {
    private final List<NPC> implings = new ArrayList<NPC>();
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ImplingsOverlay overlay;
    @Inject
    private ImplingMinimapOverlay minimapOverlay;
    @Inject
    private ImplingsConfig config;

    @Provides
    ImplingsConfig getConfig(ConfigManager configManager) {
        return configManager.getConfig(ImplingsConfig.class);
    }

    @Override
    protected void startUp() throws Exception {
        this.overlayManager.add(this.overlay);
        this.overlayManager.add(this.minimapOverlay);
    }

    @Override
    protected void shutDown() throws Exception {
        this.overlayManager.remove(this.overlay);
        this.overlayManager.remove(this.minimapOverlay);
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned npcSpawned) {
        NPC npc = npcSpawned.getNpc();
        Impling impling = Impling.findImpling(npc.getId());
        if (impling != null) {
            this.implings.add(npc);
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGIN_SCREEN || event.getGameState() == GameState.HOPPING) {
            this.implings.clear();
        }
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned npcDespawned) {
        if (this.implings.isEmpty()) {
            return;
        }
        NPC npc = npcDespawned.getNpc();
        this.implings.remove(npc);
    }

    boolean showNpc(NPC npc) {
        Impling impling = Impling.findImpling(npc.getId());
        if (impling == null) {
            return false;
        }
        return this.showImplingType(impling.getImplingType());
    }

    boolean showImplingType(ImplingType implingType) {
        switch (implingType) {
            case BABY: {
                return this.config.showBaby();
            }
            case YOUNG: {
                return this.config.showYoung();
            }
            case GOURMET: {
                return this.config.showGourmet();
            }
            case EARTH: {
                return this.config.showEarth();
            }
            case ESSENCE: {
                return this.config.showEssence();
            }
            case ECLECTIC: {
                return this.config.showEclectic();
            }
            case NATURE: {
                return this.config.showNature();
            }
            case MAGPIE: {
                return this.config.showMagpie();
            }
            case NINJA: {
                return this.config.showNinja();
            }
            case DRAGON: {
                return this.config.showDragon();
            }
            case LUCKY: {
                return this.config.showLucky();
            }
        }
        return false;
    }

    Color npcToColor(NPC npc) {
        Impling impling = Impling.findImpling(npc.getId());
        if (impling == null) {
            return null;
        }
        switch (impling.getImplingType()) {
            case BABY: {
                return this.config.getBabyColor();
            }
            case YOUNG: {
                return this.config.getYoungColor();
            }
            case GOURMET: {
                return this.config.getGourmetColor();
            }
            case EARTH: {
                return this.config.getEarthColor();
            }
            case ESSENCE: {
                return this.config.getEssenceColor();
            }
            case ECLECTIC: {
                return this.config.getEclecticColor();
            }
            case NATURE: {
                return this.config.getNatureColor();
            }
            case MAGPIE: {
                return this.config.getMagpieColor();
            }
            case NINJA: {
                return this.config.getNinjaColor();
            }
            case DRAGON: {
                return this.config.getDragonColor();
            }
            case LUCKY: {
                return this.config.getLuckyColor();
            }
        }
        return null;
    }

    List<NPC> getImplings() {
        return this.implings;
    }
}

