/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.implings;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.plugins.implings.ImplingSpawn;
import net.runelite.client.plugins.implings.ImplingsConfig;
import net.runelite.client.plugins.implings.ImplingsPlugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;

public class ImplingsOverlay
extends Overlay {
    private final Client client;
    private final ImplingsConfig config;
    private final ImplingsPlugin plugin;

    @Inject
    private ImplingsOverlay(Client client2, ImplingsConfig config, ImplingsPlugin plugin) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.config = config;
        this.client = client2;
        this.plugin = plugin;
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        List<NPC> implings = this.plugin.getImplings();
        if (implings.isEmpty()) {
            return null;
        }
        for (NPC imp : implings) {
            Color color = this.plugin.npcToColor(imp);
            if (!this.plugin.showNpc(imp) || color == null) continue;
            this.drawImp(graphics, imp, imp.getName(), color);
        }
        if (this.config.showSpawn()) {
            for (ImplingSpawn spawn : ImplingSpawn.values()) {
                if (!this.plugin.showImplingType(spawn.getType())) continue;
                String impName = spawn.getType().getName();
                this.drawSpawn(graphics, spawn.getSpawnLocation(), impName, this.config.getSpawnColor());
            }
        }
        return null;
    }

    private void drawSpawn(Graphics2D graphics, WorldPoint point, String text, Color color) {
        Point textPoint;
        if (point.distanceTo(this.client.getLocalPlayer().getWorldLocation()) >= 32) {
            return;
        }
        LocalPoint localPoint = LocalPoint.fromWorld(this.client, point);
        if (localPoint == null) {
            return;
        }
        Polygon poly = Perspective.getCanvasTilePoly(this.client, localPoint);
        if (poly != null) {
            OverlayUtil.renderPolygon(graphics, poly, color);
        }
        if ((textPoint = Perspective.getCanvasTextLocation(this.client, graphics, localPoint, text, 0)) != null) {
            OverlayUtil.renderTextLocation(graphics, textPoint, text, color);
        }
    }

    private void drawImp(Graphics2D graphics, Actor actor, String text, Color color) {
        Point textLocation;
        Polygon poly = actor.getCanvasTilePoly();
        if (poly != null) {
            OverlayUtil.renderPolygon(graphics, poly, color);
        }
        if ((textLocation = actor.getCanvasTextLocation(graphics, text, actor.getLogicalHeight())) != null) {
            OverlayUtil.renderTextLocation(graphics, textLocation, text, color);
        }
    }
}

