/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.implings;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.NPC;
import net.runelite.api.Point;
import net.runelite.client.plugins.implings.ImplingsConfig;
import net.runelite.client.plugins.implings.ImplingsPlugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;

public class ImplingMinimapOverlay
extends Overlay {
    private final ImplingsPlugin plugin;
    private final ImplingsConfig config;

    @Inject
    private ImplingMinimapOverlay(ImplingsPlugin plugin, ImplingsConfig config) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.plugin = plugin;
        this.config = config;
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        List<NPC> imps = this.plugin.getImplings();
        if (imps.isEmpty()) {
            return null;
        }
        for (NPC imp : imps) {
            Point impLocation = imp.getMinimapLocation();
            Color color = this.plugin.npcToColor(imp);
            if (!this.plugin.showNpc(imp) || impLocation == null || color == null) continue;
            OverlayUtil.renderMinimapLocation(graphics, impLocation, color);
            if (!this.config.showName()) continue;
            Point textLocation = new Point(impLocation.getX() + 1, impLocation.getY());
            OverlayUtil.renderTextLocation(graphics, textLocation, imp.getName(), color);
        }
        return null;
    }
}

