/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.idlenotifier;

import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;

@ConfigGroup(value="idlenotifier")
public interface IdleNotifierConfig
extends Config {
    @ConfigItem(keyName="animationidle", name="Idle Animation Notifications", description="Configures if idle animation notifications are enabled", position=1)
    default public boolean animationIdle() {
        return true;
    }

    @ConfigItem(keyName="interactionidle", name="Idle Interaction Notifications", description="Configures if idle interaction notifications are enabled e.g. combat, fishing", position=2)
    default public boolean interactionIdle() {
        return true;
    }

    @ConfigItem(keyName="logoutidle", name="Idle Logout Notifications", description="Configures if the idle logout notifications are enabled", position=3)
    default public boolean logoutIdle() {
        return true;
    }

    @ConfigItem(keyName="timeout", name="Idle Notification Delay (ms)", description="The notification delay after the player is idle", position=4)
    default public int getIdleNotificationDelay() {
        return 5000;
    }

    @ConfigItem(keyName="hitpoints", name="Hitpoints Notification Threshold", description="The amount of hitpoints to send a notification at. A value of 0 will disable notification.", position=5)
    default public int getHitpointsThreshold() {
        return 0;
    }

    @ConfigItem(keyName="prayer", name="Prayer Notification Threshold", description="The amount of prayer points to send a notification at. A value of 0 will disable notification.", position=6)
    default public int getPrayerThreshold() {
        return 0;
    }

    @ConfigItem(keyName="oxygen", name="Oxygen Notification Threshold", position=7, description="The amount of remaining oxygen to send a notification at. A value of 0 will disable notification.")
    default public int getOxygenThreshold() {
        return 0;
    }

    @ConfigItem(keyName="spec", name="Special Attack Energy Notification Threshold", position=8, description="The amount of spec energy reached to send a notification at. A value of 0 will disable notification.")
    default public int getSpecEnergyThreshold() {
        return 0;
    }
}

