/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hiscore;

import com.google.inject.Inject;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import net.runelite.api.Actor;
import net.runelite.api.ClanMember;
import net.runelite.api.Client;
import net.runelite.api.Friend;
import net.runelite.api.Player;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NameAutocompleter
implements KeyListener {
    private static final Logger log = LoggerFactory.getLogger(NameAutocompleter.class);
    private static final String NBSP = Character.toString('\u00a0');
    private static final Pattern INVALID_CHARS = Pattern.compile("[^a-zA-Z0-9_ -]");
    private final Client client;
    private String autocompleteName;
    private Pattern autocompleteNamePattern;

    @Inject
    private NameAutocompleter(@Nullable Client client2) {
        this.client = client2;
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        JTextComponent input = (JTextComponent)e.getSource();
        String inputText = input.getText();
        if (input.getSelectionEnd() != inputText.length()) {
            return;
        }
        String charToInsert = Character.toString(e.getKeyChar());
        if (INVALID_CHARS.matcher(charToInsert).find() || INVALID_CHARS.matcher(inputText).find()) {
            return;
        }
        if (this.autocompleteName != null && this.autocompleteNamePattern.matcher(inputText).matches()) {
            if (this.isExpectedNext(input, charToInsert)) {
                try {
                    int insertIndex = input.getSelectionStart();
                    Document doc = input.getDocument();
                    doc.remove(insertIndex, 1);
                    doc.insertString(insertIndex, charToInsert, null);
                    input.select(insertIndex + 1, input.getSelectionEnd());
                }
                catch (BadLocationException ex) {
                    log.warn("Could not insert character.", ex);
                }
                e.consume();
            } else {
                this.newAutocomplete(e);
            }
        } else {
            this.newAutocomplete(e);
        }
    }

    private void newAutocomplete(KeyEvent e) {
        JTextComponent input = (JTextComponent)e.getSource();
        String inputText = input.getText();
        String nameStart = inputText.substring(0, input.getSelectionStart()) + e.getKeyChar();
        if (this.findAutocompleteName(nameStart)) {
            String name = this.autocompleteName;
            SwingUtilities.invokeLater(() -> {
                try {
                    input.getDocument().insertString(nameStart.length(), name.substring(nameStart.length()), null);
                    input.select(nameStart.length(), name.length());
                }
                catch (BadLocationException ex) {
                    log.warn("Could not autocomplete name.", ex);
                }
            });
        }
    }

    private boolean findAutocompleteName(String nameStart) {
        ClanMember[] clannies;
        Pattern pattern = Pattern.compile("(?i)^" + nameStart.replaceAll("[ _-]", "[ _" + NBSP + "-]") + ".+?");
        if (this.client == null) {
            return false;
        }
        Optional<Object> autocompleteName = Optional.empty();
        Friend[] friends = this.client.getFriends();
        if (friends != null) {
            autocompleteName = Arrays.stream(friends).filter(Objects::nonNull).map(Friend::getName).filter(n -> pattern.matcher((CharSequence)n).matches()).findFirst();
        }
        if (!autocompleteName.isPresent() && (clannies = this.client.getClanMembers()) != null) {
            autocompleteName = Arrays.stream(clannies).filter(Objects::nonNull).map(ClanMember::getUsername).filter(n -> pattern.matcher((CharSequence)n).matches()).findFirst();
        }
        if (!autocompleteName.isPresent()) {
            Player[] cachedPlayers = this.client.getCachedPlayers();
            autocompleteName = Arrays.stream(cachedPlayers).filter(Objects::nonNull).map(Actor::getName).filter(n -> pattern.matcher((CharSequence)n).matches()).findFirst();
        }
        if (autocompleteName.isPresent()) {
            this.autocompleteName = ((String)autocompleteName.get()).replace(NBSP, " ");
            this.autocompleteNamePattern = Pattern.compile("(?i)^" + this.autocompleteName.replaceAll("[ _-]", "[ _-]") + "$");
        } else {
            this.autocompleteName = null;
            this.autocompleteNamePattern = null;
        }
        return autocompleteName.isPresent();
    }

    private boolean isExpectedNext(JTextComponent input, String nextChar) {
        String expected;
        if (input.getSelectionStart() < input.getSelectionEnd()) {
            try {
                expected = input.getText(input.getSelectionStart(), 1);
            }
            catch (BadLocationException ex) {
                log.warn("Could not get first character from input selection.", ex);
                return false;
            }
        } else {
            expected = "";
        }
        return nextChar.equalsIgnoreCase(expected);
    }
}

