/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hiscore;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ObjectArrays;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.SwingUtilities;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ConfigChanged;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.PlayerMenuOptionClicked;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.menus.MenuManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.hiscore.HiscoreConfig;
import net.runelite.client.plugins.hiscore.HiscorePanel;
import net.runelite.client.plugins.hiscore.NameAutocompleter;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;
import org.apache.commons.lang3.ArrayUtils;

@PluginDescriptor(name="HiScore", description="Enable the HiScore panel and an optional Lookup option on players", tags={"panel", "players"}, loadWhenOutdated=true)
public class HiscorePlugin
extends Plugin {
    private static final String LOOKUP = "Lookup";
    private static final String KICK_OPTION = "Kick";
    private static final ImmutableList<String> AFTER_OPTIONS = ImmutableList.of("Message", "Add ignore", "Remove friend", "Kick");
    private static final Pattern BOUNTY_PATTERN = Pattern.compile("<col=ff0000>You've been assigned a target: (.*)</col>");
    @Inject
    @Nullable
    private Client client;
    @Inject
    private Provider<MenuManager> menuManager;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private ScheduledExecutorService executor;
    @Inject
    private HiscoreConfig config;
    private NavigationButton navButton;
    private HiscorePanel hiscorePanel;
    @Inject
    private NameAutocompleter autocompleter;

    @Provides
    HiscoreConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(HiscoreConfig.class);
    }

    @Override
    protected void startUp() throws Exception {
        this.hiscorePanel = this.injector.getInstance(HiscorePanel.class);
        BufferedImage icon = ImageUtil.getResourceStreamFromClass(this.getClass(), "normal.png");
        this.navButton = NavigationButton.builder().tooltip("Hiscore").icon(icon).priority(5).panel(this.hiscorePanel).build();
        this.clientToolbar.addNavigation(this.navButton);
        if (this.config.playerOption() && this.client != null) {
            this.menuManager.get().addPlayerMenuItem(LOOKUP);
        }
        if (this.config.autocomplete()) {
            this.hiscorePanel.addInputKeyListener(this.autocompleter);
        }
    }

    @Override
    protected void shutDown() throws Exception {
        this.hiscorePanel.removeInputKeyListener(this.autocompleter);
        this.clientToolbar.removeNavigation(this.navButton);
        if (this.client != null) {
            this.menuManager.get().removePlayerMenuItem(LOOKUP);
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("hiscore")) {
            if (this.client != null) {
                this.menuManager.get().removePlayerMenuItem(LOOKUP);
                if (this.config.playerOption()) {
                    this.menuManager.get().addPlayerMenuItem(LOOKUP);
                }
            }
            if (event.getKey().equals("autocomplete")) {
                if (this.config.autocomplete()) {
                    this.hiscorePanel.addInputKeyListener(this.autocompleter);
                } else {
                    this.hiscorePanel.removeInputKeyListener(this.autocompleter);
                }
            }
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        if (!this.config.menuOption()) {
            return;
        }
        int groupId = WidgetInfo.TO_GROUP(event.getActionParam1());
        String option = event.getOption();
        if (groupId == WidgetInfo.FRIENDS_LIST.getGroupId() || groupId == WidgetInfo.CLAN_CHAT.getGroupId() || groupId == WidgetInfo.CHATBOX.getGroupId() && !KICK_OPTION.equals(option) || groupId == WidgetInfo.RAIDING_PARTY.getGroupId() || groupId == WidgetInfo.PRIVATE_CHAT_MESSAGE.getGroupId()) {
            if (!AFTER_OPTIONS.contains(option)) {
                return;
            }
            MenuEntry lookup = new MenuEntry();
            lookup.setOption(LOOKUP);
            lookup.setTarget(event.getTarget());
            lookup.setType(MenuAction.RUNELITE.getId());
            lookup.setParam0(event.getActionParam0());
            lookup.setParam1(event.getActionParam1());
            lookup.setIdentifier(event.getIdentifier());
            this.insertMenuEntry(lookup, this.client.getMenuEntries());
        }
    }

    @Subscribe
    public void onPlayerMenuOptionClicked(PlayerMenuOptionClicked event) {
        if (event.getMenuOption().equals(LOOKUP)) {
            this.lookupPlayer(Text.removeTags(event.getMenuTarget()));
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (!this.config.bountylookup() || !event.getType().equals((Object)ChatMessageType.GAMEMESSAGE)) {
            return;
        }
        String message = event.getMessage();
        Matcher m = BOUNTY_PATTERN.matcher(message);
        if (m.matches()) {
            this.lookupPlayer(m.group(1));
        }
    }

    private void insertMenuEntry(MenuEntry newEntry, MenuEntry[] entries) {
        Object[] newMenu = ObjectArrays.concat(entries, newEntry);
        int menuEntryCount = newMenu.length;
        ArrayUtils.swap(newMenu, menuEntryCount - 1, menuEntryCount - 2);
        this.client.setMenuEntries((MenuEntry[])newMenu);
    }

    private void lookupPlayer(String playerName) {
        this.executor.execute(() -> {
            try {
                SwingUtilities.invokeAndWait(() -> {
                    if (!this.navButton.isSelected()) {
                        this.navButton.getOnSelect().run();
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            this.hiscorePanel.lookup(playerName);
        });
    }
}

