/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hiscore;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.api.Client;
import net.runelite.api.Experience;
import net.runelite.api.Player;
import net.runelite.api.WorldType;
import net.runelite.client.plugins.hiscore.HiscoreConfig;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.IconTextField;
import net.runelite.client.ui.components.materialtabs.MaterialTab;
import net.runelite.client.ui.components.materialtabs.MaterialTabGroup;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.StackFormatter;
import net.runelite.http.api.hiscore.HiscoreClient;
import net.runelite.http.api.hiscore.HiscoreEndpoint;
import net.runelite.http.api.hiscore.HiscoreResult;
import net.runelite.http.api.hiscore.HiscoreSkill;
import net.runelite.http.api.hiscore.Skill;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiscorePanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(HiscorePanel.class);
    private static final int MAX_USERNAME_LENGTH = 12;
    private static final List<HiscoreSkill> SKILLS = ImmutableList.of(HiscoreSkill.ATTACK, HiscoreSkill.HITPOINTS, HiscoreSkill.MINING, HiscoreSkill.STRENGTH, HiscoreSkill.AGILITY, HiscoreSkill.SMITHING, HiscoreSkill.DEFENCE, HiscoreSkill.HERBLORE, HiscoreSkill.FISHING, HiscoreSkill.RANGED, HiscoreSkill.THIEVING, HiscoreSkill.COOKING, new HiscoreSkill[]{HiscoreSkill.PRAYER, HiscoreSkill.CRAFTING, HiscoreSkill.FIREMAKING, HiscoreSkill.MAGIC, HiscoreSkill.FLETCHING, HiscoreSkill.WOODCUTTING, HiscoreSkill.RUNECRAFT, HiscoreSkill.SLAYER, HiscoreSkill.FARMING, HiscoreSkill.CONSTRUCTION, HiscoreSkill.HUNTER});
    @Inject
    ScheduledExecutorService executor;
    @Inject
    @Nullable
    private Client client;
    private final HiscoreConfig config;
    private final IconTextField searchBar;
    private final List<JLabel> skillLabels = new ArrayList<JLabel>();
    private final JPanel statsPanel = new JPanel();
    private final MaterialTabGroup tabGroup;
    private final HiscoreClient hiscoreClient = new HiscoreClient();
    private HiscoreResult result;
    private HiscoreEndpoint selectedEndPoint;
    private boolean loading = false;

    @Inject
    public HiscorePanel(HiscoreConfig config) {
        this.config = config;
        this.setBorder(new EmptyBorder(18, 10, 0, 10));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 10, 0);
        this.searchBar = new IconTextField();
        this.searchBar.setIcon(IconTextField.Icon.SEARCH);
        this.searchBar.setPreferredSize(new Dimension(205, 30));
        this.searchBar.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.searchBar.setHoverBackgroundColor(ColorScheme.DARK_GRAY_HOVER_COLOR);
        this.searchBar.setMinimumSize(new Dimension(0, 30));
        this.searchBar.addActionListener(e -> this.executor.execute(this::lookup));
        this.searchBar.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                if (HiscorePanel.this.client == null) {
                    return;
                }
                Player localPlayer = HiscorePanel.this.client.getLocalPlayer();
                if (localPlayer != null) {
                    HiscorePanel.this.executor.execute(() -> HiscorePanel.this.lookup(localPlayer.getName()));
                }
            }
        });
        this.add((Component)this.searchBar, c);
        ++c.gridy;
        this.tabGroup = new MaterialTabGroup();
        this.tabGroup.setLayout(new GridLayout(1, 5, 7, 7));
        for (HiscoreEndpoint endpoint : HiscoreEndpoint.values()) {
            if (endpoint == HiscoreEndpoint.CUSTOM) continue;
            BufferedImage iconImage = ImageUtil.getResourceStreamFromClass(this.getClass(), endpoint.name().toLowerCase() + ".png");
            MaterialTab tab = new MaterialTab(new ImageIcon(iconImage), this.tabGroup, null);
            tab.setToolTipText(endpoint.getName() + " Hiscores");
            tab.setOnSelectEvent(() -> {
                if (this.loading) {
                    return false;
                }
                this.selectedEndPoint = endpoint;
                return true;
            });
            tab.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (HiscorePanel.this.loading) {
                        return;
                    }
                    HiscorePanel.this.executor.execute(() -> HiscorePanel.this.lookup());
                }
            });
            this.tabGroup.addTab(tab);
        }
        this.resetEndpoints();
        this.add((Component)this.tabGroup, c);
        ++c.gridy;
        GridLayout stats = new GridLayout(8, 3);
        this.statsPanel.setLayout(stats);
        this.statsPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.statsPanel.setBorder(new EmptyBorder(5, 0, 5, 0));
        for (HiscoreSkill skill : SKILLS) {
            JPanel panel = this.makeSkillPanel(skill);
            this.statsPanel.add(panel);
        }
        this.add((Component)this.statsPanel, c);
        ++c.gridy;
        JPanel totalPanel = new JPanel();
        totalPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        totalPanel.setLayout(new GridLayout(1, 2));
        totalPanel.add(this.makeSkillPanel(null));
        totalPanel.add(this.makeSkillPanel(HiscoreSkill.OVERALL));
        this.add((Component)totalPanel, c);
        ++c.gridy;
        JPanel minigamePanel = new JPanel();
        minigamePanel.setLayout(new GridLayout(2, 3));
        minigamePanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        minigamePanel.add(this.makeSkillPanel(HiscoreSkill.CLUE_SCROLL_ALL));
        minigamePanel.add(this.makeSkillPanel(HiscoreSkill.LAST_MAN_STANDING));
        minigamePanel.add(this.makeSkillPanel(HiscoreSkill.BOUNTY_HUNTER_ROGUE));
        minigamePanel.add(this.makeSkillPanel(HiscoreSkill.BOUNTY_HUNTER_HUNTER));
        this.add((Component)minigamePanel, c);
        ++c.gridy;
    }

    @Override
    public void onActivate() {
        super.onActivate();
        this.searchBar.requestFocusInWindow();
    }

    private JPanel makeSkillPanel(HiscoreSkill skill) {
        JLabel label = new JLabel();
        label.setFont(FontManager.getRunescapeSmallFont());
        label.setText("--");
        String skillName = skill == null ? "combat" : skill.getName().toLowerCase();
        Object directory = "/skill_icons";
        directory = skillName.equals("combat") || skillName.equals("overall") ? (String)directory + "/" : (String)directory + "_small/";
        String skillIcon = (String)directory + skillName + ".png";
        log.debug("Loading skill icon from {}", (Object)skillIcon);
        label.setIcon(new ImageIcon(ImageUtil.getResourceStreamFromClass(this.getClass(), skillIcon)));
        boolean totalLabel = skill == HiscoreSkill.OVERALL || skill == null;
        label.setIconTextGap(totalLabel ? 10 : 4);
        JPanel skillPanel = new JPanel();
        skillPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        skillPanel.setBorder(new EmptyBorder(2, 0, 2, 0));
        this.skillLabels.add(label);
        skillPanel.add(this.skillLabels.get(this.skillLabels.size() - 1));
        return skillPanel;
    }

    public void lookup(String username) {
        this.searchBar.setText(username);
        this.resetEndpoints();
        this.lookup();
    }

    private void lookup() {
        String lookup = this.searchBar.getText();
        if (Strings.isNullOrEmpty(lookup = HiscorePanel.sanitize(lookup))) {
            return;
        }
        if (lookup.length() > 12) {
            this.searchBar.setIcon(IconTextField.Icon.ERROR);
            this.loading = false;
            return;
        }
        this.searchBar.setEditable(false);
        this.searchBar.setIcon(IconTextField.Icon.LOADING_DARKER);
        this.loading = true;
        for (JLabel label : this.skillLabels) {
            label.setText("--");
            label.setToolTipText(null);
        }
        if (this.selectedEndPoint == null) {
            this.selectedEndPoint = HiscoreEndpoint.NORMAL;
        }
        try {
            log.debug("Hiscore endpoint " + this.selectedEndPoint.name() + " selected");
            this.result = this.hiscoreClient.lookup(lookup, this.selectedEndPoint);
        }
        catch (IOException ex) {
            log.warn("Error fetching Hiscore data " + ex.getMessage());
            this.searchBar.setIcon(IconTextField.Icon.ERROR);
            this.searchBar.setEditable(true);
            this.loading = false;
            return;
        }
        if (this.result == null) {
            this.searchBar.setIcon(IconTextField.Icon.ERROR);
            this.searchBar.setEditable(true);
            this.loading = false;
            return;
        }
        this.searchBar.setIcon(IconTextField.Icon.SEARCH);
        this.searchBar.setEditable(true);
        this.loading = false;
        int index = 0;
        for (JLabel label : this.skillLabels) {
            HiscoreSkill skill = this.find(index);
            if (skill == null) {
                if (this.result.getPlayer() != null) {
                    int combatLevel = Experience.getCombatLevel(this.result.getAttack().getLevel(), this.result.getStrength().getLevel(), this.result.getDefence().getLevel(), this.result.getHitpoints().getLevel(), this.result.getMagic().getLevel(), this.result.getRanged().getLevel(), this.result.getPrayer().getLevel());
                    label.setText(Integer.toString(combatLevel));
                }
            } else {
                Skill s = this.result.getSkill(skill);
                if (s != null) {
                    long exp = s.getExperience();
                    boolean isSkill = SKILLS.contains((Object)skill);
                    int level = -1;
                    if (this.config.virtualLevels() && isSkill && exp > -1L) {
                        level = Experience.getLevelForXp((int)exp);
                    } else if (!isSkill || exp != -1L) {
                        level = s.getLevel();
                    }
                    if (level != -1) {
                        label.setText(Integer.toString(level));
                    }
                }
            }
            label.setToolTipText(this.detailsHtml(this.result, skill));
            ++index;
        }
    }

    void addInputKeyListener(KeyListener l) {
        this.searchBar.addKeyListener(l);
    }

    void removeInputKeyListener(KeyListener l) {
        this.searchBar.removeKeyListener(l);
    }

    private HiscoreSkill find(int index) {
        if (index < SKILLS.size()) {
            return SKILLS.get(index);
        }
        switch (index - SKILLS.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return HiscoreSkill.OVERALL;
            }
            case 2: {
                return HiscoreSkill.CLUE_SCROLL_ALL;
            }
            case 3: {
                return HiscoreSkill.LAST_MAN_STANDING;
            }
            case 4: {
                return HiscoreSkill.BOUNTY_HUNTER_ROGUE;
            }
            case 5: {
                return HiscoreSkill.BOUNTY_HUNTER_HUNTER;
            }
        }
        return null;
    }

    private String detailsHtml(HiscoreResult result, HiscoreSkill skill) {
        long experience;
        String openingTags = "<html><body style = 'padding: 5px;color:#989898'>";
        String closingTags = "</html><body>";
        Object content = "";
        if (skill == null) {
            double combatLevel = Experience.getCombatLevelPrecise(result.getAttack().getLevel(), result.getStrength().getLevel(), result.getDefence().getLevel(), result.getHitpoints().getLevel(), result.getMagic().getLevel(), result.getRanged().getLevel(), result.getPrayer().getLevel());
            double combatExperience = result.getAttack().getExperience() + result.getStrength().getExperience() + result.getDefence().getExperience() + result.getHitpoints().getExperience() + result.getMagic().getExperience() + result.getRanged().getExperience() + result.getPrayer().getExperience();
            content = (String)content + "<p><span style = 'color:white'>Skill:</span> Combat</p>";
            content = (String)content + "<p><span style = 'color:white'>Exact Combat Level:</span> " + StackFormatter.formatNumber(combatLevel) + "</p>";
            content = (String)content + "<p><span style = 'color:white'>Experience:</span> " + StackFormatter.formatNumber(combatExperience) + "</p>";
        } else {
            switch (skill) {
                case CLUE_SCROLL_ALL: {
                    String allRank = result.getClueScrollAll().getRank() == -1 ? "Unranked" : StackFormatter.formatNumber(result.getClueScrollAll().getRank());
                    String easyRank = result.getClueScrollEasy().getRank() == -1 ? "Unranked" : StackFormatter.formatNumber(result.getClueScrollEasy().getRank());
                    String mediumRank = result.getClueScrollMedium().getRank() == -1 ? "Unranked" : StackFormatter.formatNumber(result.getClueScrollMedium().getRank());
                    String hardRank = result.getClueScrollHard().getRank() == -1 ? "Unranked" : StackFormatter.formatNumber(result.getClueScrollHard().getRank());
                    String eliteRank = result.getClueScrollElite().getRank() == -1 ? "Unranked" : StackFormatter.formatNumber(result.getClueScrollElite().getRank());
                    String all = result.getClueScrollAll().getLevel() == -1 ? "0" : StackFormatter.formatNumber(result.getClueScrollAll().getLevel());
                    String easy = result.getClueScrollEasy().getLevel() == -1 ? "0" : StackFormatter.formatNumber(result.getClueScrollEasy().getLevel());
                    String medium = result.getClueScrollMedium().getLevel() == -1 ? "0" : StackFormatter.formatNumber(result.getClueScrollMedium().getLevel());
                    String hard = result.getClueScrollHard().getLevel() == -1 ? "0" : StackFormatter.formatNumber(result.getClueScrollHard().getLevel());
                    String elite = result.getClueScrollElite().getLevel() == -1 ? "0" : StackFormatter.formatNumber(result.getClueScrollElite().getLevel());
                    content = (String)content + "<p><span style = 'color:white'>All:</span> " + all + " <span style = 'color:white'>Rank:</span> " + allRank + "</p>";
                    content = (String)content + "<p><span style = 'color:white'>Easy:</span> " + easy + " <span style = 'color:white'>Rank:</span> " + easyRank + "</p>";
                    content = (String)content + "<p><span style = 'color:white'>Medium:</span> " + medium + " <span style = 'color:white'>Rank:</span> " + mediumRank + "</p>";
                    content = (String)content + "<p><span style = 'color:white'>Hard:</span> " + hard + " <span style = 'color:white'>Rank:</span> " + hardRank + "</p>";
                    content = (String)content + "<p><span style = 'color:white'>Elite:</span> " + elite + " <span style = 'color:white'>Rank:</span> " + eliteRank + "</p>";
                    break;
                }
                case BOUNTY_HUNTER_ROGUE: {
                    String rank = result.getBountyHunterRogue().getRank() == -1 ? "Unranked" : StackFormatter.formatNumber(result.getBountyHunterRogue().getRank());
                    content = (String)content + "<p><span style = 'color:white'>Rank:</span> " + rank + "</p>";
                    break;
                }
                case BOUNTY_HUNTER_HUNTER: {
                    String rank = result.getBountyHunterHunter().getRank() == -1 ? "Unranked" : StackFormatter.formatNumber(result.getBountyHunterHunter().getRank());
                    content = (String)content + "<p><span style = 'color:white'>Rank:</span> " + rank + "</p>";
                    break;
                }
                case LAST_MAN_STANDING: {
                    String rank = result.getLastManStanding().getRank() == -1 ? "Unranked" : StackFormatter.formatNumber(result.getLastManStanding().getRank());
                    content = (String)content + "<p><span style = 'color:white'>Rank:</span> " + rank + "</p>";
                    break;
                }
                case OVERALL: {
                    Skill requestedSkill = result.getSkill(skill);
                    String rank = requestedSkill.getRank() == -1 ? "Unranked" : StackFormatter.formatNumber(requestedSkill.getRank());
                    String exp = requestedSkill.getExperience() == -1L ? "Unranked" : StackFormatter.formatNumber(requestedSkill.getExperience());
                    content = (String)content + "<p><span style = 'color:white'>Skill:</span> " + skill.getName() + "</p>";
                    content = (String)content + "<p><span style = 'color:white'>Rank:</span> " + rank + "</p>";
                    content = (String)content + "<p><span style = 'color:white'>Experience:</span> " + exp + "</p>";
                    break;
                }
                default: {
                    int currentLevel;
                    String exp;
                    Skill requestedSkill = result.getSkill(skill);
                    long experience2 = requestedSkill.getExperience();
                    String rank = requestedSkill.getRank() == -1 ? "Unranked" : StackFormatter.formatNumber(requestedSkill.getRank());
                    String string = exp = experience2 == -1L ? "Unranked" : StackFormatter.formatNumber(experience2);
                    String remainingXp = experience2 == -1L ? "Unranked" : ((currentLevel = Experience.getLevelForXp((int)experience2)) + 1 <= 126 ? StackFormatter.formatNumber((long)Experience.getXpForLevel(currentLevel + 1) - experience2) : "0");
                    content = (String)content + "<p><span style = 'color:white'>Skill:</span> " + skill.getName() + "</p>";
                    content = (String)content + "<p><span style = 'color:white'>Rank:</span> " + rank + "</p>";
                    content = (String)content + "<p><span style = 'color:white'>Experience:</span> " + exp + "</p>";
                    content = (String)content + "<p><span style = 'color:white'>Remaining XP:</span> " + remainingXp + "</p>";
                    break;
                }
            }
        }
        if (SKILLS.contains((Object)skill) && (experience = result.getSkill(skill).getExperience()) >= 0L) {
            int currentXp = (int)experience;
            int currentLevel = Experience.getLevelForXp(currentXp);
            int xpForCurrentLevel = Experience.getXpForLevel(currentLevel);
            int xpForNextLevel = currentLevel + 1 <= 126 ? Experience.getXpForLevel(currentLevel + 1) : -1;
            double xpGained = currentXp - xpForCurrentLevel;
            double xpGoal = xpForNextLevel != -1 ? (double)(xpForNextLevel - xpForCurrentLevel) : 100.0;
            int progress = (int)(xpGained / xpGoal * 100.0);
            content = (String)content + "<div style = 'margin-top:3px'><div style = 'background: #070707; border: 1px solid #070707; height: 6px; width: 100%;'><div style = 'height: 6px; width: " + progress + "%; background: #dc8a00;'></div></div></div>";
        }
        return openingTags + (String)content + closingTags;
    }

    private static String sanitize(String lookup) {
        return lookup.replace('\u00a0', ' ');
    }

    private void resetEndpoints() {
        this.tabGroup.select(this.tabGroup.getTab(this.selectWorldEndpoint().ordinal()));
    }

    private HiscoreEndpoint selectWorldEndpoint() {
        if (this.client != null) {
            EnumSet<WorldType> wTypes = this.client.getWorldType();
            if (wTypes.contains((Object)WorldType.DEADMAN_TOURNAMENT)) {
                return HiscoreEndpoint.DEADMAN_TOURNAMENT;
            }
            if (wTypes.contains((Object)WorldType.SEASONAL_DEADMAN)) {
                return HiscoreEndpoint.SEASONAL_DEADMAN;
            }
            if (wTypes.contains((Object)WorldType.DEADMAN)) {
                return HiscoreEndpoint.DEADMAN;
            }
        }
        return HiscoreEndpoint.NORMAL;
    }
}

