/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.herbiboars;

import com.google.inject.Provides;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Tile;
import net.runelite.api.TileObject;
import net.runelite.api.Varbits;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameObjectChanged;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GroundObjectChanged;
import net.runelite.api.events.GroundObjectDespawned;
import net.runelite.api.events.GroundObjectSpawned;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.herbiboars.HerbiboarConfig;
import net.runelite.client.plugins.herbiboars.HerbiboarMinimapOverlay;
import net.runelite.client.plugins.herbiboars.HerbiboarOverlay;
import net.runelite.client.plugins.herbiboars.HerbiboarTrail;
import net.runelite.client.ui.overlay.OverlayManager;

@PluginDescriptor(name="Herbiboar", description="Highlight starting rocks, trails, and the objects to search at the end of each trail", tags={"herblore", "hunter", "skilling", "overlay"})
public class HerbiboarPlugin
extends Plugin {
    private static final List<WorldPoint> END_LOCATIONS = Arrays.asList(new WorldPoint(3693, 3798, 0), new WorldPoint(3702, 3808, 0), new WorldPoint(3703, 3826, 0), new WorldPoint(3710, 3881, 0), new WorldPoint(3700, 3877, 0), new WorldPoint(3715, 3840, 0), new WorldPoint(3751, 3849, 0), new WorldPoint(3685, 3869, 0), new WorldPoint(3681, 3863, 0));
    private static final List<Integer> START_OBJECT_IDS = Arrays.asList(30519, 30520, 30521, 30522, 30523);
    private static final int[] HERBIBOAR_REGIONS = new int[]{14652, 14651, 14908, 14907};
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private HerbiboarOverlay overlay;
    @Inject
    private HerbiboarMinimapOverlay minimapOverlay;
    private boolean inHerbiboarArea;
    private Map<WorldPoint, TileObject> trails = new HashMap<WorldPoint, TileObject>();
    private Map<WorldPoint, TileObject> tunnels = new HashMap<WorldPoint, TileObject>();
    private Map<WorldPoint, TileObject> starts = new HashMap<WorldPoint, TileObject>();
    private Map<WorldPoint, TileObject> trailObjects = new HashMap<WorldPoint, TileObject>();
    private Set<Integer> shownTrails = new HashSet<Integer>();
    private HerbiboarTrail currentTrail;
    private int currentPath;
    private int finishId;

    @Provides
    HerbiboarConfig getConfig(ConfigManager configManager) {
        return configManager.getConfig(HerbiboarConfig.class);
    }

    @Override
    protected void startUp() throws Exception {
        this.overlayManager.add(this.overlay);
        this.overlayManager.add(this.minimapOverlay);
        this.inHerbiboarArea = this.checkArea();
    }

    @Override
    protected void shutDown() throws Exception {
        this.overlayManager.remove(this.overlay);
        this.overlayManager.remove(this.minimapOverlay);
    }

    private void updateTrailData() {
        this.currentTrail = null;
        this.currentPath = -1;
        for (HerbiboarTrail trail : HerbiboarTrail.values()) {
            int trailId = trail.getTrailId();
            int value = this.client.getVar(trail.getVarbit());
            if (value > 0) {
                this.shownTrails.add(trailId);
                this.shownTrails.add(trailId + 1);
            }
            if (value != 1 && value != 2) continue;
            this.currentTrail = trail;
            this.currentPath = value;
        }
        this.finishId = this.client.getVar(Varbits.HB_FINISH);
        if (this.finishId > 0 && this.currentTrail != null) {
            this.shownTrails.add(this.currentTrail.getTrailId());
            this.shownTrails.add(this.currentTrail.getTrailId() + 1);
            this.currentTrail = null;
            this.currentPath = -1;
        }
        int started = this.client.getVar(Varbits.HB_STARTED);
        if (this.currentPath == -1 && this.finishId == 0 && started == 0) {
            this.resetTrailData();
        }
    }

    private void resetTrailData() {
        this.currentPath = 0;
        this.currentTrail = null;
        this.finishId = 0;
        this.shownTrails.clear();
    }

    private void clearCache() {
        this.starts.clear();
        this.trailObjects.clear();
        this.trails.clear();
        this.tunnels.clear();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        switch (event.getGameState()) {
            case HOPPING: 
            case LOGGING_IN: {
                this.resetTrailData();
                break;
            }
            case LOADING: {
                this.clearCache();
                this.inHerbiboarArea = this.checkArea();
                break;
            }
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        if (this.isInHerbiboarArea()) {
            this.updateTrailData();
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        this.onGameObject(event.getTile(), null, event.getGameObject());
    }

    @Subscribe
    public void onGameObjectChanged(GameObjectChanged event) {
        this.onGameObject(event.getTile(), event.getPrevious(), event.getGameObject());
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned event) {
        this.onGameObject(event.getTile(), event.getGameObject(), null);
    }

    @Subscribe
    public void onGroundObjectSpawned(GroundObjectSpawned event) {
        this.onGroundObject(event.getTile(), null, event.getGroundObject());
    }

    @Subscribe
    public void onGroundObjectChanged(GroundObjectChanged event) {
        this.onGroundObject(event.getTile(), event.getPrevious(), event.getGroundObject());
    }

    @Subscribe
    public void onGroundObjectDespawned(GroundObjectDespawned event) {
        this.onGroundObject(event.getTile(), event.getGroundObject(), null);
    }

    private void onGameObject(Tile tile, TileObject oldObject, TileObject newObject) {
        if (oldObject != null) {
            WorldPoint oldLocation = oldObject.getWorldLocation();
            this.trailObjects.remove(oldLocation);
            this.tunnels.remove(oldLocation);
            this.starts.remove(oldLocation);
        }
        if (newObject == null) {
            return;
        }
        if (START_OBJECT_IDS.contains(newObject.getId())) {
            this.starts.put(newObject.getWorldLocation(), newObject);
            return;
        }
        if (HerbiboarTrail.getAllObjectLocs().contains(newObject.getWorldLocation())) {
            this.trailObjects.put(newObject.getWorldLocation(), newObject);
            return;
        }
        if (END_LOCATIONS.contains(newObject.getWorldLocation())) {
            this.tunnels.put(newObject.getWorldLocation(), newObject);
        }
    }

    private void onGroundObject(Tile tile, TileObject oldObject, TileObject newObject) {
        if (oldObject != null) {
            WorldPoint oldLocation = oldObject.getWorldLocation();
            this.trails.remove(oldLocation);
            this.tunnels.remove(oldLocation);
        }
        if (newObject == null) {
            return;
        }
        if (HerbiboarTrail.getTrailIds().contains(newObject.getId())) {
            this.trails.put(newObject.getWorldLocation(), newObject);
            return;
        }
        if (END_LOCATIONS.contains(newObject.getWorldLocation())) {
            this.tunnels.put(newObject.getWorldLocation(), newObject);
        }
    }

    private boolean checkArea() {
        return this.client.getMapRegions() != null && Arrays.stream(this.client.getMapRegions()).filter(x -> Arrays.stream(HERBIBOAR_REGIONS).anyMatch(y -> y == x)).toArray().length > 0;
    }

    public List<WorldPoint> getEndLocations() {
        return END_LOCATIONS;
    }

    public boolean isInHerbiboarArea() {
        return this.inHerbiboarArea;
    }

    public Map<WorldPoint, TileObject> getTrails() {
        return this.trails;
    }

    public Map<WorldPoint, TileObject> getTunnels() {
        return this.tunnels;
    }

    public Map<WorldPoint, TileObject> getStarts() {
        return this.starts;
    }

    public Map<WorldPoint, TileObject> getTrailObjects() {
        return this.trailObjects;
    }

    public Set<Integer> getShownTrails() {
        return this.shownTrails;
    }

    public void setShownTrails(Set<Integer> shownTrails) {
        this.shownTrails = shownTrails;
    }

    public HerbiboarTrail getCurrentTrail() {
        return this.currentTrail;
    }

    public void setCurrentTrail(HerbiboarTrail currentTrail) {
        this.currentTrail = currentTrail;
    }

    public int getCurrentPath() {
        return this.currentPath;
    }

    public void setCurrentPath(int currentPath) {
        this.currentPath = currentPath;
    }

    public int getFinishId() {
        return this.finishId;
    }

    public void setFinishId(int finishId) {
        this.finishId = finishId;
    }
}

