/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.herbiboars;

import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.util.Set;
import net.runelite.api.TileObject;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.plugins.herbiboars.HerbiboarConfig;
import net.runelite.client.plugins.herbiboars.HerbiboarPlugin;
import net.runelite.client.plugins.herbiboars.HerbiboarTrail;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;

class HerbiboarOverlay
extends Overlay {
    private final HerbiboarPlugin plugin;
    private final HerbiboarConfig config;

    @Inject
    public HerbiboarOverlay(HerbiboarPlugin plugin, HerbiboarConfig config) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.plugin = plugin;
        this.config = config;
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        if (!this.plugin.isInHerbiboarArea()) {
            return null;
        }
        HerbiboarTrail currentTrail = this.plugin.getCurrentTrail();
        int finishId = this.plugin.getFinishId();
        if (this.config.isStartShown() && currentTrail == null && finishId == 0) {
            this.plugin.getStarts().values().forEach(obj -> OverlayUtil.renderTileOverlay(graphics, obj, "", this.config.getStartColor()));
        }
        if (this.config.isTrailShown()) {
            Set<Integer> shownTrailIds = this.plugin.getShownTrails();
            this.plugin.getTrails().values().forEach(x -> {
                int id = x.getId();
                if (shownTrailIds.contains(id) && (finishId > 0 || currentTrail != null && currentTrail.getTrailId() != id && currentTrail.getTrailId() + 1 != id)) {
                    OverlayUtil.renderTileOverlay(graphics, x, "", this.config.getTrailColor());
                }
            });
        }
        if (this.config.isObjectShown() && currentTrail != null) {
            WorldPoint[] trailLocs;
            int currentPath = this.plugin.getCurrentPath();
            for (WorldPoint trailLoc : trailLocs = currentTrail.getObjectLocs(currentPath)) {
                TileObject object;
                if (trailLoc == null || (object = this.plugin.getTrailObjects().get(trailLoc)) == null) continue;
                if (this.config.showClickBoxes()) {
                    Area clickbox = object.getClickbox();
                    if (clickbox == null) continue;
                    graphics.setColor(this.config.getObjectColor());
                    graphics.draw(clickbox);
                    graphics.setColor(new Color(255, 0, 255, 20));
                    graphics.fill(clickbox);
                    continue;
                }
                OverlayUtil.renderTileOverlay(graphics, object, "", this.config.getObjectColor());
            }
        }
        if (this.config.isTunnelShown() && finishId > 0) {
            WorldPoint finishLoc = this.plugin.getEndLocations().get(finishId - 1);
            TileObject object = this.plugin.getTunnels().get(finishLoc);
            if (object != null) {
                if (this.config.showClickBoxes()) {
                    Area clickbox = object.getClickbox();
                    if (clickbox != null) {
                        Color col = this.config.getObjectColor();
                        graphics.setColor(col);
                        graphics.draw(clickbox);
                        graphics.setColor(new Color(col.getRed(), col.getGreen(), col.getBlue(), 20));
                        graphics.fill(clickbox);
                    }
                } else {
                    OverlayUtil.renderTileOverlay(graphics, object, "", this.config.getTunnelColor());
                }
            }
        }
        return null;
    }
}

